/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import com.google.gson.JsonObject;
import java.io.Serializable;

public class NamedVelocityDiscon
implements Cloneable,
Serializable {
    String name;
    String preferredName = null;
    double depth;
    public static final String SURFACE = "surface";
    public static final String ICE = "ice";
    public static final String ICEBED = "ice-ocean";
    public static final String ICECRUST = "ice-crust";
    public static final String OCEAN = "ocean";
    public static final String SEABED = "seabed";
    public static final String CRUST = "crust";
    public static final String MOHO = "moho";
    public static final String MANTLE = "mantle";
    public static final String OUTERCORE = "outer-core";
    public static final String CMB = "cmb";
    public static final String INNERCORE = "inner-core";
    public static final String ICOCB = "icocb";
    public static final String IOCB = "iocb";
    public static final String[] knownDisconNames = new String[]{"surface", "ice", "ice-ocean", "ice-crust", "ocean", "seabed", "crust", "moho", "mantle", "outer-core", "cmb", "inner-core", "icocb", "iocb"};

    public NamedVelocityDiscon(double depth) {
        this.name = null;
        this.depth = depth;
    }

    public NamedVelocityDiscon(String name, double depth) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.depth = depth;
        if (name.equalsIgnoreCase(MANTLE)) {
            this.preferredName = MOHO;
        }
        if (name.equalsIgnoreCase(OUTERCORE)) {
            this.preferredName = CMB;
        }
        if (name.equalsIgnoreCase(INNERCORE)) {
            this.preferredName = ICOCB;
        }
    }

    public boolean hasPreferredName() {
        return this.preferredName != null;
    }

    public String getPreferredName() {
        if (this.preferredName != null) {
            return this.preferredName;
        }
        return this.name;
    }

    public boolean isMoho() {
        return NamedVelocityDiscon.isMoho(this.getPreferredName());
    }

    public boolean isCmb() {
        return NamedVelocityDiscon.isCmb(this.getPreferredName());
    }

    public boolean isIocb() {
        return NamedVelocityDiscon.isIcocb(this.getPreferredName());
    }

    public String toString() {
        Object pf_name = "";
        if (this.preferredName != null) {
            pf_name = " (" + this.preferredName + ") ";
        }
        return this.name + (String)pf_name + this.depth;
    }

    public NamedVelocityDiscon clone() throws CloneNotSupportedException {
        return (NamedVelocityDiscon)super.clone();
    }

    public String getName() {
        return this.name;
    }

    public double getDepth() {
        return this.depth;
    }

    public JsonObject asJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        if (this.preferredName != null) {
            json.addProperty("preferredname", this.getName());
        }
        json.addProperty("depth", (Number)Float.valueOf((float)this.getDepth()));
        return json;
    }

    public static boolean isIceBed(String name) {
        return name != null && (name.equalsIgnoreCase(ICEBED) || name.equalsIgnoreCase(ICECRUST));
    }

    public static boolean isSeabed(String name) {
        return name != null && (name.equalsIgnoreCase(SEABED) || name.equalsIgnoreCase(CRUST));
    }

    public static boolean isMoho(String name) {
        return name != null && (name.equalsIgnoreCase(MANTLE) || name.equalsIgnoreCase(MOHO));
    }

    public static boolean isCmb(String name) {
        return name != null && (name.equalsIgnoreCase(CMB) || name.equalsIgnoreCase(OUTERCORE));
    }

    public static boolean isIcocb(String name) {
        return name != null && (name.equalsIgnoreCase(ICOCB) || name.equalsIgnoreCase(IOCB) || name.equalsIgnoreCase(INNERCORE));
    }
}

