/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScatteredSeismicPhase
implements SeismicPhase {
    private final Arrival inboundArrival;
    private final SimpleSeismicPhase scatteredPhase;
    private final Scatterer scatterer;
    private final boolean backscatter;

    public ScatteredSeismicPhase(Arrival inboundArrival, SimpleSeismicPhase scatteredPhase, Scatterer scatterer, boolean backscatter) {
        this.inboundArrival = inboundArrival;
        this.scatteredPhase = scatteredPhase;
        this.scatterer = scatterer;
        this.backscatter = backscatter;
    }

    public Arrival getInboundArrival() {
        return this.inboundArrival;
    }

    public SimpleSeismicPhase getScatteredPhase() {
        return this.scatteredPhase;
    }

    public double getScattererDepth() {
        return this.scatterer.depth;
    }

    public double getScattererDistance() {
        return this.scatterer.getDistanceDegree() * (Math.PI / 180);
    }

    public double getScattererDistanceDeg() {
        return this.scatterer.getDistanceDegree();
    }

    public boolean isBackscatter() {
        return this.backscatter;
    }

    @Override
    public boolean phasesExistsInModel() {
        return this.inboundArrival != null && this.scatteredPhase.phasesExistsInModel();
    }

    @Override
    public Arrival getEarliestArrival(double degrees) {
        return Arrival.getEarliestArrival(DistanceRay.ofDegrees(degrees).calcScatteredPhase(this));
    }

    @Override
    public TauModel getTauModel() {
        return this.scatteredPhase.getTauModel();
    }

    @Override
    public double getMinDistanceDeg() {
        int mulFac = this.getScatterDistMulFactor();
        return this.getScattererDistanceDeg() + (double)mulFac * this.scatteredPhase.getMinDistanceDeg();
    }

    @Override
    public double getMinDistance() {
        int mulFac = this.getScatterDistMulFactor();
        return this.getScattererDistance() + (double)mulFac * this.scatteredPhase.getMinDistance();
    }

    @Override
    public double getMaxDistanceDeg() {
        int mulFac = this.getScatterDistMulFactor();
        return this.getScattererDistanceDeg() + (double)mulFac * this.scatteredPhase.getMaxDistanceDeg();
    }

    @Override
    public double getMaxDistance() {
        int mulFac = this.getScatterDistMulFactor();
        return this.getScattererDistance() + (double)mulFac * this.scatteredPhase.getMaxDistance();
    }

    public int getScatterDistMulFactor() {
        int mulFac = 1;
        if (this.inboundArrival.getSearchDistDeg() > 0.0 && this.isBackscatter()) {
            mulFac = -1;
        }
        if (this.inboundArrival.getSearchDistDeg() < 0.0 && !this.isBackscatter()) {
            mulFac = -1;
        }
        return mulFac;
    }

    @Override
    public double getMaxRayParam() {
        return this.scatteredPhase.getMaxRayParam();
    }

    @Override
    public double getMinRayParam() {
        return this.scatteredPhase.getMinRayParam();
    }

    @Override
    public int getMaxRayParamIndex() {
        return this.scatteredPhase.getMaxRayParamIndex();
    }

    @Override
    public int getMinRayParamIndex() {
        return this.scatteredPhase.getMinRayParamIndex();
    }

    @Override
    public double getMinTime() {
        return this.inboundArrival.getTime() + this.scatteredPhase.getMinTime();
    }

    @Override
    public double getMaxTime() {
        return this.inboundArrival.getTime() + this.scatteredPhase.getMaxTime();
    }

    @Override
    public double getSourceDepth() {
        return this.inboundArrival.getSourceDepth();
    }

    @Override
    public double getReceiverDepth() {
        return this.scatteredPhase.getReceiverDepth();
    }

    @Override
    public String getName() {
        return ScatteredArrival.formScatterPhaseName(this.inboundArrival.getName(), this.scatteredPhase.getName(), this.isBackscatter());
    }

    @Override
    public String getPuristName() {
        return ScatteredArrival.formScatterPhaseName(this.inboundArrival.getPuristName(), this.scatteredPhase.getPuristName(), this.isBackscatter());
    }

    @Override
    public List<List<SeismicPhaseSegment>> getListPhaseSegments() {
        ArrayList<List<SeismicPhaseSegment>> out = new ArrayList<List<SeismicPhaseSegment>>();
        List<SeismicPhaseSegment> inboundSegList = this.inboundArrival.listPhaseSegments();
        for (List<SeismicPhaseSegment> subphaseSeg : this.scatteredPhase.getListPhaseSegments()) {
            ArrayList<SeismicPhaseSegment> inSegList = new ArrayList<SeismicPhaseSegment>();
            inSegList.addAll(inboundSegList);
            inSegList.addAll(subphaseSeg);
            out.add(inSegList);
        }
        return out;
    }

    @Override
    public SeismicPhaseSegment getInitialPhaseSegment() {
        return this.inboundArrival.getPhase().getInitialPhaseSegment();
    }

    @Override
    public SeismicPhaseSegment getFinalPhaseSegment() {
        return this.scatteredPhase.getFinalPhaseSegment();
    }

    @Override
    public int countFlatLegs() {
        return this.inboundArrival.getPhase().countFlatLegs() + this.scatteredPhase.countFlatLegs();
    }

    @Override
    public double getRayParams(int i) {
        return this.scatteredPhase.getRayParams(i);
    }

    @Override
    public double[] getRayParams() {
        return this.scatteredPhase.getRayParams();
    }

    @Override
    public int getNumRays() {
        return this.scatteredPhase.getNumRays();
    }

    @Override
    public double getDist(int i) {
        return this.inboundArrival.getDist() + this.scatteredPhase.getDist(i);
    }

    @Override
    public double[] getDist() {
        double[] scatDist = this.scatteredPhase.getDist();
        double[] out = new double[scatDist.length];
        for (int i = 0; i < scatDist.length; ++i) {
            out[i] = this.getScattererDistance() + scatDist[i];
        }
        return out;
    }

    @Override
    public double getTime(int i) {
        return this.inboundArrival.getTime() + this.scatteredPhase.getTime(i);
    }

    @Override
    public double[] getTime() {
        double[] scatTime = this.scatteredPhase.getTime();
        double[] out = new double[scatTime.length];
        for (int i = 0; i < scatTime.length; ++i) {
            out[i] = this.inboundArrival.getTime() + scatTime[i];
        }
        return out;
    }

    @Override
    public double getTau(int i) {
        return 0.0;
    }

    @Override
    public double[] getTau() {
        return new double[0];
    }

    @Override
    public boolean hasArrivals() {
        return this.inboundArrival != null && this.scatteredPhase.hasArrivals();
    }

    @Override
    public Arrival createArrivalAtIndex(int rayNum) {
        Arrival scatteredArrival = this.scatteredPhase.createArrivalAtIndex(rayNum);
        return new ScatteredArrival(this, DistanceRay.ofDegrees(this.inboundArrival.getDistDeg() + scatteredArrival.getDistDeg()), this.inboundArrival, scatteredArrival, this.isBackscatter());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double calcScatterDistDeg(double deg, double scattererDeg, boolean backscatter) {
        double scatDist;
        double calcDeg = deg % 360.0;
        double calcScatDeg = (180.0 + scattererDeg) % 360.0 - 180.0;
        if (deg > 180.0) {
            calcDeg = 360.0 - calcDeg;
            calcScatDeg *= -1.0;
        }
        if (backscatter) {
            if (calcScatDeg >= 0.0 && calcScatDeg <= calcDeg) {
                scatDist = 360.0 - calcDeg + calcScatDeg;
                return (180.0 + scatDist) % 360.0 - 180.0;
            } else if (calcScatDeg > calcDeg) {
                scatDist = calcScatDeg - calcDeg;
                return (180.0 + scatDist) % 360.0 - 180.0;
            } else {
                if (!(calcScatDeg < 0.0)) throw new RuntimeException("Should never happen " + deg + " " + scattererDeg);
                scatDist = calcDeg - calcScatDeg;
            }
            return (180.0 + scatDist) % 360.0 - 180.0;
        } else if (calcScatDeg >= 0.0 && calcScatDeg <= calcDeg) {
            scatDist = calcDeg - calcScatDeg;
            return (180.0 + scatDist) % 360.0 - 180.0;
        } else if (calcScatDeg > calcDeg) {
            scatDist = 360.0 - calcScatDeg + calcDeg;
            return (180.0 + scatDist) % 360.0 - 180.0;
        } else {
            if (!(calcScatDeg < 0.0)) throw new RuntimeException("Should never happen " + deg + " " + scattererDeg);
            scatDist = 360.0 + calcScatDeg - calcDeg;
        }
        return (180.0 + scatDist) % 360.0 - 180.0;
    }

    @Override
    public Arrival shootRay(double rayParam) {
        throw new IllegalArgumentException("Cannot shoot ray for scattered phase");
    }

    @Override
    public double calcRayParamForTakeoffAngle(double takeoffDegree) throws NoArrivalException {
        if (takeoffDegree == this.inboundArrival.getTakeoffAngleDegree()) {
            return this.inboundArrival.getRayParam();
        }
        throw new NoArrivalException("Scattered phase cannot have arbitrary takeoff angle: " + this.getName());
    }

    @Override
    public double calcRayParamForIncidentAngle(double incidentDegree) throws NoArrivalException {
        return this.getScatteredPhase().calcRayParamForIncidentAngle(incidentDegree);
    }

    @Override
    public double velocityAtSource() {
        return this.inboundArrival.getPhase().velocityAtSource();
    }

    @Override
    public double velocityAtReceiver() {
        return this.scatteredPhase.velocityAtReceiver();
    }

    @Override
    public double densityAtReceiver() {
        return this.scatteredPhase.densityAtReceiver();
    }

    @Override
    public double densityAtSource() {
        return this.inboundArrival.getPhase().densityAtSource();
    }

    @Override
    public double calcTakeoffAngleDegree(double arrivalRayParam) {
        return this.inboundArrival.getTakeoffAngleDegree();
    }

    @Override
    public double calcTakeoffAngle(double arrivalRayParam) {
        return this.inboundArrival.getTakeoffAngleRadian();
    }

    @Override
    public double calcIncidentAngle(double arrivalRayParam) {
        return this.scatteredPhase.calcIncidentAngle(arrivalRayParam);
    }

    @Override
    public double calcIncidentAngleDegree(double arrivalRayParam) {
        return this.scatteredPhase.calcIncidentAngleDegree(arrivalRayParam);
    }

    @Override
    public boolean sourceSegmentIsPWave() {
        return this.getInitialPhaseSegment().isPWave;
    }

    @Override
    public boolean finalSegmentIsPWave() {
        return this.getFinalPhaseSegment().isPWave;
    }

    @Override
    public String describe() {
        String backscatter = this.isBackscatter() ? "backscattered" : "scattered";
        String desc = this.getName() + " " + backscatter + " at " + this.getScattererDepth() + " km and " + this.getScattererDistanceDeg() + " deg:\n";
        desc = desc + SeismicPhase.baseDescribe(this);
        desc = desc + SeismicPhase.segmentDescribe(this);
        String scat_direction = this.isBackscatter() ? "Backscatter" : "Scatter";
        Arrival printArrival = this.inboundArrival;
        if (this.inboundArrival.getSearchDistDeg() < 0.0 && this.inboundArrival.getDistDeg() > 0.0) {
            printArrival = this.inboundArrival.negateDistance();
        }
        desc = desc + "\nInbound to Scatterer: " + this.inboundArrival.getPhase().getName() + "\n" + SeismicPhase.baseDescribe(this.inboundArrival.getPhase()) + "Arrival at Scatterer: " + printArrival + "\n" + scat_direction + " from " + this.scatterer.depth + ", " + this.scatterer.getDistanceDegree() + "\nOutbound from Scatterer: " + this.scatteredPhase.getName() + "\n" + SeismicPhase.baseDescribe(this.scatteredPhase);
        return desc;
    }

    @Override
    public String describeShort() {
        return this.getName() + (String)(this.getName().equals(this.getPuristName()) ? "" : " (" + this.getPuristName() + ")") + " source: " + this.getSourceDepth() + " km, receiver: " + this.getReceiverDepth() + " km, scatter: " + this.getScattererDepth() + " km," + this.getScattererDistanceDeg() + " deg";
    }

    @Override
    public boolean isFail() {
        return this.inboundArrival == null || this.scatteredPhase.isFail();
    }

    @Override
    public String failReason() {
        if (this.isFail()) {
            if (this.inboundArrival == null) {
                return "No inbound arrival to scatterer";
            }
            return this.scatteredPhase.failReason();
        }
        return "";
    }

    @Override
    public void dump() {
        double[] dist = this.scatteredPhase.getDist();
        double[] rayParams = this.scatteredPhase.getRayParams();
        for (int j = 0; j < dist.length; ++j) {
            System.out.println(j + "  " + (this.scatterer.getDistanceDegree() + dist[j]) + "  " + rayParams[j]);
        }
    }

    @Override
    public List<TimeDist> interpPierceTimeDist(Arrival arrival) throws NoArrivalException, TauModelException {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        ScatteredArrival scatA = (ScatteredArrival)arrival;
        double scatDistance = this.inboundArrival.getDist();
        if (scatA.isInboundNegativeDirection()) {
            scatDistance = -1.0 * scatDistance;
            for (TimeDist td : this.inboundArrival.getPierce()) {
                TimeDist btd = new TimeDist(td.getP(), td.getTime(), td.getDistRadian(), td.getDepth());
                out.add(btd);
            }
        } else {
            out.addAll(Arrays.asList(this.inboundArrival.getPierce()));
        }
        List<TimeDist> scatPierce = this.scatteredPhase.interpPierceTimeDist(scatA.getScatteredArrival());
        scatPierce = scatPierce.subList(1, scatPierce.size());
        int scatNegative = 1;
        if (scatA.isScatterNegativeDirection()) {
            scatNegative = -1;
        }
        for (TimeDist td : scatPierce) {
            out.add(new TimeDist(td.getP(), this.inboundArrival.getTime() + td.getTime(), scatDistance + (double)scatNegative * td.getDistRadian(), td.getDepth()));
        }
        return out;
    }

    @Override
    public double calcTstar(Arrival currArrival) throws NoArrivalException {
        return this.inboundArrival.getPhase().calcTstar(this.inboundArrival) + this.scatteredPhase.calcTstar(currArrival);
    }

    @Override
    public boolean isAllPWave() {
        for (List<SeismicPhaseSegment> subList : this.getListPhaseSegments()) {
            for (SeismicPhaseSegment seg : subList) {
                if (seg.isPWave) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isAllSWave() {
        for (List<SeismicPhaseSegment> subList : this.getListPhaseSegments()) {
            for (SeismicPhaseSegment seg : subList) {
                if (!seg.isPWave) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public SeismicPhase interpolatePhase(double maxDeltaDeg) {
        return new ScatteredSeismicPhase(this.inboundArrival, this.scatteredPhase.interpolateSimplePhase(maxDeltaDeg), this.scatterer, this.backscatter);
    }

    @Override
    public double calcEnergyFluxFactorReflTranPSV(Arrival arrival) {
        return 0.0;
    }

    @Override
    public double calcEnergyFluxFactorReflTranSH(Arrival arrival) {
        return 0.0;
    }

    @Override
    public List<ArrivalPathSegment> calcSegmentPaths(Arrival arrival) throws NoArrivalException, SlownessModelException, TauModelException {
        ArrayList<ArrivalPathSegment> out = new ArrayList<ArrivalPathSegment>();
        List<ArrivalPathSegment> inboundPath = this.inboundArrival.getPathSegments();
        for (ArrivalPathSegment seg : inboundPath) {
            seg.arrival = arrival;
            out.add(seg);
        }
        ScatteredArrival scatA = (ScatteredArrival)arrival;
        ArrivalPathSegment lastSeg = inboundPath.get(inboundPath.size() - 1);
        TimeDist prevEnd = lastSeg.getPathEnd();
        List<ArrivalPathSegment> outboundPath = this.scatteredPhase.calcSegmentPaths(scatA.getScatteredArrival(), prevEnd, lastSeg.segmentIndex);
        int segIdx = lastSeg.segmentIndex + 1;
        for (ArrivalPathSegment scatPathSeg : outboundPath) {
            scatPathSeg.segmentIndex = segIdx++;
            scatPathSeg.arrival = arrival;
        }
        out.addAll(outboundPath);
        return out;
    }

    @Override
    public List<ShadowZone> getShadowZones() {
        return this.scatteredPhase.getShadowZones();
    }

    public Scatterer getScatterer() {
        return this.scatterer;
    }
}

