/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import java.util.Locale;
import java.util.Objects;

public class Location
implements LatLonLocatable {
    double latitude;
    double longitude;
    Double depth_meter = null;
    String description = null;
    public static Locale locale = Locale.ROOT;
    public static String latLonFormat = "%8.2f";

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Location(double latitude, double longitude, double depth_meter) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.depth_meter = depth_meter;
    }

    public Location(Station sta) {
        this.latitude = sta.getLatitudeFloat();
        this.longitude = sta.getLongitudeFloat();
        this.depth_meter = null;
        this.setDescription(sta.getSourceId());
    }

    public Location(Channel chan) {
        this.latitude = chan.getLatitudeFloat();
        this.longitude = chan.getLongitudeFloat();
        if (chan.getDepth() != null) {
            this.depth_meter = chan.getDepthFloat();
        }
        this.setDescription(chan.getSourceId());
    }

    public Location(Event ev) {
        this(ev.getPreferredOrigin() != null ? ev.getPreferredOrigin() : (!ev.getOriginList().isEmpty() ? ev.getOriginList().get(0) : null));
    }

    public Location(Origin o) {
        this.latitude = o.getLatitude().getValue().floatValue();
        this.longitude = o.getLongitude().getValue().floatValue();
        if (o.getDepth() != null) {
            this.depth_meter = o.getDepth().getValue().floatValue();
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean hasDepth() {
        return this.getDepthMeter() != null;
    }

    public Double getDepthMeter() {
        return this.depth_meter;
    }

    public Double getDepthKm() {
        return this.hasDepth() ? Double.valueOf(this.getDepthMeter() / 1000.0) : null;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String toString() {
        String out = "(" + this.latitude + ", " + this.longitude + ")";
        out = out + (String)(this.hasDepth() ? " at " + this.depth_meter + " m" : "");
        if (this.hasDescription()) {
            out = out + " " + this.getDescription();
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return Double.compare(this.latitude, location.latitude) == 0 && Double.compare(this.longitude, location.longitude) == 0 && Objects.equals(this.depth_meter, location.depth_meter);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude, this.depth_meter);
    }

    public static String formatLatLon(double latlon) {
        return String.format(locale, latLonFormat, latlon);
    }

    @Override
    public Location asLocation() {
        return this;
    }

    @Override
    public String getLocationDescription() {
        if (this.hasDescription()) {
            return this.getDescription();
        }
        return Location.createLocationDescription(this);
    }

    public static String createLocationDescription(Location loc) {
        String out = Location.formatLatLon(loc.latitude).trim() + "/" + Location.formatLatLon(loc.longitude).trim();
        if (loc.hasDepth()) {
            out = out + " " + Location.formatLatLon(loc.depth_meter).trim() + " m";
        }
        return out;
    }
}

