/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.ISOTimeParser;
import edu.sc.seis.seisFile.TimeUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public abstract class AbstractQueryParams {
    String host = "service.iris.edu";
    int port = 80;
    public int nodata = 204;
    String scheme = "http";
    String fdsnQueryStyle = "query";
    String fdsnwsPath = "fdsnws";
    HashMap<String, String> params = new HashMap();
    public static final String NO_DATA = "nodata";
    public static final String IRIS_HOST = "service.iris.edu";
    public static final String DEFAULT_HOST = "service.iris.edu";
    public static final String FORMAT = "format";
    public static final String NEWLINE = "\n";

    public AbstractQueryParams(String host) {
        this.host = host;
    }

    public void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public void setParam(String key, int value) {
        this.params.put(key, "" + value);
    }

    public void setParam(String key, float value) {
        this.params.put(key, "" + value);
    }

    public void setParam(String key, boolean value) {
        this.params.put(key, value ? "true" : "false");
    }

    public void appendToParam(String key, String value) {
        if (this.params.containsKey(key)) {
            value = this.params.get(key).equals(value) || this.params.get(key).startsWith((String)value + ",") || this.params.get(key).endsWith("," + (String)value) || this.params.get(key).contains("," + (String)value + ",") ? this.params.get(key) : this.params.get(key) + "," + (String)value;
        }
        this.params.put(key, (String)value);
    }

    public void setParam(String key, Instant value) {
        this.setParam(key, value, false);
    }

    public void setParam(String key, Instant value, boolean appendZ) {
        String t = appendZ ? ISOTimeParser.formatWithTimezone(value) : ISOTimeParser.format(value);
        this.setParam(key, t);
    }

    public void clearParam(String key) {
        this.params.remove(key);
    }

    public void clear() {
        this.params.clear();
    }

    public static DateTimeFormatter createDateFormat() {
        return TimeUtils.createFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public URI formURI() throws URISyntaxException {
        this.params = this.getParams();
        if (this.params.size() == 0) {
            throw new IllegalArgumentException("at least one parameter is required");
        }
        StringBuilder newQuery = new StringBuilder();
        if (newQuery.length() != 0) {
            newQuery.append("&");
        }
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(this.params.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            if (this.params.get(key) == null || this.params.get(key).length() == 0) continue;
            newQuery.append(key).append("=").append(this.params.get(key)).append("&");
        }
        if (newQuery.length() > 1) {
            newQuery.deleteCharAt(newQuery.length() - 1);
        }
        return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getPath(), newQuery.toString(), this.getFragment());
    }

    public void setBaseURL(URI uri) {
        this.internalSetBaseURI(uri);
    }

    void cloneNonParams(AbstractQueryParams other) {
        this.host = other.getHost();
        this.port = other.getPort();
        this.scheme = other.getScheme();
        this.fdsnQueryStyle = other.getFdsnQueryStyle();
        this.fdsnwsPath = other.getFdsnwsPath();
    }

    void internalSetBaseURI(URI baseURI) {
        this.setScheme(baseURI.getScheme());
        this.port = baseURI.getPort();
        this.setFdsnwsPath(baseURI.getPath());
        this.host = baseURI.getHost();
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        if (scheme.equalsIgnoreCase("https") && this.getPort() == 80) {
            this.port = 443;
        } else if (scheme.equalsIgnoreCase("http") && this.getPort() == 443) {
            this.port = 80;
        }
    }

    public void useHTTPS() {
        this.setScheme("https");
    }

    public void useHTTP() {
        this.setScheme("http");
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    String getUserInfo() {
        return null;
    }

    String getFragment() {
        return null;
    }

    String getPath() {
        return "/" + this.getFdsnwsPath() + "/" + this.getServiceName() + "/" + this.getFDSNMajorVersion() + "/" + this.getFdsnQueryStyle();
    }

    public String getFdsnwsPath() {
        return this.fdsnwsPath;
    }

    public void setFdsnwsPath(String fdsnwsPath) {
        this.fdsnwsPath = fdsnwsPath;
    }

    public String getFdsnQueryStyle() {
        return this.fdsnQueryStyle;
    }

    public void setFdsnQueryStyle(String queryStyle) {
        this.fdsnQueryStyle = queryStyle;
    }

    public String getFDSNMajorVersion() {
        return "1";
    }

    public abstract String getServiceName();

    public String getHost() {
        return this.host;
    }

    public String getParam(String key) {
        return this.params.get(key);
    }
}

