/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import java.util.HashMap;

public class IRISFedCatQueryParams
extends AbstractQueryParams {
    public static final String TARGET_DATASELECT = "dataselect";
    public static final String TARGET_STATION = "station";
    public static final String FORMAT_TEXT = "text";
    public static final String FORMAT_REQUEST = "request";
    public static final String TARGET_SERVICE = "targetservice";
    FDSNStationQueryParams stationQueryParams = null;
    FDSNDataSelectQueryParams dataSelectQueryParams = null;

    public IRISFedCatQueryParams(FDSNStationQueryParams stationQueryParams) {
        this("service.iris.edu", stationQueryParams);
    }

    public IRISFedCatQueryParams(FDSNDataSelectQueryParams dataSelectQueryParams) {
        this("service.iris.edu", dataSelectQueryParams);
    }

    public IRISFedCatQueryParams(String host, FDSNStationQueryParams stationQueryParams) {
        super(host == null ? "service.iris.edu" : host);
        this.setFdsnwsPath("irisws");
        this.stationQueryParams = stationQueryParams;
    }

    public IRISFedCatQueryParams(String host, FDSNDataSelectQueryParams dataSelectQueryParams) {
        super(host == null ? "service.iris.edu" : host);
        this.setFdsnwsPath("irisws");
        this.dataSelectQueryParams = dataSelectQueryParams;
    }

    public IRISFedCatQueryParams clearFormat() {
        this.clearParam("format");
        return this;
    }

    public IRISFedCatQueryParams setFormat(String value) {
        this.setParam("format", value);
        return this;
    }

    public IRISFedCatQueryParams clearTargetService() {
        this.clearParam(TARGET_SERVICE);
        return this;
    }

    public IRISFedCatQueryParams setTargetService(String value) {
        this.setParam(TARGET_SERVICE, value);
        return this;
    }

    @Override
    public String getServiceName() {
        return "fedcatalog";
    }

    public boolean isStation() {
        return this.stationQueryParams != null;
    }

    public boolean isDataSelect() {
        return this.dataSelectQueryParams != null;
    }

    @Override
    public HashMap<String, String> getParams() {
        HashMap<String, String> out = new HashMap<String, String>();
        out.putAll(this.params);
        if (this.isStation()) {
            out.putAll(this.stationQueryParams.getParams());
            out.put(TARGET_SERVICE, TARGET_STATION);
        }
        if (this.isDataSelect()) {
            out.putAll(this.dataSelectQueryParams.getParams());
            out.put(TARGET_SERVICE, TARGET_DATASELECT);
        }
        return out;
    }
}

