/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.IRISWSVirtualNetworkQueryParams;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualNetworkList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;

public class IRISWSVirtualNetworkQuerier
extends AbstractFDSNQuerier {
    IRISWSVirtualNetworkQueryParams queryParams;

    public IRISWSVirtualNetworkQuerier(IRISWSVirtualNetworkQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public URI formURI() throws URISyntaxException {
        return this.queryParams.formURI();
    }

    @Override
    public URL getSchemaURL() {
        throw new RuntimeException("Virtual network web service does not have schema.");
    }

    public VirtualNetworkList getVirtual() throws FDSNWSException {
        try {
            this.connect();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    try {
                        VirtualNetworkList vnets;
                        VirtualNetworkList virtualNetworkList = vnets = new VirtualNetworkList(this.getReader());
                        return virtualNetworkList;
                    }
                    catch (XMLStreamException e) {
                        this.handleXmlStreamException(e);
                        throw new RuntimeException("Should not happen");
                    }
                }
                VirtualNetworkList e = VirtualNetworkList.createEmptyVirtualNets();
                return e;
            }
            try {
                throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
            }
            catch (URISyntaxException e) {
                throw new FDSNWSException("Error with URL syntax", e);
            }
            catch (SeisFileException e) {
                if (e instanceof FDSNWSException) {
                    ((FDSNWSException)e).setTargetURI(this.getConnectionUri());
                    throw (FDSNWSException)e;
                }
                throw new FDSNWSException(e.getMessage(), e, this.getConnectionUri());
            }
        }
        finally {
            if (this.response != null) {
                try {
                    this.response.close();
                }
                catch (IOException iOException) {}
                this.response = null;
            }
        }
    }
}

