/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SourceTimeFunction {
    public static final String ELEMENT_NAME = "sourceTimeFunction";
    String type;
    Float duration;
    Float riseTime;
    Float decayTime;

    public SourceTimeFunction(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("duration")) {
                    this.duration = Float.valueOf(StaxUtil.pullFloat(reader, "duration"));
                    continue;
                }
                if (elName.equals("riseTime")) {
                    this.riseTime = Float.valueOf(StaxUtil.pullFloat(reader, "riseTime"));
                    continue;
                }
                if (elName.equals("decayTime")) {
                    this.decayTime = Float.valueOf(StaxUtil.pullFloat(reader, "decayTime"));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public Float getRiseTime() {
        return this.riseTime;
    }

    public void setRiseTime(Float riseTime) {
        this.riseTime = riseTime;
    }

    public Float getDecayTime() {
        return this.decayTime;
    }

    public void setDecayTime(Float decayTime) {
        this.decayTime = decayTime;
    }
}

