/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseListElement {
    FloatType frequency;
    FloatType amplitude;
    FloatType phase;

    public ResponseListElement(FloatType frequency, FloatType amplitude, FloatType phase) {
        this.frequency = frequency;
        this.amplitude = amplitude;
        this.phase = phase;
    }

    public ResponseListElement(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("ResponseListElement", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Frequency")) {
                    this.frequency = new FloatType(reader, "Frequency", "HERTZ");
                    continue;
                }
                if (elName.equals("Amplitude")) {
                    this.amplitude = new FloatType(reader, "Amplitude");
                    continue;
                }
                if (elName.equals("Phase")) {
                    this.phase = new FloatType(reader, "Phase", "DEGREE");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public FloatType getFrequency() {
        return this.frequency;
    }

    public FloatType getAmplitude() {
        return this.amplitude;
    }

    public FloatType getPhase() {
        return this.phase;
    }
}

