/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.virtualnet;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.virtualnet.ContributorNetwork;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class VirtualNetwork {
    String code;
    String start;
    String end;
    String description;
    String definition;
    String lastUpdated;
    String steward;
    String certDate;
    String installDate;
    List<ContributorNetwork> contribNetList = new ArrayList<ContributorNetwork>();

    public VirtualNetwork(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("virtualNetwork", reader);
        this.code = StaxUtil.pullAttribute(startE, "code");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("start")) {
                    this.start = StaxUtil.pullText(reader, "start");
                    continue;
                }
                if (elName.equals("end")) {
                    this.end = StaxUtil.pullText(reader, "end");
                    continue;
                }
                if (elName.equals("description")) {
                    this.description = StaxUtil.pullText(reader, "description");
                    continue;
                }
                if (elName.equals("definition")) {
                    this.definition = StaxUtil.pullText(reader, "definition");
                    continue;
                }
                if (elName.equals("lastUpdated")) {
                    this.lastUpdated = StaxUtil.pullText(reader, "lastUpdated");
                    continue;
                }
                if (elName.equals("steward")) {
                    this.steward = StaxUtil.pullText(reader, "steward");
                    continue;
                }
                if (elName.equals("certDate")) {
                    this.certDate = StaxUtil.pullText(reader, "certDate");
                    continue;
                }
                if (elName.equals("installDate")) {
                    this.installDate = StaxUtil.pullText(reader, "installDate");
                    continue;
                }
                if (elName.equals("network")) {
                    this.contribNetList.add(new ContributorNetwork(reader));
                    break;
                }
                System.err.println("VirtualNetwork skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getSteward() {
        return this.steward;
    }

    public String getCertDate() {
        return this.certDate;
    }

    public String getInstallDate() {
        return this.installDate;
    }

    public List<ContributorNetwork> getContribNetList() {
        return this.contribNetList;
    }
}

