/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.mseed3.MSeed3EHKeys;
import edu.sc.seis.seisFile.mseed3.ehbag.Marker;
import edu.sc.seis.seisFile.mseed3.ehbag.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MSeed3EH
implements MSeed3EHKeys {
    JSONObject eh;
    JSONObject bag = null;

    public MSeed3EH() {
        this(new JSONObject());
    }

    public MSeed3EH(JSONObject eh) {
        this.eh = eh;
        if (eh.has("bag")) {
            this.bag = eh.getJSONObject("bag");
        }
    }

    public JSONObject getEH() {
        return this.eh;
    }

    public JSONObject getBagEH() {
        if (this.bag == null) {
            this.bag = new JSONObject();
            this.eh.put("bag", (Object)this.bag);
        }
        return this.bag;
    }

    public void insertLocation(JSONObject json, Location loc) {
        json.put("la", loc.getLatitude());
        json.put("lo", loc.getLongitude());
        json.put("dp", (Object)loc.getDepthMeter());
    }

    public void addToBag(Channel chan) {
        if (chan == null && this.eh.has("bag")) {
            this.getBagEH().remove("ch");
            return;
        }
        JSONObject bagEh = this.getBagEH();
        JSONObject ch = new JSONObject();
        if (chan.getLatitude() != null && chan.getLongitude() != null && chan.getDepth() != null) {
            this.insertLocation(ch, new Location(chan));
        }
        if (chan.getElevation() != null) {
            ch.put("el", chan.getElevation().getValue());
        } else if (chan.getStation().getElevation() != null) {
            ch.put("el", chan.getStation().getElevation().getValue());
        }
        if (chan.getAzimuth() != null) {
            ch.put("az", (Object)chan.getAzimuth());
        }
        if (chan.getDip() != null) {
            ch.put("dip", (Object)chan.getDip());
        }
        bagEh.put("ch", (Object)ch);
    }

    public void addToBag(Path path) {
        if (path == null && this.eh.has("bag")) {
            this.getBagEH().remove("path");
            return;
        }
        JSONObject bagEh = this.getBagEH();
        bagEh.put("path", (Object)path.asJSON());
    }

    public void addToBag(List<Marker> markerList) {
        if (markerList.isEmpty()) {
            return;
        }
        JSONObject bagEh = this.getBagEH();
        if (!bagEh.has("mark")) {
            bagEh.put("mark", (Object)new JSONArray());
        }
        JSONArray markers = bagEh.getJSONArray("mark");
        for (Marker m : markerList) {
            markers.put((Object)m.asJSON());
        }
    }

    public void addToBag(Marker marker) {
        if (marker == null) {
            return;
        }
        JSONObject bagEh = this.getBagEH();
        if (!bagEh.has("mark")) {
            bagEh.put("mark", (Object)new JSONArray());
        }
        JSONArray markers = bagEh.getJSONArray("mark");
        markers.put((Object)marker.asJSON());
    }

    public List<Marker> getMarkers() {
        JSONObject bagEh = this.getBagEH();
        if (!bagEh.has("mark")) {
            return List.of();
        }
        JSONArray markers = bagEh.getJSONArray("mark");
        ArrayList<Marker> out = new ArrayList<Marker>();
        for (int i = 0; i < markers.length(); ++i) {
            out.add(Marker.fromJSON(markers.getJSONObject(i)));
        }
        return out;
    }

    public void setTimeseriesUnit(String siUnit) {
        JSONObject bagEh = this.getBagEH();
        if (!bagEh.has("y")) {
            bagEh.put("y", (Object)new JSONObject());
        }
        JSONObject y = bagEh.getJSONObject("y");
        y.put("si", (Object)siUnit);
    }

    public String getTimeseriesUnit() {
        JSONObject bagEh = this.getBagEH();
        if (bagEh.has("y")) {
            JSONObject y = bagEh.getJSONObject("y");
            return y.optString("si");
        }
        return null;
    }

    public Location channelLocation() {
        Location loc = null;
        if (this.bag != null && this.bag.has("ch")) {
            JSONObject ch = this.bag.getJSONObject("ch");
            float depth = 0.0f;
            if (ch.has("dp")) {
                depth = ch.getFloat("dp");
            }
            loc = new Location(ch.getFloat("la"), ch.getFloat("lo"), depth);
        }
        return loc;
    }

    public void addToBag(Event q) {
        if (q == null) {
            return;
        }
        JSONObject bagEh = this.getBagEH();
        JSONObject ev = new JSONObject();
        ev.put("id", (Object)q.getPublicId());
        JSONObject o = new JSONObject();
        Origin origin = null;
        if (q.getPreferredOrigin() != null) {
            origin = q.getPreferredOrigin();
        } else if (!q.getOriginList().isEmpty()) {
            origin = q.getOriginList().get(0);
        }
        if (origin != null) {
            this.insertLocation(o, new Location(origin));
            o.put("tm", (Object)TimeUtils.toISOString(origin.getTime().asInstant()));
            ev.put("or", (Object)o);
        }
        if (q.getPreferredMagnitude() != null) {
            Magnitude m = q.getPreferredMagnitude();
            JSONObject mag = new JSONObject();
            mag.put("v", (Object)m.getMag().getValue());
            mag.put("t", (Object)m.getType());
            ev.put("mag", (Object)mag);
        }
        bagEh.put("ev", (Object)ev);
    }

    public void addOriginToBag(float lat, float lon, float depthMeter, Instant originTime) {
        JSONObject bagEh = this.getBagEH();
        JSONObject ev = bagEh.has("ev") ? bagEh.getJSONObject("ev") : new JSONObject();
        bagEh.put("ev", (Object)ev);
        JSONObject o = ev.has("or") ? ev.getJSONObject("or") : new JSONObject();
        ev.put("or", (Object)o);
        o.put("la", lat);
        o.put("lo", lon);
        o.put("dp", depthMeter);
        o.put("tm", (Object)TimeUtils.toISOString(originTime));
    }

    public void addMagnitudeToBag(float magVal, String magType) {
        JSONObject bagEh = this.getBagEH();
        JSONObject ev = bagEh.has("ev") ? bagEh.getJSONObject("ev") : new JSONObject();
        bagEh.put("ev", (Object)ev);
        JSONObject mag = new JSONObject();
        mag.put("v", magVal);
        mag.put("t", (Object)magType);
        ev.put("mag", (Object)mag);
    }

    public Location quakeLocation() {
        JSONObject ev;
        Location loc = null;
        if (this.bag != null && this.bag.has("ev") && (ev = this.bag.getJSONObject("ev")).has("or")) {
            JSONObject or = ev.getJSONObject("or");
            float depth = 0.0f;
            if (or.has("dp")) {
                depth = or.getFloat("dp");
            }
            loc = new Location(or.getFloat("la"), or.getFloat("lo"), depth);
        }
        return loc;
    }

    public Instant quakeTime() {
        JSONObject ev;
        Instant time = null;
        if (this.bag != null && this.bag.has("ev") && (ev = this.bag.getJSONObject("ev")).has("or")) {
            JSONObject or = ev.getJSONObject("or");
            return TimeUtils.parseISOString(or.getString("tm"));
        }
        return time;
    }

    public void setQuakeTime(Instant otime) {
        JSONObject ev;
        JSONObject bag = this.getBagEH();
        if (!bag.has("ev")) {
            bag.put("ev", (Object)new JSONObject());
        }
        if (!(ev = bag.getJSONObject("ev")).has("or")) {
            ev.put("or", (Object)new JSONObject());
        }
        JSONObject or = ev.getJSONObject("or");
        or.put("tm", (Object)TimeUtils.toISOString(otime));
    }

    public Float gcarc() {
        JSONObject path;
        if (this.bag != null && this.bag.has("path") && (path = this.bag.getJSONObject("path")).has("gcarc")) {
            return Float.valueOf(path.getFloat("gcarc"));
        }
        return null;
    }

    public void putGcarc(float gcarc) {
        JSONObject bag = this.getBagEH();
        if (!bag.has("path")) {
            bag.put("path", (Object)new JSONObject());
        }
        bag.getJSONObject("path").put("gcarc", gcarc);
    }

    public void addRequestToBag(String datacenter, Instant reqStartTime, Instant reqEndTime, Instant timeOfRequest) {
        JSONObject bag = this.getBagEH();
        JSONObject req = new JSONObject();
        req.put("dc", (Object)datacenter);
        req.put("sttm", (Object)TimeUtils.toISOString(reqStartTime));
        req.put("endtm", (Object)TimeUtils.toISOString(reqEndTime));
        req.put("reqtm", (Object)TimeUtils.toISOString(timeOfRequest));
        if (!bag.has("y")) {
            bag.put("y", (Object)new JSONObject());
        }
        JSONObject y = bag.getJSONObject("y");
        y.put("req", (Object)req);
    }
}

