/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3.ehbag;

import edu.sc.seis.seisFile.TimeUtils;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.json.JSONObject;

public class Marker {
    String name;
    String type;
    ZonedDateTime time;
    String description;

    public Marker(String name, ZonedDateTime time) {
        this(name, time, "", "");
    }

    public Marker(String name, ZonedDateTime time, String type, String description) {
        this.name = name;
        this.type = type;
        this.time = time;
        this.description = description;
    }

    public JSONObject asJSON() {
        JSONObject j = new JSONObject();
        j.put("n", (Object)this.name);
        j.put("tm", (Object)TimeUtils.toISOString(this.time.toInstant()));
        if (this.type.length() > 0) {
            j.put("mtype", (Object)this.type);
        }
        if (this.description.length() > 0) {
            j.put("desc", (Object)this.description);
        }
        return j;
    }

    public static Marker fromJSON(JSONObject j) {
        Marker m = null;
        if (j.has("tm") && j.has("n")) {
            ZonedDateTime time = TimeUtils.parseISOString(j.getString("tm")).atZone(ZoneId.of("UTC"));
            m = new Marker(j.getString("n"), time);
            if (j.has("desc")) {
                m.description = j.getString("desc");
            }
            if (j.has("mtype")) {
                m.type = j.getString("mtype");
            }
        }
        return m;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public void setTime(ZonedDateTime time) {
        this.time = time;
    }
}

