/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import java.io.IOException;

public class SeedlinkPacket {
    private byte[] mseed;
    private String seqNum;
    public static final int HEADER_SIZE = 8;
    public static final int DATA_SIZE = 512;
    public static final String SL_PREFIX = "SL";
    public static final int PACKET_SIZE = 520;

    public SeedlinkPacket(byte[] bytes) throws SeedlinkException {
        if (bytes.length != 520) {
            throw new SeedlinkException("Nunber of bytes must be 520 but given " + bytes.length);
        }
        byte[] headerBytes = new byte[8];
        System.arraycopy(bytes, 0, headerBytes, 0, 8);
        String header = new String(headerBytes);
        if (!header.startsWith(SL_PREFIX)) {
            throw new SeedlinkException("SeedLink packets must start with 'SL', not '" + header.substring(0, SL_PREFIX.length()));
        }
        this.seqNum = header.substring(SL_PREFIX.length());
        this.mseed = new byte[512];
        System.arraycopy(bytes, 8, this.mseed, 0, 512);
    }

    public DataRecord getMiniSeed() throws IOException, SeedFormatException {
        return (DataRecord)SeedRecord.read(this.mseed);
    }

    public byte[] getMseedBytes() {
        return this.mseed;
    }

    public String getSeqNum() {
        return this.seqNum;
    }

    public boolean isInfoPacket() {
        return this.seqNum.startsWith("INFO ");
    }

    public boolean isInfoTerminationPacket() {
        return this.seqNum.equals("INFO  ");
    }

    public boolean isInfoContinuesPacket() {
        return this.seqNum.equals("INFO *");
    }
}

