/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import edu.sc.seis.seisFile.seedlink.SeedlinkState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class SeedlinkReader {
    PushbackInputStream in;
    DataInputStream inData;
    BufferedOutputStream out;
    private Socket socket;
    boolean verbose = false;
    boolean debug = false;
    int timeoutSeconds;
    int connectTimeoutSeconds;
    List<String> sentCommands = new ArrayList<String>();
    SeedlinkState seedlinkState;
    private PrintWriter verboseWriter;
    public String lastSeqNum = "";
    public static final String EMPTY = "";
    public static final String DATA_TYPE = "D";
    public static final String DATA_COMMAND = "DATA";
    public static final String TIME_COMMAND = "TIME";
    public static final String DEFAULT_HOST = "rtserve.iris.washington.edu";
    public static final int DEFAULT_PORT = 18000;
    public static final int DEFAULT_TIMEOUT_SECOND = 120;
    public static final String INFO_ID = "ID";
    public static final String INFO_CAPABILITIES = "CAPABILITIES";
    public static final String INFO_STATIONS = "STATIONS";
    public static final String INFO_STREAMS = "STREAMS";
    public static final String INFO_GAPS = "GAPS";
    public static final String INFO_CONNECTIONS = "CONNECTIONS";
    public static final String INFO_ALL = "ALL";

    public SeedlinkReader() throws IOException {
        this(DEFAULT_HOST, 18000);
    }

    public SeedlinkReader(boolean verbose) throws IOException {
        this(DEFAULT_HOST, 18000, verbose);
    }

    public SeedlinkReader(String host) throws IOException {
        this(host, 18000);
    }

    public SeedlinkReader(String host, boolean verbose) throws IOException {
        this(host, 18000, verbose);
    }

    public SeedlinkReader(String host, int port) throws IOException {
        this(host, port, 120);
    }

    public SeedlinkReader(String host, int port, boolean verbose) throws IOException {
        this(host, port, 120, verbose);
    }

    public SeedlinkReader(String host, int port, int timeoutSeconds) throws IOException {
        this(host, port, timeoutSeconds, false);
    }

    public SeedlinkReader(String host, int port, int timeoutSeconds, boolean verbose) throws IOException {
        this(host, port, timeoutSeconds, verbose, timeoutSeconds);
    }

    public SeedlinkReader(String host, int port, int timeoutSeconds, boolean verbose, int connectTimeoutSeconds) throws IOException {
        this.setVerbose(verbose);
        this.timeoutSeconds = timeoutSeconds;
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.seedlinkState = new SeedlinkState(host, port, this.sentCommands);
        this.initConnection();
    }

    public SeedlinkReader(SeedlinkState state) {
        this(state, 120, false, 120);
    }

    public SeedlinkReader(SeedlinkState state, int timeoutSeconds, boolean verbose, int connectTimeoutSeconds) {
        this.setVerbose(verbose);
        this.timeoutSeconds = timeoutSeconds;
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.sentCommands = state.getCommandList();
        this.lastSeqNum = state.getGlobalLastSequence();
        this.seedlinkState = state;
    }

    private void initConnection() throws IOException {
        if (this.isVerbose()) {
            this.getVerboseWriter().println("Init SeedLink to " + this.getHost() + " " + this.getPort());
        }
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.getHost(), this.getPort()), this.connectTimeoutSeconds * 1000);
        this.socket.setSoTimeout(this.timeoutSeconds * 1000);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()), 3);
        this.inData = new DataInputStream(this.in);
    }

    public boolean hasNext() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        byte[] startBits = new byte[]{(byte)this.in.read(), (byte)this.in.read(), (byte)this.in.read()};
        String start = new String(startBits);
        if (start.equals("END")) {
            if (this.isVerbose()) {
                this.getVerboseWriter().println("END received");
            }
            return false;
        }
        this.in.unread(startBits);
        return true;
    }

    public boolean available() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        return this.in.available() > 256;
    }

    public int availableBytes() throws IOException {
        return this.in.available();
    }

    public String getInfoString() throws IOException, SeedlinkException, SeedFormatException {
        return this.getInfoString(INFO_STREAMS);
    }

    public String getInfoString(String infoType) throws IOException, SeedlinkException, SeedFormatException {
        return this.getInfoString(infoType, true);
    }

    public String getInfoString(String infoType, boolean addNewlines) throws IOException, SeedlinkException, SeedFormatException {
        SeedlinkPacket infoPacket;
        this.info(infoType);
        StringBuilder infoPacketContents = new StringBuilder();
        do {
            infoPacket = this.next();
            String s = new String(infoPacket.getMiniSeed().getData());
            infoPacketContents.append(s);
        } while (infoPacket.isInfoContinuesPacket());
        String infoString = infoPacketContents.toString();
        if (addNewlines) {
            infoString = infoString.replaceAll("><", ">\n<").trim();
        }
        return infoString;
    }

    public SeedlinkPacket next() throws IOException, SeedlinkException {
        if (!this.hasNext()) {
            throw new SeedlinkException("no more seed link packets from last command");
        }
        return this.readPacket();
    }

    public SeedlinkPacket readPacket() throws IOException, SeedlinkException {
        if (this.debug) {
            this.getVerboseWriter().println("readPacket(): blocking read for 520 bytes, available=" + this.in.available());
        }
        byte[] bits = new byte[520];
        this.inData.readFully(bits);
        SeedlinkPacket slp = new SeedlinkPacket(bits);
        this.lastSeqNum = slp.getSeqNum();
        this.seedlinkState.updateGlobalSequence(this.lastSeqNum);
        if (this.isVerbose()) {
            Object packetString = EMPTY;
            try {
                DataRecord dr = slp.getMiniSeed();
                packetString = " Got a packet: " + slp.getSeqNum() + "  " + dr.getHeader().getNetworkCode() + "  " + dr.getHeader().getStationIdentifier() + "  " + dr.getHeader().getLocationIdentifier() + "  " + dr.getHeader().getChannelIdentifier() + "  " + dr.getHeader().getStartTime() + " " + dr.getHeader().getNumSamples();
            }
            catch (SeedFormatException e) {
                packetString = "SeedFormatExcpetion parsing packet: " + slp.getSeqNum() + e.getMessage();
            }
            this.getVerboseWriter().println((String)packetString);
        }
        return slp;
    }

    public void info(String level) throws IOException {
        this.send("INFO " + level);
    }

    public void endHandshake() throws IOException {
        this.send("END");
    }

    public void close() {
        if (this.out != null) {
            try {
                this.send("BYE");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.in.close();
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void reconnect() throws IOException, SeedlinkException {
        this.close();
        this.initConnection();
        for (String cmd : this.sentCommands) {
            this.internalSendCmd(cmd);
        }
        this.endHandshake();
    }

    @Deprecated
    public void resume() throws IOException, SeedlinkException {
        this.close();
        this.initConnection();
        String nextSeqCmd = "DATA " + SeedlinkReader.nextSeq(this.seedlinkState.getGlobalLastSequence());
        for (String cmd : this.sentCommands) {
            if (!cmd.startsWith(DATA_COMMAND) && !cmd.startsWith(TIME_COMMAND)) {
                this.internalSendCmd(cmd);
                continue;
            }
            this.internalSendCmd(nextSeqCmd);
        }
        this.endHandshake();
    }

    public static SeedlinkReader resumeGlobalSequence(SeedlinkState seedlinkState) throws IOException, SeedlinkException {
        return SeedlinkReader.resumeGlobalSequence(seedlinkState, false);
    }

    public static SeedlinkReader resumeGlobalSequence(SeedlinkState seedlinkState, boolean verbose) throws IOException, SeedlinkException {
        SeedlinkReader reader = new SeedlinkReader(seedlinkState);
        reader.setVerbose(verbose);
        reader.initConnection();
        String nextSeqCmd = "DATA " + SeedlinkReader.nextSeq(seedlinkState.getGlobalLastSequence());
        for (String cmd : seedlinkState.getCommandList()) {
            if (!cmd.startsWith(DATA_COMMAND) && !cmd.startsWith(TIME_COMMAND)) {
                reader.internalSendCmd(cmd);
                continue;
            }
            reader.internalSendCmd(nextSeqCmd);
        }
        return reader;
    }

    /*
     * WARNING - void declaration
     */
    public static SeedlinkReader resume(SeedlinkState seedlinkState, boolean verbose) throws IOException, SeedlinkException {
        for (String string : seedlinkState.getCommandList()) {
            if (!string.startsWith("STATION") || !SeedlinkReader.containsWildcard(string)) continue;
            throw new SeedlinkException("Unable to resume from per-station sequence numbers when using STATION wildcards:" + string);
        }
        SeedlinkReader reader = new SeedlinkReader(seedlinkState);
        reader.setVerbose(verbose);
        reader.initConnection();
        if (reader.isVerbose()) {
            for (String k : seedlinkState.keySet()) {
                reader.getVerboseWriter().println("Resume: '" + k + "' after " + seedlinkState.getMap().get(k));
            }
        }
        Object var3_6 = null;
        String lastNet = null;
        for (String cmd : seedlinkState.getCommandList()) {
            String resumeCmd;
            void var3_7;
            if (cmd.startsWith("STATION")) {
                if (var3_7 != null) {
                    if (seedlinkState.contains(lastNet, (String)var3_7)) {
                        resumeCmd = SeedlinkReader.createResumeDataCommand(lastNet, (String)var3_7, seedlinkState);
                        reader.internalSendCmd(resumeCmd);
                    } else {
                        reader.internalSendCmd(DATA_COMMAND);
                    }
                    Object var3_8 = null;
                    lastNet = null;
                }
                String[] splitCmd = cmd.split(" +");
                String string = splitCmd[1];
                lastNet = splitCmd[2];
            }
            if (!cmd.startsWith(DATA_COMMAND) && !cmd.startsWith(TIME_COMMAND)) {
                reader.internalSendCmd(cmd);
                continue;
            }
            if (seedlinkState.contains(lastNet, (String)var3_7)) {
                resumeCmd = SeedlinkReader.createResumeDataCommand(lastNet, (String)var3_7, seedlinkState);
                reader.internalSendCmd(resumeCmd);
            } else {
                System.out.println("Last for station not found: " + (String)var3_7);
                reader.internalSendCmd(DATA_COMMAND);
            }
            Object var3_11 = null;
        }
        return reader;
    }

    public static String createResumeDataCommand(String lastNet, String lastStation, SeedlinkState state) {
        if (state.contains(lastNet, lastStation)) {
            String staSeq = state.getForStation(lastNet, lastStation);
            return "DATA " + SeedlinkReader.nextSeq(staSeq);
        }
        System.out.println("Last for station not found: " + lastStation);
        return DATA_COMMAND;
    }

    public static String nextSeq(String seq) {
        Object next = Integer.toHexString(Integer.parseInt(seq, 16) + 1).toUpperCase();
        while (((String)next).length() < 6) {
            next = "0" + (String)next;
        }
        return next;
    }

    public static boolean containsWildcard(String cmd) {
        return cmd.contains("*") || cmd.contains("?");
    }

    public String[] sendHello() throws IOException, SeedlinkException {
        this.send("HELLO");
        String[] lines = new String[]{this.readLine(), this.readLine()};
        return lines;
    }

    protected String readLine() throws IOException, SeedlinkException {
        StringBuffer buf = new StringBuffer();
        int next = this.in.read();
        while (next != 13 && next != 10 && this.in.available() > 0) {
            buf.append((char)next);
            next = this.in.read();
            if (next != -1) continue;
            throw new SeedlinkException("read returned -1, socket closed??? buf=" + String.valueOf(buf));
        }
        if (this.isVerbose()) {
            this.getVerboseWriter().println("recv '" + String.valueOf(buf) + "'");
        }
        if ((next = this.in.read()) != 10 && next != 13 && next != -1) {
            this.in.unread(next);
        }
        return buf.toString();
    }

    public void sendCmd(String cmd) throws IOException, SeedlinkException {
        this.internalSendCmd(cmd);
        this.sentCommands.add(cmd);
    }

    @Deprecated
    public void select(String network, String station, String location, String channel) throws SeedlinkException, IOException {
        this.select(network, station, location, channel, DATA_TYPE);
    }

    public void selectData(String network, String station, List<String> locchan) throws SeedlinkException, IOException {
        this.selectDataOfType(network, station, locchan, DATA_TYPE);
    }

    @Deprecated
    public void selectOfType(String network, String station, List<String> locchan, String type) throws SeedlinkException, IOException {
        this.sendStation(network, station);
        if (locchan.isEmpty()) {
            this.sendSelect("???");
            this.sendSelect("?????");
        }
        for (String lc : locchan) {
            this.sendSelect(lc, type);
        }
    }

    public void selectDataOfType(String network, String station, List<String> locchan, String type) throws SeedlinkException, IOException {
        this.selectOfType(network, station, locchan, type);
        this.sendData();
    }

    public void selectData(String network, String station, List<String> locchan, String seqNum) throws SeedlinkException, IOException {
        this.selectDataOfType(network, station, locchan, seqNum, DATA_TYPE);
    }

    public void selectDataOfType(String network, String station, List<String> locchan, String seqNum, String type) throws SeedlinkException, IOException {
        this.selectOfType(network, station, locchan, type);
        this.sendData(seqNum);
        if (!SeedlinkReader.containsWildcard(network) && !SeedlinkReader.containsWildcard(station)) {
            this.seedlinkState.put(network, station, seqNum);
        }
    }

    public void selectData(String network, String station, List<String> locchan, Instant start) throws SeedlinkException, IOException {
        this.selectDataOfType(network, station, locchan, start, DATA_TYPE);
    }

    public void selectDataOfType(String network, String station, List<String> locchan, Instant start, String type) throws SeedlinkException, IOException {
        this.selectOfType(network, station, locchan, type);
        this.sendData(start);
    }

    public void selectTime(String network, String station, List<String> locchan, Instant start) throws SeedlinkException, IOException {
        this.selectTimeOfType(network, station, locchan, start, null, DATA_TYPE);
    }

    public void selectTime(String network, String station, List<String> locchan, Instant start, Instant end) throws SeedlinkException, IOException {
        this.selectTimeOfType(network, station, locchan, start, end, DATA_TYPE);
    }

    public void selectTimeOfType(String network, String station, List<String> locchan, Instant start, Instant end, String type) throws SeedlinkException, IOException {
        this.selectOfType(network, station, locchan, type);
        this.sendTime(start, end);
    }

    @Deprecated
    public void select(String network, String station, String location, String channel, String type) throws SeedlinkException, IOException {
        if (channel.isEmpty()) {
            channel = "???";
        }
        this.sendStation(network, station);
        this.sendSelect(location + channel, type);
    }

    public void sendStation(String network, String station) throws SeedlinkException, IOException {
        if (network.isEmpty()) {
            network = "*";
        }
        if (station.isEmpty()) {
            station = "*";
        }
        this.sendCmd("STATION " + station + " " + network);
    }

    public void sendSelect(String locationChannel) throws SeedlinkException, IOException {
        this.sendSelect(locationChannel, DATA_TYPE);
    }

    public void sendSelect(String locationChannel, String type) throws SeedlinkException, IOException {
        if (locationChannel.isEmpty()) {
            locationChannel = "*";
        }
        this.sendCmd("SELECT " + locationChannel + "." + type);
    }

    @Deprecated
    public void startData() throws SeedlinkException, IOException {
        this.startData(EMPTY, EMPTY);
    }

    @Deprecated
    public void startData(Instant start, Instant end) throws SeedlinkException, IOException {
        DateTimeFormatter seedlinkFormat = TimeUtils.createFormatter("yyyy,MM,dd,HH,mm,ss");
        String startStr = start == null ? EMPTY : seedlinkFormat.format(start);
        String endStr = end == null ? EMPTY : seedlinkFormat.format(end);
        this.startData(startStr, endStr);
    }

    @Deprecated
    public void startData(String start, String end) throws SeedlinkException, IOException {
        if (start == null || start.isEmpty()) {
            this.sendCmd(DATA_COMMAND);
        } else if (end == null || end.isEmpty()) {
            this.sendCmd("TIME " + start);
        } else {
            this.sendCmd("TIME " + start + " " + end);
        }
        this.endHandshake();
    }

    public void sendData() throws SeedlinkException, IOException {
        this.sendCmd(DATA_COMMAND);
    }

    public void sendData(String seqNum) throws SeedlinkException, IOException {
        this.sendCmd("DATA " + seqNum);
    }

    public void sendData(Instant start) throws SeedlinkException, IOException {
        this.sendData("000000", start);
    }

    public void sendData(String seqNum, Instant start) throws SeedlinkException, IOException {
        DateTimeFormatter seedlinkFormat = TimeUtils.createFormatter("yyyy,MM,dd,HH,mm,ss");
        String startStr = start == null ? EMPTY : seedlinkFormat.format(start);
        this.sendCmd("DATA " + seqNum + " " + startStr);
    }

    public void sendTime(Instant start) throws SeedlinkException, IOException {
        this.sendTime(start, null);
    }

    public void sendTime(Instant start, Instant end) throws SeedlinkException, IOException {
        DateTimeFormatter seedlinkFormat = TimeUtils.createFormatter("yyyy,MM,dd,HH,mm,ss");
        String startStr = start == null ? EMPTY : seedlinkFormat.format(start);
        String endStr = end == null ? EMPTY : seedlinkFormat.format(end);
        this.sendCmd("TIME " + startStr + " " + endStr);
    }

    @Deprecated
    public void restartData(String seqNum) throws SeedlinkException, IOException {
        this.lastSeqNum = seqNum;
        this.seedlinkState.updateGlobalSequence(seqNum);
        this.sendCmd("DATA " + this.lastSeqNum);
        this.endHandshake();
    }

    protected void internalSendCmd(String cmd) throws IOException, SeedlinkException {
        this.send(cmd);
        String line = this.readLine();
        if (!line.equals("OK")) {
            throw new SeedlinkException("Command " + cmd + " did not return OK");
        }
    }

    void send(String cmd) throws IOException {
        if (this.isVerbose()) {
            this.getVerboseWriter().println("send '" + cmd + "'");
        }
        this.out.write((cmd + "\r").getBytes());
        this.out.flush();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out, true);
        }
    }

    public PrintWriter getVerboseWriter() {
        if (this.verbose && this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out, true);
        }
        return this.verboseWriter;
    }

    public void setVerboseWriter(PrintWriter verboseWriter) {
        this.verboseWriter = verboseWriter;
    }

    public String getHost() {
        return this.seedlinkState.getHost();
    }

    public int getPort() {
        return this.seedlinkState.getPort();
    }

    public SeedlinkState getState() {
        return this.seedlinkState;
    }
}

