/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;

public class DistAz {
    public static final double wgs85_invflattening = 298.257223563;
    public static final double wgs85_flattening = 0.0033528106647474805;
    public static final double wgs85_meanEarthRadius = 6371.0088;
    private final double delta;
    private double az;
    private double baz;
    private final double stalat;
    private final double stalon;
    private final double evtlat;
    private final double evtlon;

    public DistAz(LatLonLocatable loc1, LatLonLocatable loc2) {
        this(loc1.asLocation(), loc2.asLocation());
    }

    public DistAz(LatLonLocatable loc1, LatLonLocatable loc2, double flattening) {
        this(loc1.asLocation(), loc2.asLocation(), flattening);
    }

    public DistAz(Location loc1, Location loc2) {
        this(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public DistAz(Location loc1, Location loc2, double flattening) {
        this(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude(), flattening);
    }

    public DistAz(double lat1, double lon1, double lat2, double lon2) {
        this(lat1, lon1, lat2, lon2, 0.0033528106647474805);
    }

    public DistAz(double lat1, double lon1, double lat2, double lon2, double flattening) {
        this.evtlat = lat1;
        this.evtlon = lon1;
        this.stalat = lat2;
        this.stalon = lon2;
        if (lat1 == lat2 && lon1 == lon2) {
            this.delta = 0.0;
            this.az = 0.0;
            this.baz = 0.0;
            return;
        }
        double rad = Math.PI / 180;
        double sph = flattening;
        double scolat = 1.5707963267948966 - Math.atan((1.0 - sph) * (1.0 - sph) * Math.tan(this.stalat * rad));
        double ecolat = 1.5707963267948966 - Math.atan((1.0 - sph) * (1.0 - sph) * Math.tan(this.evtlat * rad));
        double slon = this.stalon * rad;
        double elon = this.evtlon * rad;
        double a = Math.sin(scolat) * Math.cos(slon);
        double b = Math.sin(scolat) * Math.sin(slon);
        double c = Math.cos(scolat);
        double d = Math.sin(slon);
        double e = -Math.cos(slon);
        double g = -c * e;
        double h = c * d;
        double k = -Math.sin(scolat);
        double aa = Math.sin(ecolat) * Math.cos(elon);
        double bb = Math.sin(ecolat) * Math.sin(elon);
        double cc = Math.cos(ecolat);
        double dd = Math.sin(elon);
        double ee = -Math.cos(elon);
        double gg = -cc * ee;
        double hh = cc * dd;
        double kk = -Math.sin(ecolat);
        double del = Math.acos(a * aa + b * bb + c * cc);
        this.delta = del / rad;
        double rhs1 = (aa - d) * (aa - d) + (bb - e) * (bb - e) + cc * cc - 2.0;
        double rhs2 = (aa - g) * (aa - g) + (bb - h) * (bb - h) + (cc - k) * (cc - k) - 2.0;
        double dbaz = Math.atan2(rhs1, rhs2);
        if (dbaz < 0.0) {
            dbaz += Math.PI * 2;
        }
        this.baz = dbaz / rad;
        rhs1 = (a - dd) * (a - dd) + (b - ee) * (b - ee) + c * c - 2.0;
        rhs2 = (a - gg) * (a - gg) + (b - hh) * (b - hh) + (c - kk) * (c - kk) - 2.0;
        double daz = Math.atan2(rhs1, rhs2);
        if (daz < 0.0) {
            daz += Math.PI * 2;
        }
        this.az = daz / rad;
        if (Math.abs(this.baz - 360.0) < 1.0E-5) {
            this.baz = 0.0;
        }
        if (Math.abs(this.az - 360.0) < 1.0E-5) {
            this.az = 0.0;
        }
    }

    public double getDelta() {
        return this.delta;
    }

    public double getAz() {
        return this.az;
    }

    public double getBaz() {
        return this.baz;
    }

    public double getRadialAzimuth() {
        return (180.0 + this.getBaz()) % 360.0;
    }

    public double getTransverseAzimuth() {
        return (270.0 + this.getBaz()) % 360.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DistAz) {
            DistAz oAz = (DistAz)o;
            if (oAz.stalat == this.stalat && oAz.stalon == this.stalon && oAz.evtlat == this.evtlat && oAz.evtlon == this.evtlon) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 24;
        result = 37 * result + Double.hashCode(this.stalat);
        result = 37 * result + Double.hashCode(this.stalon);
        result = 37 * result + Double.hashCode(this.evtlat);
        result = 37 * result + Double.hashCode(this.evtlon);
        return result;
    }

    public static double kmPerDeg() {
        return DistAz.kmPerDeg(6371.0088);
    }

    public static double kmPerDeg(double radius) {
        return Math.PI * radius / 180.0;
    }

    public static double degreesToKilometers(double degrees) {
        return degrees * DistAz.kmPerDeg();
    }

    public static double degreesToKilometers(double degrees, double radius) {
        return degrees * DistAz.kmPerDeg(radius);
    }

    public static double kilometersToDegrees(double kilometers, double radius) {
        return kilometers / DistAz.kmPerDeg(radius);
    }
}

