/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.TimeUtils;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISOTimeParser {
    private boolean ceiling;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final String ISO_TIME_RE = "(\\-?\\d{4})-?(\\d{2})?-?(\\d{2})?(T)?(\\d{2})?:?(\\d{2})?:?(\\d{2})?\\.?(\\d)?(Z)?";
    private static Pattern datePattern = Pattern.compile("(\\-?\\d{4})-?(\\d{2})?-?(\\d{2})?(T)?(\\d{2})?:?(\\d{2})?:?(\\d{2})?\\.?(\\d)?(Z)?");
    public static final String FIRST_SEISMOGRAM = "1889-04-17";
    private static String YESTERDAY = "yesterday";

    public ISOTimeParser() {
        this(true);
    }

    public ISOTimeParser(boolean ceiling) {
        this.ceiling = ceiling;
    }

    public Object parse(String arg) {
        return this.getDate(arg);
    }

    public String parseDate(String arg) {
        return ISOTimeParser.format(this.getDate(arg));
    }

    public static String format(Instant d) {
        DateTimeFormatter isoFormat = TimeUtils.createFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return isoFormat.format(d);
    }

    public static String formatWithTimezone(Instant d) {
        DateTimeFormatter isoFormat = TimeUtils.createFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return isoFormat.format(d) + "Z";
    }

    public static String formatForParsing(Instant d) {
        DateTimeFormatter isoFormat = TimeUtils.createFormatter("yyyy-MM-dd'T'HH:mm:ss");
        return isoFormat.format(d);
    }

    public Instant getDate(String arg) {
        if (arg.equals("now")) {
            return Instant.now();
        }
        if (arg.equals(YESTERDAY)) {
            return this.yesterday();
        }
        Matcher m = datePattern.matcher(arg);
        if (!m.matches()) {
            throw new IllegalArgumentException("A time must be formatted as YYYY[[[[[-MM]-DD]Thh]:mm]:ss] like 2006-11-19 or 2006-11-19T06:34:21, not '" + arg + "'");
        }
        int year = ISOTimeParser.extract(m, 1, 1970);
        int month = ISOTimeParser.extract(m, 2, this.ceiling ? 12 : 1);
        YearMonth ym = YearMonth.of(year, month);
        int dayOfMonth = ISOTimeParser.extract(m, 3, this.ceiling ? ym.lengthOfMonth() : 1);
        int hour = ISOTimeParser.extract(m, 5, this.ceiling ? 23 : 0);
        int minute = ISOTimeParser.extract(m, 6, this.ceiling ? 59 : 0);
        int second = ISOTimeParser.extract(m, 7, this.ceiling ? 59 : 0);
        int nanoOfSecond = ISOTimeParser.extract(m, 8, this.ceiling ? 999999999 : 0);
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, TimeUtils.TZ_UTC).toInstant();
    }

    private static int extract(Matcher m, int i, int defaultValue) {
        if (m.group(i) == null) {
            return defaultValue;
        }
        return Integer.parseInt(m.group(i));
    }

    public Instant yesterday() {
        ZonedDateTime now = Instant.now().atZone(TimeUtils.TZ_UTC);
        return ZonedDateTime.of(now.getYear(), now.getMonthValue(), now.getDayOfMonth(), 0, 0, 0, 0, TimeUtils.TZ_UTC).minus(TimeUtils.ONE_DAY).toInstant();
    }
}

