/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.earthworm.EarthwormEscapeOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthwormHeartbeater
extends TimerTask {
    EarthwormEscapeOutputStream outStream;
    int heartbeatSeconds;
    String heartbeatMessage;
    int institution;
    int module;
    boolean verbose = false;
    private static final Logger logger = LoggerFactory.getLogger(EarthwormHeartbeater.class);

    public EarthwormHeartbeater(EarthwormEscapeOutputStream outStream, int heartbeatSeconds, String heartbeatMessage, int institution, int module) {
        this.outStream = outStream;
        this.heartbeatSeconds = heartbeatSeconds;
        this.heartbeatMessage = heartbeatMessage;
        Timer heartbeater = new Timer("HeartbeatTimer", true);
        heartbeater.schedule((TimerTask)this, 100L, (long)(heartbeatSeconds * 1000));
    }

    public EarthwormEscapeOutputStream getOutStream() {
        return this.outStream;
    }

    public void setOutStream(EarthwormEscapeOutputStream outStream) {
        this.outStream = outStream;
    }

    public int getHeartbeatSeconds() {
        return this.heartbeatSeconds;
    }

    public String getHeartbeatMessage() {
        return this.heartbeatMessage;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void run() {
        try {
            this.heartbeat();
        }
        catch (IOException e) {
            logger.error("IOException with heartbeat, closing connection.", (Throwable)e);
            EarthwormEscapeOutputStream.closeIfNotNull(this.outStream);
            this.outStream = null;
        }
        catch (Throwable t) {
            logger.warn("non-IOException sending heartbeat: ", t);
            EarthwormEscapeOutputStream.closeIfNotNull(this.outStream);
            this.outStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeat() throws IOException {
        EarthwormEscapeOutputStream outStreamTmp = this.outStream;
        if (outStreamTmp == null) {
            logger.info("outStream is null, skipping heartbeat");
            return;
        }
        EarthwormEscapeOutputStream earthwormEscapeOutputStream = outStreamTmp;
        synchronized (earthwormEscapeOutputStream) {
            outStreamTmp.startTransmit();
            outStreamTmp.writeThreeChars(this.institution);
            outStreamTmp.writeThreeChars(this.module);
            outStreamTmp.writeThreeChars(3);
            outStreamTmp.write(this.heartbeatMessage.getBytes());
            outStreamTmp.endTransmit();
            outStreamTmp.flush();
        }
        if (this.verbose) {
            System.out.println("Heartbeat sent: " + String.valueOf(Instant.now()) + " " + this.heartbeatMessage + "  " + this.heartbeatSeconds);
        }
    }
}

