/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CreationInfo {
    public static final String ELEMENT_NAME = "creationInfo";
    String agencyID;
    String agencyURI;
    String author;
    String authorURI;
    String creationTime;
    String version;

    public CreationInfo(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("agencyID")) {
                    this.agencyID = StaxUtil.pullText(reader, "agencyID");
                    continue;
                }
                if (elName.equals("agencyURI")) {
                    this.agencyURI = StaxUtil.pullText(reader, "agencyURI");
                    continue;
                }
                if (elName.equals("author")) {
                    this.author = StaxUtil.pullText(reader, "author");
                    continue;
                }
                if (elName.equals("authorURI")) {
                    this.authorURI = StaxUtil.pullText(reader, "authorURI");
                    continue;
                }
                if (elName.equals("creationTime")) {
                    this.creationTime = StaxUtil.pullText(reader, "creationTime");
                    continue;
                }
                if (elName.equals("version")) {
                    this.version = StaxUtil.pullText(reader, "version");
                    continue;
                }
                System.err.println("CreationInfo skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getAgencyID() {
        return this.agencyID;
    }

    public String getAgencyURI() {
        return this.agencyURI;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorURI() {
        return this.authorURI;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAgencyID(String agencyID) {
        this.agencyID = agencyID;
    }

    public void setAgencyURI(String agencyURI) {
        this.agencyURI = agencyURI;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setAuthorURI(String authorURI) {
        this.authorURI = authorURI;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

