/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import edu.sc.seis.seisFile.fdsnws.quakeml.WaveformStreamID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Pick {
    private String publicId;
    private Time time;
    private WaveformStreamID waveformID;
    private RealQuantity backazimuth;
    private String filterID;
    private String onset;
    private String methodID;
    private String slownessMethodID;
    private String phaseHint;
    private String polarity;
    private String evaluationMode;
    private String evaluationStatus;
    private CreationInfo creationInfo;
    private List<Comment> commentList = new ArrayList<Comment>();

    public Pick(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement("pick", reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("waveformID")) {
                    this.waveformID = new WaveformStreamID(reader, "waveformID");
                    continue;
                }
                if (elName.equals("time")) {
                    this.time = new Time(reader, "time");
                    continue;
                }
                if (elName.equals("backazimuth")) {
                    this.backazimuth = new RealQuantity(reader, "backazimuth");
                    continue;
                }
                if (elName.equals("filterID")) {
                    this.filterID = StaxUtil.pullText(reader, "filterID");
                    continue;
                }
                if (elName.equals("onset")) {
                    this.onset = StaxUtil.pullText(reader, "onset");
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("slownessMethodID")) {
                    this.slownessMethodID = StaxUtil.pullText(reader, "slownessMethodID");
                    continue;
                }
                if (elName.equals("phaseHint")) {
                    this.phaseHint = StaxUtil.pullText(reader, "phaseHint");
                    continue;
                }
                if (elName.equals("polarity")) {
                    this.polarity = StaxUtil.pullText(reader, "polarity");
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public RealQuantity getBackazimuth() {
        return this.backazimuth;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public String getOnset() {
        return this.onset;
    }

    public String getPhaseHint() {
        return this.phaseHint;
    }

    public String getPolarity() {
        return this.polarity;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSlownessMethodID() {
        return this.slownessMethodID;
    }

    public Time getTime() {
        return this.time;
    }

    public WaveformStreamID getWaveformID() {
        return this.waveformID;
    }

    public void setBackazimuth(RealQuantity backazimuth) {
        this.backazimuth = backazimuth;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setEvaluationMode(String evaluationMode) {
        this.evaluationMode = evaluationMode;
    }

    public void setEvaluationStatus(String evaluationStatus) {
        this.evaluationStatus = evaluationStatus;
    }

    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public void setOnset(String onset) {
        this.onset = onset;
    }

    public void setPhaseHint(String phaseHint) {
        this.phaseHint = phaseHint;
    }

    public void setPolarity(String polarity) {
        this.polarity = polarity;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSlownessMethodID(String slownessMethodID) {
        this.slownessMethodID = slownessMethodID;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void setWaveformID(WaveformStreamID waveformID) {
        this.waveformID = waveformID;
    }
}

