/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentPolynomial;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Response {
    List<ResponseStage> responseStageList = new ArrayList<ResponseStage>();
    private InstrumentSensitivity instrumentSensitivity;
    private InstrumentPolynomial instrumentPolynomial;
    private String resourceId;

    public Response() {
    }

    public Response(List<ResponseStage> responseStageList, InstrumentSensitivity instrumentSensitivity, InstrumentPolynomial instrumentPolynomial) {
        this.responseStageList = responseStageList;
        this.instrumentSensitivity = instrumentSensitivity;
        this.instrumentPolynomial = instrumentPolynomial;
    }

    public Response(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Response", reader);
        this.resourceId = StaxUtil.pullAttributeIfExists(startE, "resourceId");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Stage")) {
                    this.responseStageList.add(new ResponseStage(reader));
                    continue;
                }
                if (elName.equals("InstrumentSensitivity")) {
                    this.instrumentSensitivity = new InstrumentSensitivity(reader);
                    continue;
                }
                if (elName.equals("InstrumentPolynomial")) {
                    this.instrumentPolynomial = new InstrumentPolynomial(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    @Deprecated
    public static boolean isValid(InstrumentSensitivity sens) {
        return InstrumentSensitivity.isValid(sens);
    }

    public static boolean isValid(Response resp) {
        return resp != null && resp.responseStageList.size() != 0 && InstrumentSensitivity.isValid(resp.instrumentSensitivity);
    }

    public static void checkResponse(Response resp) throws InvalidResponse {
        if (!Response.isValid(resp)) {
            if (resp.responseStageList.size() == 0) {
                throw new InvalidResponse("response is not valid, zero stages");
            }
            if (resp.instrumentSensitivity.frequency < 0.0f) {
                throw new InvalidResponse("response is not valid, sensitivity frequency negative");
            }
            if (resp.instrumentSensitivity.sensitivityValue == -1.0f) {
                throw new InvalidResponse("response is not valid, sensitivity factor = -1");
            }
            ResponseStage stageZero = resp.responseStageList.get(0);
            if (stageZero.getStageSensitivity().sensitivityValue == 1.0f && stageZero.getResponseItem() instanceof PolesZeros && ((PolesZeros)stageZero.getResponseItem()).getPoleList().size() == 0 && ((PolesZeros)stageZero.getResponseItem()).getZeroList().size() == 0) {
                throw new InvalidResponse("response is not valid, stage[0] gain = 1, no poles, no zeros, marker for \"UNKNOWN\"");
            }
            throw new InvalidResponse("Response invalid, reason unknown");
        }
    }

    public static void repairResponse(Response resp) throws InvalidResponse {
        if (Response.isValid(resp)) {
            return;
        }
        List<ResponseStage> stageList = resp.responseStageList;
        float sensitivity = 1.0f;
        float stageFreq = 0.0f;
        for (ResponseStage responseStage : stageList) {
            if (stageFreq == 0.0f) {
                stageFreq = responseStage.getStageSensitivity().getFrequency();
            }
            if (responseStage.getStageSensitivity().getFrequency() != 0.0f && stageFreq != responseStage.getStageSensitivity().getFrequency()) {
                throw new InvalidResponse("No sensitivity and different frequencies in the stages of the response. Stage 0=" + stageFreq + "  stage " + responseStage.getNumber() + "= " + responseStage.getStageSensitivity().getFrequency());
            }
            sensitivity *= responseStage.getStageSensitivity().sensitivityValue;
        }
        resp.instrumentSensitivity.sensitivityValue = sensitivity;
        resp.instrumentSensitivity.frequency = stageFreq;
    }

    public ResponseStage getFirstStage() {
        return this.getResponseStageList().get(0);
    }

    public List<ResponseStage> getResponseStageList() {
        return this.responseStageList;
    }

    public InstrumentSensitivity getInstrumentSensitivity() {
        return this.instrumentSensitivity;
    }

    public void setInstrumentSensitivity(InstrumentSensitivity sensitivity) {
        this.instrumentSensitivity = sensitivity;
    }

    public InstrumentPolynomial getInstrumentPolynomial() {
        return this.instrumentPolynomial;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

