/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Unit {
    public static final String SECOND = "second";
    public static final String DEGREE = "degree";
    public static final String METER = "meter";
    public static final String HERTZ = "hertz";
    public static final Unit SECOND_UNIT = new Unit("second");
    public static final Unit DEGREE_UNIT = new Unit("degree");
    public static final Unit METER_UNIT = new Unit("meter");
    public static final Unit HERTZ_UNIT = new Unit("hertz");
    String name;
    String description;

    Unit() {
    }

    public Unit(String name) {
        this(name, null);
    }

    public Unit(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Unit(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this(reader, "unit");
    }

    public Unit(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Name")) {
                    this.name = StaxUtil.pullText(reader, "Name");
                    continue;
                }
                if (elName.equals("Description")) {
                    this.description = StaxUtil.pullText(reader, "Description");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.name;
    }
}

