/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.ControlRecord;
import edu.sc.seis.seisFile.mseed.PartialBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ContinuedControlRecord
extends ControlRecord {
    List<ControlRecord> subRecords = new ArrayList<ControlRecord>();

    public ContinuedControlRecord(ControlRecord first) {
        super(first.getControlHeader());
        this.subRecords.add(first);
    }

    public void addContinuation(List<ControlRecord> nextRecordList) {
        for (ControlRecord cr : nextRecordList) {
            this.addContinuation(cr);
        }
    }

    public void addContinuation(ControlRecord nextRecord) {
        this.subRecords.add(nextRecord);
    }

    @Override
    public void addBlockette(Blockette b) throws SeedFormatException {
        this.subRecords.get(this.subRecords.size() - 1).addBlockette(b);
    }

    @Override
    public Blockette[] getBlockettes() {
        PartialBlockette prior = null;
        ArrayList<Blockette> out = new ArrayList<Blockette>();
        for (ControlRecord cr : this.subRecords) {
            Blockette[] subB;
            for (Blockette b : subB = cr.getBlockettes()) {
                if (b instanceof PartialBlockette) {
                    if (prior == null) {
                        prior = (PartialBlockette)b;
                        continue;
                    }
                    if ((prior = PartialBlockette.combine(prior, (PartialBlockette)b)).getBytesRead() != prior.getTotalSize()) continue;
                    try {
                        out.add(SeedRecord.getBlocketteFactory().parseBlockette(prior.getType(), prior.toBytes(), true));
                        prior = null;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to combine partial blockettes into a single real bloackette.", e);
                    }
                }
                if (prior != null) {
                    throw new RuntimeException("Found regular blockette waiting for rest of partial blockette: " + prior.getBytesRead() + " out of " + prior.getTotalSize() + " bytes.");
                }
                out.add(b);
            }
        }
        if (prior != null) {
            throw new RuntimeException("Found partial blockette at end, rest of bytes missing: " + prior.getBytesRead() + " out of " + prior.getTotalSize() + " bytes.");
        }
        return out.toArray(new Blockette[out.size()]);
    }

    @Override
    public int getNumBlockettes(int type) throws SeedFormatException {
        return this.getBlockettes(type).length;
    }

    @Override
    public Blockette[] getBlockettes(int type) {
        ArrayList<Blockette> out = new ArrayList<Blockette>();
        for (ControlRecord cr : this.subRecords) {
            Blockette[] subB;
            for (Blockette b : subB = cr.getBlockettes()) {
                if (b.getType() != type) continue;
                out.add(b);
            }
        }
        return out.toArray(new Blockette[out.size()]);
    }

    @Override
    public void writeASCII(PrintWriter out, String indent) throws IOException {
        out.print(indent + "ContinuedControlRecord");
        this.getControlHeader().writeASCII(out, indent + "  ");
        for (ControlRecord cr : this.subRecords) {
            cr.writeASCII(out, indent + "    ");
        }
    }

    public List<ControlRecord> getSubRecords() {
        return this.subRecords;
    }
}

