/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;

public class DataHeader
extends ControlHeader {
    protected byte[] stationIdentifier = new byte[5];
    protected String stationIdentifierString;
    protected byte[] locationIdentifier = new byte[2];
    protected String locationIdentifierString;
    protected byte[] channelIdentifier = new byte[3];
    protected String channelIdentifierString;
    protected byte[] networkCode = new byte[2];
    protected String networkCodeString;
    protected byte[] startTime = new byte[10];
    protected int numSamples;
    protected int sampleRateFactor;
    protected int sampleRateMultiplier;
    protected byte activityFlags;
    protected byte ioClockFlags;
    protected byte dataQualityFlags;
    protected byte numBlockettes;
    protected int timeCorrection;
    protected int dataOffset;
    protected int dataBlocketteOffset;

    public DataHeader(int sequenceNum, char typeCode, boolean continuationCode) {
        super(sequenceNum, typeCode, continuationCode);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        this.writeASCII(out, "");
    }

    @Override
    public void writeASCII(PrintWriter out, String indent) throws IOException {
        super.writeASCII(out, indent);
        out.print(indent + this.getNetworkCode().trim() + "." + this.getStationIdentifier().trim() + "." + this.getLocationIdentifier() + "." + this.getChannelIdentifier());
        out.print(" start=" + this.getStartTime());
        out.print(" numPTS=" + this.getNumSamples());
        out.print(" sampFac=" + this.getSampleRateFactor());
        out.print(" sampMul=" + this.getSampleRateMultiplier());
        out.print(" ac=" + this.getActivityFlags());
        out.print(" io=" + this.getIOClockFlags());
        out.print(" qual=" + this.getDataQualityFlags());
        out.print(" numBlockettes=" + this.getNumBlockettes());
        out.print(" blocketteOffset=" + this.getDataBlocketteOffset());
        out.print(" dataOffset=" + this.getDataOffset());
        out.println(" tcor=" + this.getTimeCorrection());
    }

    public static DataHeader read(DataInput in, int sequenceNum, char typeCode, boolean continuationCode) throws IOException, SeedFormatException {
        byte[] buf = new byte[40];
        in.readFully(buf);
        DataHeader data = new DataHeader(sequenceNum, typeCode, continuationCode);
        boolean byteSwapFlag = Btime.shouldSwapBytes(buf, 12);
        data.read(buf, 0, byteSwapFlag);
        return data;
    }

    boolean flagByteSwap() {
        return Btime.shouldSwapBytes(this.startTime);
    }

    protected void read(byte[] buf, int offset) {
        boolean byteSwapFlag = Btime.shouldSwapBytes(buf, offset + 12);
        this.read(buf, offset, byteSwapFlag);
    }

    protected void read(byte[] buf, int offset, boolean byteSwapFlag) {
        System.arraycopy(buf, offset + 0, this.stationIdentifier, 0, this.stationIdentifier.length);
        System.arraycopy(buf, offset + 5, this.locationIdentifier, 0, this.locationIdentifier.length);
        System.arraycopy(buf, offset + 7, this.channelIdentifier, 0, this.channelIdentifier.length);
        System.arraycopy(buf, offset + 10, this.networkCode, 0, this.networkCode.length);
        System.arraycopy(buf, offset + 12, this.startTime, 0, this.startTime.length);
        this.numSamples = Utility.uBytesToInt(buf[offset + 22], buf[offset + 23], byteSwapFlag);
        this.sampleRateFactor = Utility.bytesToInt(buf[offset + 24], buf[offset + 25], byteSwapFlag);
        this.sampleRateMultiplier = Utility.bytesToInt(buf[offset + 26], buf[offset + 27], byteSwapFlag);
        this.activityFlags = buf[offset + 28];
        this.ioClockFlags = buf[offset + 29];
        this.dataQualityFlags = buf[offset + 30];
        this.numBlockettes = buf[offset + 31];
        this.timeCorrection = Utility.bytesToInt(buf[offset + 32], buf[offset + 33], buf[offset + 34], buf[offset + 35], byteSwapFlag);
        this.dataOffset = Utility.uBytesToInt(buf[offset + 36], buf[offset + 37], byteSwapFlag);
        this.dataBlocketteOffset = Utility.uBytesToInt(buf[offset + 38], buf[offset + 39], byteSwapFlag);
    }

    @Override
    protected void write(DataOutput dos) throws IOException {
        super.write(dos);
        dos.write(Utility.pad(this.getStationIdentifier().getBytes("ASCII"), 5, (byte)32));
        dos.write(Utility.pad(this.getLocationIdentifier().getBytes("ASCII"), 2, (byte)32));
        dos.write(Utility.pad(this.getChannelIdentifier().getBytes("ASCII"), 3, (byte)32));
        dos.write(Utility.pad(this.getNetworkCode().getBytes("ASCII"), 2, (byte)32));
        dos.write(this.startTime);
        dos.writeShort((short)this.getNumSamples());
        dos.writeShort((short)this.getSampleRateFactor());
        dos.writeShort((short)this.getSampleRateMultiplier());
        dos.writeByte(this.getActivityFlags());
        dos.writeByte(this.getIOClockFlags());
        dos.writeByte(this.getDataQualityFlags());
        dos.writeByte(this.getNumBlockettes());
        dos.writeInt(this.getTimeCorrection());
        dos.writeShort((short)this.getDataOffset());
        dos.writeShort((short)this.getDataBlocketteOffset());
    }

    @Override
    public short getSize() {
        return 48;
    }

    public char getQualityIndicator() {
        return this.getTypeCode();
    }

    public String getStationIdentifier() {
        if (this.stationIdentifierString == null) {
            this.stationIdentifierString = new String(this.stationIdentifier);
        }
        return this.stationIdentifierString.trim();
    }

    public void setStationIdentifier(String v) {
        this.stationIdentifierString = v;
        try {
            this.stationIdentifier = Utility.pad(v.getBytes("ASCII"), 5, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public String getLocationIdentifier() {
        if (this.locationIdentifierString == null) {
            this.locationIdentifierString = new String(this.locationIdentifier);
        }
        return this.locationIdentifierString;
    }

    public void setLocationIdentifier(String v) {
        this.locationIdentifierString = v;
        int requiredBytes = 2;
        try {
            this.locationIdentifier = Utility.pad(v.getBytes("ASCII"), requiredBytes, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public String getChannelIdentifier() {
        if (this.channelIdentifierString == null) {
            this.channelIdentifierString = new String(this.channelIdentifier);
        }
        return this.channelIdentifierString;
    }

    public void setChannelIdentifier(String v) {
        this.channelIdentifierString = v;
        int requiredBytes = 3;
        try {
            this.channelIdentifier = Utility.pad(v.getBytes("ASCII"), requiredBytes, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public String getNetworkCode() {
        if (this.networkCodeString == null) {
            this.networkCodeString = new String(this.networkCode);
        }
        return this.networkCodeString.trim();
    }

    public void setNetworkCode(String v) {
        this.networkCodeString = v;
        int requiredBytes = 2;
        byte paddingByte = 32;
        try {
            this.networkCode = Utility.pad(v.getBytes("ASCII"), requiredBytes, paddingByte);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public Btime getStartBtime() {
        return new Btime(this.startTime);
    }

    public void setStartBtime(Btime btime) {
        this.startTime = btime.getAsBytes();
    }

    static Btime projectTime(Btime bTime, double tenThousandths) {
        Instant inst = bTime.toInstant();
        Duration dur = Duration.ofSeconds(0L, Math.round(tenThousandths * 100000.0));
        return new Btime(inst.plus(dur));
    }

    public String getStartTime() {
        Btime startStruct = this.getStartBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(startStruct.year) + "," + threeZero.format(startStruct.jday) + "," + twoZero.format(startStruct.hour) + ":" + twoZero.format(startStruct.min) + ":" + twoZero.format(startStruct.sec) + "." + fourZero.format(startStruct.tenthMilli));
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(short v) {
        this.numSamples = v;
    }

    public int getSampleRateFactor() {
        return this.sampleRateFactor;
    }

    public void setSampleRateFactor(short v) {
        this.sampleRateFactor = v;
    }

    public int getSampleRateMultiplier() {
        return this.sampleRateMultiplier;
    }

    public void setSampleRateMultiplier(short v) {
        this.sampleRateMultiplier = v;
    }

    public void setSampleRate(double samplePerSecond) {
        short[] tmp = DataHeader.calcSeedMultipilerFactor(samplePerSecond);
        this.setSampleRateFactor(tmp[0]);
        this.setSampleRateMultiplier(tmp[1]);
    }

    public float calcSampleRateFromMultipilerFactor() {
        double multiplier;
        double factor = this.getSampleRateFactor();
        float sampleRate = factor * (multiplier = (double)this.getSampleRateMultiplier()) != 0.0 ? (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier))) : 0.0f;
        return sampleRate;
    }

    public static short[] calcSeedMultipilerFactor(double sps) {
        if (sps >= 1.0) {
            int divisor = (int)Math.ceil(-32766.0 / sps);
            if (divisor < -32766) {
                divisor = -32766;
            }
            int factor = (int)Math.round(-1.0 * sps * (double)divisor);
            return new short[]{(short)factor, (short)divisor};
        }
        int factor = -1 * (int)Math.round(Math.floor(1.0 * sps * 32765.0) / sps);
        if (factor > 32765) {
            factor = 32765;
        }
        int divisor = (int)Math.round((double)(-1 * factor) * sps);
        return new short[]{(short)factor, (short)divisor};
    }

    public byte getActivityFlags() {
        return this.activityFlags;
    }

    public void setActivityFlags(byte v) {
        this.activityFlags = v;
    }

    public byte getIOClockFlags() {
        return this.ioClockFlags;
    }

    public void setIOClockFlags(byte v) {
        this.ioClockFlags = v;
    }

    public byte getDataQualityFlags() {
        return this.dataQualityFlags;
    }

    public void setDataQualityFlags(byte v) {
        this.dataQualityFlags = v;
    }

    public byte getNumBlockettes() {
        return this.numBlockettes;
    }

    public void setNumBlockettes(byte v) {
        this.numBlockettes = v;
    }

    public int getTimeCorrection() {
        return this.timeCorrection;
    }

    public void setTimeCorrection(int v) {
        this.timeCorrection = v;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(short v) {
        this.dataOffset = v;
    }

    public int getDataBlocketteOffset() {
        return this.dataBlocketteOffset;
    }

    public void setDataBlocketteOffset(short v) {
        this.dataBlocketteOffset = v;
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        try {
            this.writeASCII(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        p.close();
        return sw.toString();
    }

    public String getCodes() {
        return this.getNetworkCode().trim() + "." + this.getStationIdentifier().trim() + "." + this.getLocationIdentifier().trim() + "." + this.getChannelIdentifier().trim();
    }
}

