/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class MenuItem {
    String station;
    String network;
    String channel;
    String location;
    double start;
    double end;
    int pin;
    String dataType;

    public MenuItem(String network, String station, String location, String channel, double start, double end, int pin, String dataType) {
        this.station = station;
        this.network = network;
        this.channel = channel;
        this.location = Channel.fixLocCode(location);
        this.start = start;
        this.end = end;
        this.pin = pin;
        this.dataType = dataType;
    }

    public String toString() {
        return this.network + " " + this.station + " " + this.location + " " + this.channel + " " + MenuItem.formatDate(TimeUtils.instantFromEpochSeconds(this.start)) + " " + MenuItem.formatDate(TimeUtils.instantFromEpochSeconds(this.end));
    }

    public static String formatDate(Instant d) {
        DateTimeFormatter sdf = TimeUtils.createFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return sdf.format(d);
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocation() {
        return this.location;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public Instant getStartDate() {
        return TimeUtils.instantFromEpochSeconds(this.start);
    }

    public Instant getEndDate() {
        return TimeUtils.instantFromEpochSeconds(this.end);
    }

    public int getPin() {
        return this.pin;
    }

    public String getDataType() {
        return this.dataType;
    }
}

