/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.seisFile.LatLonLocatable;

public class Daz {
    protected double deg;
    protected double km;
    protected LatLonLocatable staLatLon = null;
    protected LatLonLocatable evtLatLon = null;
    protected double azimuth;
    protected double backAzimuth;
    protected boolean geodetic = false;
    protected Double invFlattening = null;
    protected String description;

    public Daz(DistanceAngleRay ray, double radiusOfEarth) {
        this(ray.getDegrees(radiusOfEarth), ray.getKilometers(radiusOfEarth), ray.getAzimuth(), ray.getBackAzimuth(), ray.getDescription());
        if (ray.hasReceiver()) {
            this.evtLatLon = ray.getReceiver();
        }
        if (ray.hasSource()) {
            this.staLatLon = ray.getSource();
        }
        if (ray.isGeodetic()) {
            this.geodetic = true;
            this.invFlattening = ray.getInvFlattening();
        }
    }

    public Daz(double deg, double km, double az, double baz, String description) {
        this.deg = deg;
        this.km = km;
        this.azimuth = az;
        this.backAzimuth = baz;
        this.description = description;
    }

    public double getDegrees() {
        return this.deg;
    }

    public LatLonLocatable getStaLatLon() {
        return this.staLatLon;
    }

    public LatLonLocatable getSource() {
        return this.getStaLatLon();
    }

    public LatLonLocatable getEvtLatLon() {
        return this.evtLatLon;
    }

    public LatLonLocatable getReceiver() {
        return this.getEvtLatLon();
    }

    public Double getAzimuth() {
        return this.azimuth;
    }

    public Double getBackAzimuth() {
        return this.backAzimuth;
    }

    public boolean isGeodetic() {
        return this.geodetic;
    }

    public Double getInvFlattening() {
        return this.invFlattening;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getKilometers() {
        return this.km;
    }

    public Double getKm() {
        return this.km;
    }

    public boolean hasSource() {
        return this.staLatLon != null;
    }

    public boolean hasReceiver() {
        return this.evtLatLon != null;
    }

    public double getNormalizedAzimuth() {
        return RayCalculateable.normalizAzimuth(this.getAzimuth());
    }

    public double getNormalizedBackAzimuth() {
        return RayCalculateable.normalizAzimuth(this.getBackAzimuth());
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }
}

