/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.DistanceRay;

public class DistanceAngleRay
extends DistanceRay {
    protected Double radians = null;
    protected Double degrees = null;

    public boolean isDegrees() {
        return this.degrees != null;
    }

    @Override
    public double getDegrees(double radius) {
        return this.getDegrees();
    }

    public double getDegrees() {
        if (this.degrees != null) {
            return this.degrees;
        }
        if (this.radians != null) {
            return this.radians * 57.29577951308232;
        }
        throw new RuntimeException("One of degrees or radians must be set");
    }

    @Override
    public double getKilometers(double radius) {
        return this.getRadians(radius) * radius;
    }

    @Override
    public double getRadians(double radius) {
        return this.getRadians();
    }

    public double getRadians() {
        if (this.radians != null) {
            return this.radians;
        }
        if (this.degrees != null) {
            return this.degrees * (Math.PI / 180);
        }
        throw new RuntimeException("One of degrees or radians must be set");
    }

    @Override
    public String toString() {
        Object out = "";
        if (this.radians != null) {
            out = (String)out + this.radians + " rad";
        } else if (this.degrees != null) {
            out = (String)out + this.degrees + " deg";
        }
        if (this.hasDescription()) {
            out = (String)out + ", " + this.getDescription();
        }
        return out;
    }

    protected DistanceAngleRay duplicate() {
        DistanceAngleRay dr = this.degrees != null ? DistanceAngleRay.ofDegrees(this.degrees) : DistanceAngleRay.ofRadians(this.degrees);
        dr.copyFrom(this);
        return dr;
    }
}

