/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.Map;
import java.util.Properties;

public class PropertyLoader {
    protected static String defaultPropFileName = "defaultProps";
    protected static String packageName = "/edu/sc/seis/TauP";
    protected static String propFileName = ".taup";

    public static Properties load() throws IOException {
        Properties defaultProps = new Properties();
        try {
            Class<?> c = null;
            try {
                c = Class.forName("edu.sc.seis.TauP.PropertyLoader");
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream in = c.getResourceAsStream(packageName + "/" + defaultPropFileName);
            if (in != null) {
                defaultProps.load(new BufferedInputStream(in));
            } else {
                Alert.warning("Warning: unable to load default configuration properties from jar, " + packageName + "/" + defaultPropFileName);
            }
        }
        catch (FileNotFoundException c) {
            // empty catch block
        }
        Properties applicationProps = new Properties();
        applicationProps.putAll((Map<?, ?>)defaultProps);
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.home") + FileSystems.getDefault().getSeparator() + propFileName));
        }
        catch (FileNotFoundException in) {
            // empty catch block
        }
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.dir") + FileSystems.getDefault().getSeparator() + propFileName));
        }
        catch (FileNotFoundException in) {
            // empty catch block
        }
        String taupPath = "taup.model.path";
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey(taupPath)) {
            if (applicationProps.containsKey(taupPath)) {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath) + sysProps.getProperty("path.separator") + applicationProps.getProperty(taupPath));
            } else {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath));
            }
        }
        return applicationProps;
    }

    public static void save(Properties props) throws IOException {
        PropertyLoader.save(props, propFileName);
    }

    public static void save(Properties props, String filename) throws IOException {
        FileOutputStream propFile = new FileOutputStream(filename);
        props.store(propFile, "---Properties for the TauP toolkit---");
        propFile.close();
    }
}

