/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import edu.sc.seis.TauP.Daz;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.ModelOrRadius;
import edu.sc.seis.TauP.cmdline.Result;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.DistanceArgs;
import edu.sc.seis.TauP.cmdline.args.DistanceLengthArgs;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.LatLonAzBazArgs;
import edu.sc.seis.TauP.cmdline.args.QmlStaxmlArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.LatLonSimple;
import edu.sc.seis.seisFile.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="distaz", description={"Calc distance, az and baz for event lat,lon and station lat,lon pairs."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_DistAz
extends TauP_Tool {
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs;
    @CommandLine.Mixin
    LatLonAzBazArgs latLonArgs = new LatLonAzBazArgs();
    @CommandLine.Mixin
    QmlStaxmlArgs qmlStaxmlArgs = new QmlStaxmlArgs();
    @CommandLine.Mixin
    GeodeticArgs geodeticArgs = new GeodeticArgs();
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..*", heading="Optional distance is given by:%n")
    DistanceLengthArgs distArgs = new DistanceLengthArgs();
    @CommandLine.ArgGroup
    ModelOrRadius radiusArgs = new ModelOrRadius();

    public TauP_DistAz() {
        super(new TextOutputTypeArgs("text", "-"));
        this.outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void start() throws IOException, TauPException {
        ArrayList<LatLonLocatable> eventLocs = new ArrayList<LatLonLocatable>();
        eventLocs.addAll(this.latLonArgs.getEventLocations());
        eventLocs.addAll(this.qmlStaxmlArgs.getEventLocations());
        ArrayList<LatLonLocatable> staList = new ArrayList<LatLonLocatable>();
        staList.addAll(this.latLonArgs.getStationLocations());
        staList.addAll(this.qmlStaxmlArgs.getStationLocations());
        ArrayList<DistanceAngleRay> distList = new ArrayList<DistanceAngleRay>();
        if (this.latLonArgs.hasAzimuth()) {
            for (LatLonLocatable evtLoc : eventLocs) {
                Location eLoc = evtLoc.asLocation();
                for (Double d : this.createDistDegreeList()) {
                    double lat = SphericalCoords.latFor(eLoc, d, this.latLonArgs.getAzimuth());
                    double lon = SphericalCoords.lonFor(eLoc, d, this.latLonArgs.getAzimuth());
                    LatLonSimple loc = new LatLonSimple(lat, lon);
                    DistanceAngleRay dr = DistanceRay.ofEventStation(evtLoc, (LatLonLocatable)loc);
                    dr.setDescription(evtLoc.getLocationDescription() + " to " + loc.getLocationDescription());
                    distList.add(dr);
                }
            }
        }
        if (this.latLonArgs.hasBackAzimuth()) {
            for (LatLonLocatable staLoc : staList) {
                for (Double d : this.createDistDegreeList()) {
                    double lat = SphericalCoords.latFor(staLoc.asLocation(), d, this.latLonArgs.getBackAzimuth());
                    double lon = SphericalCoords.lonFor(staLoc.asLocation(), d, this.latLonArgs.getBackAzimuth());
                    LatLonSimple loc = new LatLonSimple(lat, lon);
                    DistanceAngleRay dr = DistanceRay.ofEventStation((LatLonLocatable)loc, staLoc);
                    dr.setDescription(loc.getLocationDescription() + " to " + staLoc.getLocationDescription());
                    distList.add(dr);
                }
            }
        }
        for (LatLonLocatable evtLoc : eventLocs) {
            for (LatLonLocatable latLonLocatable : staList) {
                DistanceAngleRay dr = this.geodeticArgs.isGeodetic() ? DistanceRay.ofGeodeticEventStation(evtLoc, latLonLocatable, this.geodeticArgs.getInverseEllipFlattening()) : DistanceRay.ofEventStation(evtLoc, latLonLocatable);
                dr.setDescription(evtLoc.getLocationDescription() + " to " + latLonLocatable.getLocationDescription());
                distList.add(dr);
            }
        }
        distList.sort(Comparator.comparingDouble(DistanceAngleRay::getDegrees));
        ArrayList<Daz> dazList = new ArrayList<Daz>();
        double radius = this.radiusArgs.getRadiusOfEarth() != null ? this.radiusArgs.getRadiusOfEarth() : 6371.0;
        for (DistanceAngleRay ray : distList) {
            dazList.add(new Daz(ray, radius));
        }
        PrintWriter printWriter = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        if (this.outputTypeArgs.isText()) {
            String geoditic = this.geodeticArgs.isGeodetic() ? "Geodetic " + this.geodeticArgs.getInverseEllipFlattening() : "Spherical";
            printWriter.println("Degrees      Km     Azimuth  BackAzimuth  Description   (" + geoditic + ")  ");
            printWriter.println("----------------------------------------------------------------------");
            for (Daz dr : dazList) {
                printWriter.println(Outputs.formatDistance(dr.getDegrees()) + " " + Outputs.formatKilometer(dr.getKilometers()) + " " + Outputs.formatDistance(dr.getNormalizedAzimuth()) + "  " + Outputs.formatDistance(dr.getNormalizedBackAzimuth()) + "      " + (dr.hasDescription() ? dr.getDescription() : ""));
            }
        } else if (this.outputTypeArgs.isHTML()) {
            String geoditic = this.geodeticArgs.isGeodetic() ? "Geodetic " + this.geodeticArgs.getInverseEllipFlattening() : "Spherical";
            List<CallSite> head = List.of("Degrees", "Km", "Azimuth", "BackAzimuth", "Description   (" + geoditic + ")  ");
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (Daz dr : dazList) {
                List<String> row = List.of(Outputs.formatDistance(dr.getDegrees()), Outputs.formatKilometer(dr.getKilometers()), Outputs.formatDistance(dr.getNormalizedAzimuth()), Outputs.formatDistance(dr.getNormalizedBackAzimuth()), dr.hasDescription() ? dr.getDescription() : "");
                values.add(row);
            }
            HTMLUtil.createHtmlStart(printWriter, "TauP Distaz", HTMLUtil.createTableCSS(), false);
            printWriter.println(HTMLUtil.createBasicTable(head, values));
            HTMLUtil.addSortTableJS(printWriter);
            printWriter.println(HTMLUtil.createHtmlEnding());
        } else if (this.outputTypeArgs.isJSON()) {
            Result result = new Result();
            result.calctype = this.geodeticArgs.getCalcType();
            if (this.geodeticArgs.isGeodetic()) {
                result.invflattening = this.geodeticArgs.getInverseEllipFlattening();
            }
            result.radius = radius;
            if (this.radiusArgs.modelName != null) {
                result.model = this.radiusArgs.getModelName();
            }
            result.sources = eventLocs.stream().map(LatLonLocatable::asLocation).collect(Collectors.toList());
            result.receivers = staList.stream().map(LatLonLocatable::asLocation).collect(Collectors.toList());
            result.distances = dazList;
            Gson gson = GsonUtil.createGsonBuilder().create();
            printWriter.println(gson.toJson((Object)result));
        }
        printWriter.flush();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (!(this.distArgs.allEmpty() || this.latLonArgs.hasAzimuth() || this.latLonArgs.hasBackAzimuth())) {
            throw new IllegalArgumentException("Distance only used with azimuth or backazimuth");
        }
        if (this.distArgs.allEmpty() && (this.latLonArgs.hasAzimuth() || this.latLonArgs.hasBackAzimuth())) {
            throw new IllegalArgumentException("Azimuth and backazimuth require distance in deg or km");
        }
        if (this.geodeticArgs.isGeodetic() && (this.latLonArgs.hasBackAzimuth() || this.latLonArgs.hasAzimuth())) {
            throw new IllegalArgumentException("Unable to project for az,baz with geodetic, only for spherical");
        }
        if (this.latLonArgs.getEventLocations().isEmpty() && !this.qmlStaxmlArgs.hasQml() && !this.latLonArgs.hasBackAzimuth()) {
            throw new IllegalArgumentException("Either back azimuth, event lat,lon or QuakeML file must be given");
        }
        if (this.latLonArgs.getStationLocations().isEmpty() && !this.qmlStaxmlArgs.hasStationXML() && !this.latLonArgs.hasAzimuth()) {
            throw new IllegalArgumentException("Either azimuth, station lat,lon or StationXML file must be given");
        }
        this.latLonArgs.validateArguments();
        this.geodeticArgs.validateArguments();
    }

    public List<Double> createDistDegreeList() {
        ArrayList<Double> allDeg = new ArrayList<Double>(this.distArgs.degreesList);
        if (!this.distArgs.degreeRange.isEmpty()) {
            allDeg.addAll(DistanceArgs.createListFromRange(this.distArgs.degreeRange, 10.0, 180.0, 10.0));
        }
        ArrayList<Double> allKm = new ArrayList<Double>(this.distArgs.distKilometersList);
        if (!this.distArgs.kilometerRange.isEmpty()) {
            allKm.addAll(DistanceArgs.createListFromRange(this.distArgs.kilometerRange, 100.0, 1000.0, 100.0));
        }
        if (!allKm.isEmpty()) {
            double kmToDeg = this.kmToDeg();
            for (Double km : allKm) {
                allDeg.add(km * kmToDeg);
            }
        }
        return allDeg;
    }

    public Double kmToDeg() {
        double r = this.radiusArgs.getRadiusOfEarth() != null ? this.radiusArgs.getRadiusOfEarth() : 6371.0;
        return 57.29577951308232 / r;
    }
}

