/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.ExactDistanceRay;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import java.util.ArrayList;
import java.util.List;

public class FixedHemisphereDistanceRay
extends DistanceRay {
    private final ExactDistanceRay distanceRay;

    public FixedHemisphereDistanceRay(ExactDistanceRay dr) {
        this.distanceRay = dr;
    }

    public boolean isNegativeHemisphere() {
        double R = 6371.0;
        return this.getRadians(R) % (Math.PI * 2) > Math.PI;
    }

    @Override
    public List<Arrival> calcSimplePhase(SimpleSeismicPhase phase) {
        return this.fixNegDistance(super.calcSimplePhase(phase));
    }

    @Override
    public List<Arrival> calcScatteredPhase(ScatteredSeismicPhase phase) {
        return this.fixNegDistance(super.calcScatteredPhase(phase));
    }

    @Override
    public double getDegrees(double radius) {
        return this.distanceRay.getDegrees(radius);
    }

    @Override
    public double getRadians(double radius) {
        return this.distanceRay.getRadians(radius);
    }

    @Override
    public double getKilometers(double radius) {
        return this.distanceRay.getKilometers(radius);
    }

    public List<Arrival> fixNegDistance(List<Arrival> arrivalList) {
        ArrayList<Arrival> out = new ArrayList<Arrival>();
        for (Arrival arrival : arrivalList) {
            if (this.isNegativeHemisphere() && arrival.getDist() > 0.0) {
                out.add(arrival.negateDistance());
                continue;
            }
            out.add(arrival);
        }
        return out;
    }

    @Override
    public List<Double> calcRadiansInRange(double minRadian, double maxRadian, double radius, boolean phaseBothHemisphere) {
        ArrayList<Double> out = new ArrayList<Double>();
        double radianVal = this.getRadians(radius) % (Math.PI * 2);
        if (phaseBothHemisphere) {
            if (radianVal > Math.PI) {
                radianVal = Math.PI * 2 - radianVal;
            } else if (radianVal < 0.0) {
                radianVal *= -1.0;
            }
        }
        if ((radianVal - minRadian) % (Math.PI * 2) == 0.0) {
            out.add(minRadian);
        }
        int n = (int)Math.floor(minRadian / (Math.PI * 2));
        while ((double)n * (Math.PI * 2) < maxRadian) {
            double searchVal = (double)n * (Math.PI * 2) + radianVal;
            if (minRadian < searchVal && searchVal <= maxRadian) {
                out.add(searchVal);
            }
            ++n;
        }
        return out;
    }

    protected FixedHemisphereDistanceRay duplicate() {
        ExactDistanceRay inner = this.distanceRay.duplicate();
        FixedHemisphereDistanceRay dr = new FixedHemisphereDistanceRay(inner);
        dr.copyFrom(this);
        return dr;
    }

    public ExactDistanceRay getWrappedDistanceRay() {
        return this.distanceRay;
    }

    @Override
    public String toString() {
        return "exact hemi " + super.toString();
    }
}

