/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseLayerFactory;
import edu.sc.seis.TauP.TauModelException;

public class SeismicPhaseFactoryUtil {
    public static boolean isPWave(String currLeg, boolean prevIsP) {
        if (PhaseSymbols.isCompressionalWaveSymbol(currLeg)) {
            return true;
        }
        if (PhaseSymbols.isTransverseWaveSymbol(currLeg)) {
            return false;
        }
        return prevIsP;
    }

    public static void doTopsideReflect(SeismicPhaseLayerFactory factory, ProtoSeismicPhase proto, String currLeg, int currBranch, String nextLeg) throws TauModelException {
        if (PhaseSymbols.isReflectSymbol(nextLeg)) {
            PhaseInteraction endAction = PhaseSymbols.isCriticalReflectSymbol(nextLeg) ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            String depthString = nextLeg.substring(1);
            int disconBranch = LegPuller.closestDisconBranchToDepth(proto.tMod, depthString, factory.depthTolerance);
            if (disconBranch == -1) {
                proto.failNext("No boundary in model within " + factory.depthTolerance + " km of " + depthString);
                return;
            }
            if (currBranch <= disconBranch - 1) {
                boolean isPWave = proto.endSegment().isPWave;
                boolean nextIsPWave = SeismicPhaseFactoryUtil.isPWave(nextLeg, isPWave);
                proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            } else {
                proto.failNext("TopsideReflect Phase not recognized in " + factory.layerName + ": " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch + " < disconBranch=" + disconBranch);
            }
        }
    }
}

