/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalAmplitude;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.gson.RayCalculateableSerializer;
import java.lang.reflect.Type;

public class ArrivalSerializer
implements JsonSerializer<Arrival> {
    boolean withPierce;
    boolean withPath;
    boolean withAmplitude;
    boolean withDerivative;

    public ArrivalSerializer(boolean withPierce, boolean withPath, boolean withAmplitude, boolean withDerivative) {
        this.withPierce = withPierce;
        this.withPath = withPath;
        this.withAmplitude = withAmplitude;
        this.withDerivative = withDerivative;
    }

    public JsonElement serialize(Arrival arr, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray points;
        JsonObject a = new JsonObject();
        a.addProperty("sourcedepth", (Number)Float.valueOf((float)arr.getSourceDepth()));
        a.addProperty("receiverdepth", (Number)Float.valueOf((float)arr.getReceiverDepth()));
        a.addProperty("distdeg", (Number)Float.valueOf((float)arr.getModuloDistDeg()));
        a.addProperty("phase", arr.getName());
        a.addProperty("time", (Number)Float.valueOf((float)arr.getTime()));
        a.addProperty("rayparam", (Number)Float.valueOf((float)(Math.PI / 180 * arr.getRayParam())));
        a.addProperty("takeoff", (Number)Float.valueOf((float)arr.getTakeoffAngleDegree()));
        a.addProperty("incident", (Number)Float.valueOf((float)arr.getIncidentAngleDegree()));
        if (arr.getRayCalculateable().hasAzimuth()) {
            a.addProperty("az", (Number)arr.getRayCalculateable().getAzimuth());
        }
        if (arr.getRayCalculateable().hasBackAzimuth()) {
            a.addProperty("baz", (Number)arr.getRayCalculateable().getBackAzimuth());
        }
        a.addProperty("puristdist", (Number)Float.valueOf((float)arr.getDistDeg()));
        a.addProperty("puristname", arr.getPuristName());
        if (arr.getRayCalculateable().hasDescription()) {
            a.addProperty("desc", arr.getRayCalculateable().getDescription());
        }
        if (arr.getRayCalculateable().hasSource()) {
            a.add("sourceloc", context.serialize((Object)arr.getRayCalculateable().getSource()));
        }
        if (arr.getRayCalculateable().hasReceiver()) {
            a.add("receiverloc", context.serialize((Object)arr.getRayCalculateable().getReceiver()));
        }
        if (this.withAmplitude) {
            try {
                a.add("amp", context.serialize((Object)new ArrivalAmplitude(arr)));
            }
            catch (TauModelException e) {
                throw new RuntimeException(e);
            }
            catch (SlownessModelException e) {
                throw new RuntimeException(e);
            }
        }
        if (arr.getPhase() instanceof ScatteredSeismicPhase) {
            ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)arr.getPhase();
            a.add("scatter", context.serialize((Object)scatPhase.getScatterer()));
        }
        if (arr.isRelativeToArrival()) {
            Arrival relArrival = arr.getRelativeToArrival();
            JsonObject relA = new JsonObject();
            a.add("relative", (JsonElement)relA);
            relA.addProperty("difference", (Number)Float.valueOf((float)(arr.getTime() - relArrival.getTime())));
            relA.add("arrival", context.serialize((Object)relArrival));
        }
        RayCalculateableSerializer raycalcSerializer = new RayCalculateableSerializer();
        a.add("raytype", raycalcSerializer.serialize(arr.getRayCalculateable(), (Type)((Object)RayCalculateable.class), context));
        if (this.withDerivative) {
            JsonObject deriv = new JsonObject();
            a.add("derivative", (JsonElement)deriv);
            JsonObject source = new JsonObject();
            deriv.add("source", (JsonElement)source);
            source.addProperty("velocity", (Number)Float.valueOf((float)arr.velocityAtSource()));
            source.addProperty("radialslowness", (Number)Float.valueOf((float)arr.radialSlownessAtSource()));
            source.addProperty("radius", (Number)Float.valueOf((float)arr.sourceRadius()));
            JsonObject receiver = new JsonObject();
            deriv.add("receiver", (JsonElement)receiver);
            receiver.addProperty("velocity", (Number)Float.valueOf((float)arr.velocityAtReceiver()));
            receiver.addProperty("radialslowness", (Number)Float.valueOf((float)arr.radialSlownessAtReceiver()));
            receiver.addProperty("radius", (Number)Float.valueOf((float)arr.receiverRadius()));
            deriv.addProperty("dp/ddeg", (Number)arr.getDRayParamDDeltaDeg());
        }
        if (this.withPierce) {
            JsonObject tdArray;
            points = new JsonArray();
            a.add("pierce", (JsonElement)points);
            for (TimeDist td : tdArray = arr.getPierce()) {
                JsonArray tdItems = new JsonArray();
                points.add((JsonElement)tdItems);
                tdItems.add((Number)Float.valueOf((float)td.getDistDeg()));
                tdItems.add((Number)Float.valueOf((float)td.getDepth()));
                tdItems.add((Number)Float.valueOf((float)td.getTime()));
                if (!arr.isLatLonable()) continue;
                double[] latlon = arr.getLatLonable().calcLatLon(td.getDistDeg(), arr.getDistDeg());
                tdItems.add((Number)Float.valueOf((float)latlon[0]));
                tdItems.add((Number)Float.valueOf((float)latlon[1]));
            }
        }
        if (this.withPath) {
            a.addProperty("pathlength", (Number)Float.valueOf((float)arr.calcPathLength()));
            points = new JsonArray();
            a.add("path", (JsonElement)points);
            for (ArrivalPathSegment seg : arr.getPathSegments()) {
                points.add((JsonElement)seg.asJsonObject());
            }
        }
        return a;
    }
}

