/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.Isochron;
import edu.sc.seis.TauP.PhaseIsochron;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.WavefrontPathSegment;
import java.lang.reflect.Type;

public class IsochronSerializer
implements JsonSerializer<Isochron> {
    public JsonElement serialize(Isochron src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("time", (Number)src.getTime());
        JsonArray wavefrontArr = new JsonArray(src.getWavefront().size());
        for (PhaseIsochron phaseIsochron : src.getWavefront()) {
            JsonObject jsonObject = new JsonObject();
            wavefrontArr.add((JsonElement)jsonObject);
            jsonObject.addProperty("time", (Number)phaseIsochron.getTime());
            jsonObject.addProperty("phase", phaseIsochron.getPhase().getName());
            jsonObject.addProperty("model", phaseIsochron.getPhase().getTauModel().getModelName());
            jsonObject.addProperty("sourcedepth", (Number)phaseIsochron.getPhase().getSourceDepth());
            jsonObject.addProperty("receiverdepth", (Number)phaseIsochron.getPhase().getReceiverDepth());
            if (phaseIsochron.getPhase() instanceof ScatteredSeismicPhase) {
                ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)phaseIsochron.getPhase();
                jsonObject.add("scatter", context.serialize((Object)scatPhase.getScatterer()));
            }
            JsonArray segmentArr = new JsonArray(src.getWavefront().size());
            for (WavefrontPathSegment seg : phaseIsochron.getWavefront()) {
                segmentArr.add((JsonElement)seg.asJsonObject());
            }
            jsonObject.add("segments", (JsonElement)segmentArr);
        }
        obj.add("wavefronts", (JsonElement)wavefrontArr);
        return obj;
    }
}

