/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicSource;
import java.util.List;
import java.util.stream.Collectors;

public class AbstractPhaseResult {
    String model;
    List<Double> sourcedepthlist;
    List<Double> receiverdepthlist;
    List<String> phases;
    Scatterer scatter;
    SeismicSource sourceArg;

    public AbstractPhaseResult(String model, List<Double> sourcedepthlist, List<Double> receiverdepthlist, List<PhaseName> phases, Scatterer scatterer) {
        this(model, sourcedepthlist, receiverdepthlist, phases, scatterer, false, null);
    }

    public AbstractPhaseResult(String model, List<Double> sourcedepthlist, List<Double> receiverdepthlist, List<PhaseName> phases, Scatterer scatterer, boolean withAmp, SeismicSource sourceArgs) {
        this.model = model;
        this.sourcedepthlist = sourcedepthlist;
        this.receiverdepthlist = receiverdepthlist;
        this.phases = phases.stream().map(phaseName -> phaseName.getName()).collect(Collectors.toList());
        this.scatter = scatterer;
        this.sourceArg = withAmp ? sourceArgs : null;
    }

    public String getModel() {
        return this.model;
    }

    public List<Double> getSourcedepthlist() {
        return this.sourcedepthlist;
    }

    public List<Double> getReceiverdepthlist() {
        return this.receiverdepthlist;
    }

    public List<String> getPhases() {
        return this.phases;
    }

    public Scatterer getScatter() {
        return this.scatter;
    }

    public SeismicSource getSourceArg() {
        return this.sourceArg;
    }
}

