/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.VelocityModelException;

public class ReflTransFluidFluid
extends ReflTrans {
    Complex denom;

    public ReflTransFluidFluid(double topVp, double topDensity, double botVp, double botDensity) throws VelocityModelException {
        super(topVp, 0.0, topDensity, botVp, 0.0, botDensity);
        if (topVp * topDensity * botVp * botDensity == 0.0) {
            throw new VelocityModelException("Fluid-fluid reflection and transmission coefficients must have non-zero layer params: in:" + topVp + " " + topDensity + " tr: " + botVp + " " + botDensity);
        }
    }

    @Override
    public Complex getComplexRpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex num = this.botVertSlownessP.times(this.topDensity).minus(this.topVertSlownessP.times(this.botDensity));
        return num.over(this.denom);
    }

    @Override
    public Complex getComplexRps(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexTpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex num = new Complex(this.topVp / this.botVp * 2.0 * this.topDensity).times(this.topVertSlownessP);
        return num.over(this.denom);
    }

    @Override
    public Complex getComplexTps(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexRsp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexRss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexTsp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexTss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexRshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public Complex getComplexTshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for fluid to fluid");
    }

    @Override
    public ReflTrans flip() throws VelocityModelException {
        return new ReflTransFluidFluid(this.botVp, this.botDensity, this.topVp, this.topDensity);
    }

    @Override
    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        if (rayParam < 0.0) {
            throw new IllegalArgumentException("rayParam cannot be negative");
        }
        this.rp = rayParam;
        if (rayParam != this.lastRayParam || inIsPWave != this.lastInIsPWave) {
            this.topVertSlownessP = this.calcInVerticalSlownessP(this.rp);
            this.botVertSlownessP = this.calcTransVerticalSlownessP(this.rp);
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
            this.denom = this.topVertSlownessP.times(this.botDensity).plus(this.botVertSlownessP.times(this.topDensity));
        }
    }

    public String toString() {
        return "Fluid-fluid:  in: Vp: " + this.topVp + " d: " + this.topDensity + " tr: Vp" + this.botVp + " d: " + this.botDensity;
    }
}

