/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;

public class StationBackAzimuth
extends LatLonable {
    LatLonLocatable staLatLon;
    double backAzimuth;

    public StationBackAzimuth(LatLonLocatable staLatLon, Double backAzimuth) {
        this.staLatLon = staLatLon;
        this.backAzimuth = backAzimuth;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        if (this.isGeodetic()) {
            throw new RuntimeException("geodetic not yet");
        }
        Location staLoc = this.staLatLon.asLocation();
        double evtLat = SphericalCoords.latFor(staLoc.getLatitude(), staLoc.getLongitude(), this.backAzimuth, totalDist);
        double evtLon = SphericalCoords.lonFor(staLoc.getLatitude(), staLoc.getLongitude(), this.backAzimuth, totalDist);
        double azimuth = SphericalCoords.azimuth(evtLat, evtLon, staLoc.getLatitude(), staLoc.getLongitude());
        out[0] = SphericalCoords.latFor(evtLat, evtLon, calcDist, azimuth);
        out[1] = SphericalCoords.lonFor(evtLat, evtLon, calcDist, azimuth);
        return out;
    }
}

