/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SvgEarthScaling;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.cmdline.args.DistDepthRange;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SvgEarth {
    private static final float plotOverScaleFactor = 1.2f;

    public static SvgEarthScaling calcEarthScaleTransForPhaseList(List<SeismicPhase> phaseList, DistDepthRange distDepthRange, boolean includeNegDist) {
        SvgEarthScaling scaling;
        float[] scaleTrans;
        float R = 6371.0f;
        if (!phaseList.isEmpty()) {
            R = (float)phaseList.get(0).getTauModel().getRadiusOfEarth();
        }
        float minDist = 0.0f;
        float maxDist = 0.0f;
        double minDepth = 0.0;
        double maxDepth = 0.0;
        if (phaseList.isEmpty() && !distDepthRange.hasDistAxisMinMax() && !distDepthRange.hasDepthAxisMinMax()) {
            maxDist = (float)Math.PI;
            scaleTrans = new float[]{1.0f, 0.0f, 0.0f, minDist, maxDist};
            scaling = new SvgEarthScaling(R);
        } else if (distDepthRange.hasDistAxisMinMax() && distDepthRange.hasDepthAxisMinMax()) {
            double[] bbox = SvgEarth.findPierceBoundingBox(distDepthRange.getDistAxisMinMax(), distDepthRange.getDepthAxisMinMax(), R);
            scaling = new SvgEarthScaling(bbox, R);
            scaleTrans = SvgEarthScaling.calcZoomScaleTranslate((float)bbox[0], (float)bbox[1], (float)bbox[2], (float)bbox[3], R, (float)distDepthRange.getDistAxisMinMax()[0], (float)distDepthRange.getDistAxisMinMax()[1]);
        } else {
            for (SeismicPhase seismicPhase : phaseList) {
                if (seismicPhase.getMaxDistance() > (double)maxDist) {
                    maxDist = (float)seismicPhase.getMaxDistance();
                }
                if (seismicPhase.getMinDistance() < (double)minDist) {
                    minDist = (float)seismicPhase.getMinDistance();
                }
                for (List<SeismicPhaseSegment> segList : seismicPhase.getListPhaseSegments()) {
                    for (SeismicPhaseSegment phaseSeg : segList) {
                        double[] depths;
                        for (double d : depths = phaseSeg.getDepthRange()) {
                            if (d < minDepth) {
                                minDepth = d;
                            }
                            if (!(d > maxDepth)) continue;
                            maxDepth = d;
                        }
                    }
                }
            }
            ArrayList<Double> distRanges = new ArrayList<Double>();
            if (distDepthRange.hasDistAxisMinMax()) {
                minDist = (float)distDepthRange.getDistAxisMinMax()[0];
                maxDist = (float)distDepthRange.getDistAxisMinMax()[1];
                distRanges.add(Double.valueOf(minDist));
                distRanges.add(Double.valueOf(maxDist));
            } else {
                distRanges.add(0.0);
                for (SeismicPhase phase : phaseList) {
                    distRanges.add(phase.getMinDistanceDeg());
                    distRanges.add(phase.getMaxDistanceDeg());
                    if (!(Math.abs(phase.getMaxDistance() - phase.getMinDistance()) > 2.356194490192345) && !(phase.getMaxDistance() >= Math.PI)) continue;
                    distRanges.add(180.0);
                }
                if (includeNegDist) {
                    for (SeismicPhase phase : phaseList) {
                        distRanges.add(-1.0 * phase.getMinDistanceDeg());
                        distRanges.add(-1.0 * phase.getMaxDistanceDeg());
                    }
                }
            }
            double[] dArray = new double[distRanges.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)distRanges.get(i);
            }
            double[] bbox = SvgEarth.findPierceBoundingBox(dArray, new double[]{minDepth, maxDepth}, R);
            scaling = new SvgEarthScaling(bbox, R);
            scaleTrans = SvgEarthScaling.calcZoomScaleTranslate((float)bbox[0], (float)bbox[1], (float)bbox[2], (float)bbox[3], R, minDist, maxDist);
        }
        if ((double)scaleTrans[0] < 1.25) {
            scaling = new SvgEarthScaling(R);
        }
        return scaling;
    }

    public static SvgEarthScaling calcEarthScaleTrans(List<Arrival> arrivalList, DistDepthRange distDepthRange) {
        SvgEarthScaling scaling;
        float R = 6371.0f;
        if (!arrivalList.isEmpty()) {
            R = (float)arrivalList.get(0).getTauModel().getRadiusOfEarth();
        }
        double minDepth = 0.0;
        double maxDepth = 0.0;
        if (arrivalList.isEmpty() && !distDepthRange.hasDistAxisMinMax() && !distDepthRange.hasDepthAxisMinMax()) {
            scaling = new SvgEarthScaling(R);
        } else if (distDepthRange.hasDistAxisMinMax() && distDepthRange.hasDepthAxisMinMax()) {
            double[] bbox = SvgEarth.findPierceBoundingBox(distDepthRange.getDistAxisMinMax(), distDepthRange.getDepthAxisMinMax(), R);
            scaling = new SvgEarthScaling(bbox, R);
        } else {
            scaling = SvgEarth.calcZoomScaleTranslate(arrivalList);
            if (!distDepthRange.hasDistAxisMinMax() && distDepthRange.hasDepthAxisMinMax()) {
                double[] bbox = SvgEarth.findPierceBoundingBox(new double[]{scaling.minDataDist, scaling.maxDataDist}, distDepthRange.getDepthAxisMinMax(), R);
                scaling = new SvgEarthScaling(bbox, R);
            } else if (distDepthRange.hasDistAxisMinMax() && !distDepthRange.hasDepthAxisMinMax()) {
                double[] bbox;
                boolean lookingFirst = true;
                double distMinDepth = 0.0;
                double distMaxDepth = 0.0;
                for (Arrival arrival : arrivalList) {
                    for (TimeDist td : arrival.getPierce()) {
                        if (!(distDepthRange.getDistAxisMinMax()[0] <= td.getDistDeg()) || !(td.getDistDeg() <= distDepthRange.getDistAxisMinMax()[1])) continue;
                        if (lookingFirst) {
                            distMinDepth = td.getDepth();
                            distMaxDepth = td.getDepth();
                            lookingFirst = false;
                            continue;
                        }
                        if (td.getDepth() < distMinDepth) {
                            distMinDepth = td.getDepth();
                        }
                        if (!(td.getDepth() > distMaxDepth)) continue;
                        distMaxDepth = td.getDepth();
                    }
                }
                if (lookingFirst) {
                    bbox = SvgEarth.findPierceBoundingBox(distDepthRange.getDistAxisMinMax(), new double[]{minDepth, maxDepth}, R);
                    scaling = new SvgEarthScaling(bbox, R);
                } else {
                    minDepth = distMinDepth;
                    maxDepth = distMaxDepth;
                    if (minDepth == maxDepth) {
                        minDepth -= 100.0;
                        maxDepth += 100.0;
                    }
                    bbox = SvgEarth.findPierceBoundingBox(distDepthRange.getDistAxisMinMax(), new double[]{minDepth, maxDepth}, R);
                    scaling = new SvgEarthScaling(bbox, R);
                }
            }
            if ((double)scaling.getZoomScale() < 1.25) {
                scaling = new SvgEarthScaling(R);
            }
        }
        return scaling;
    }

    public static double[] findPierceBoundingBox(double[] distRangeDeg, double[] depthRange, double R) {
        double ymin;
        double xmin;
        double xmax = xmin = Math.sin(distRangeDeg[0] * Math.PI / 180.0) * (R - depthRange[0]);
        double ymax = ymin = Math.cos(distRangeDeg[0] * Math.PI / 180.0) * (R - depthRange[0]);
        for (int i = 0; i < distRangeDeg.length; ++i) {
            for (int j = 0; j < depthRange.length; ++j) {
                double y;
                double x = Math.sin(distRangeDeg[i] * Math.PI / 180.0) * (R - depthRange[j]);
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if ((y = Math.cos(distRangeDeg[i] * Math.PI / 180.0) * (R - depthRange[j])) < ymin) {
                    ymin = y;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
        }
        return new double[]{xmin, xmax, ymin, ymax};
    }

    public static double[] findPierceBoundingBox(List<Arrival> arrivals) {
        double ymin;
        double xmin;
        if (arrivals.isEmpty()) {
            return null;
        }
        Arrival arrival = arrivals.get(0);
        arrival.getPierce();
        double R = arrival.getTauModel().getRadiusOfEarth();
        TimeDist td = arrival.getPiercePoint(0);
        double xmax = xmin = Math.sin(td.getDistRadian()) * (R - td.getDepth());
        double ymax = ymin = Math.cos(td.getDistRadian()) * (R - td.getDepth());
        for (Arrival arr : arrivals) {
            if (!arr.isLongWayAround()) continue;
            return new double[]{-R, R, -R, R};
        }
        for (Arrival arr : arrivals) {
            TimeDist[] pierce;
            for (TimeDist td2 : pierce = arr.getPierce()) {
                double y;
                double x = Math.sin(td2.getDistRadian()) * (R - td2.getDepth());
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if ((y = Math.cos(td2.getDistRadian()) * (R - td2.getDepth())) < ymin) {
                    ymin = y;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
        }
        return new double[]{xmin, xmax, ymin, ymax};
    }

    public static List<Arrival> createBoundingArrivals(List<SeismicPhase> phaseList) {
        ArrayList<Arrival> arrivalList = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            Arrival rayFirstArrival = phase.createArrivalAtIndex(0);
            arrivalList.add(rayFirstArrival);
            Arrival rayLastArrival = phase.createArrivalAtIndex(phase.getRayParams().length - 1);
            arrivalList.add(rayLastArrival);
        }
        return arrivalList;
    }

    public static void printModelAsSVG(PrintWriter out, TauModel tMod, float pixelWidth, SvgEarthScaling scaleTrans, boolean onlyNamedDiscon) {
        float zoomScale = scaleTrans.getZoomScale();
        float zoomTranslateX = scaleTrans.getZoomTranslateX();
        float zoomTranslateY = scaleTrans.getZoomTranslateY();
        double minDist = scaleTrans.getLabelRange()[0];
        double maxDist = scaleTrans.getLabelRange()[1];
        float R = (float)tMod.getRadiusOfEarth();
        float plotSize = R * 1.2f;
        float plotScale = pixelWidth / (2.0f * R * 1.2f);
        out.println("<!-- scale/translate so coordinates in earth units ( square ~ 2R x 2R)-->");
        out.println("<g transform=\"scale(" + plotScale + "," + plotScale + ")\" >");
        out.println("<g transform=\"translate(" + plotSize + "," + plotSize + ")\" >");
        out.println("<!-- scale/translate so zoomed in on area of interest -->");
        out.println("<g transform=\"scale(" + zoomScale + "," + zoomScale + ")\" >");
        out.println("<g transform=\"translate(" + zoomTranslateX + "," + zoomTranslateY + ")\" >");
        out.println("<g class=\"ticks\">");
        out.println("<!-- draw surface and label distances.-->");
        float step = 30.0f;
        float maxTick = 180.0f;
        float minTick = -180.0f + step;
        if (zoomScale > 1.0f) {
            double distRangeDeg = (maxDist - minDist) * 180.0 / Math.PI;
            step = distRangeDeg >= 60.0 ? 10.0f : (distRangeDeg >= 30.0 ? 5.0f : (distRangeDeg >= 10.0 ? 2.0f : (distRangeDeg > 5.0 ? 1.0f : (float)((int)Math.floor(maxDist / 10.0)))));
            if (step < 5.0f) {
                maxTick = (float)(Math.ceil(maxDist * 180.0 / Math.PI / (double)step + 2.0) * (double)step);
                minTick = (float)(Math.floor(minDist * 180.0 / Math.PI / (double)step - 2.0) * (double)step);
            } else {
                maxTick = 180.0f;
                minTick = -180.0f + step;
            }
        }
        double tickLen = (double)R * 0.05;
        out.println("<!-- tick marks every " + step + " degrees to " + maxTick + ".-->");
        for (float i = minTick; i <= maxTick; i += step) {
            out.println("  <polyline  class=\"tick\"  points=\"" + SvgEarth.formatDistRadiusAsXY(i, R) + ", " + SvgEarth.formatDistRadiusAsXY(i, (double)R + tickLen / (double)zoomScale) + "\" />");
            double radian = (double)(i - 90.0f) * Math.PI / 180.0;
            double x = ((double)R + tickLen * 1.05 / (double)zoomScale) * Math.cos(radian);
            double y = ((double)R + tickLen * 1.05 / (double)zoomScale) * Math.sin(radian);
            String anchor = i < -135.0f || -45.0f < i && i < 45.0f || i > 135.0f ? "middle" : (45.0f <= i && i < 135.0f ? "start" : (-135.0f <= i && i < -45.0f || 225.0f <= i && i < 315.0f ? "end" : "middle"));
            String alignBaseline = -60.0f < i && i < 60.0f || 300.0f < i ? "baseline" : (-120.0f < i && i <= 120.0f || 240.0f < i && i < 300.0f ? "middle" : (i < -120.0f || i > 120.0f ? "hanging" : "baseline"));
            out.println("  <text dominant-baseline=\"" + alignBaseline + "\" text-anchor=\"" + anchor + "\" class=\"label\" x=\"" + Outputs.formatDistance(x).trim() + "\" y=\"" + Outputs.formatDistance(y).trim() + "\">" + i + "</text>");
        }
        out.println("  </g>");
        out.println("<g class=\"layers\">");
        out.println("  <circle class=\"discontinuity surface\" cx=\"0.0\" cy=\"0.0\" r=\"" + R + "\" />");
        double[] branchDepths = tMod.getBranchDepths();
        for (int i = 0; i < branchDepths.length; ++i) {
            if (tMod.isNoDisconDepth(branchDepths[i]) || onlyNamedDiscon && !tMod.getVelocityModel().isNamedDisconDepth(branchDepths[i])) continue;
            Object name = i == tMod.getMohoBranch() ? " moho" : (i == tMod.getCmbBranch() ? " cmb" : (i == tMod.getIocbBranch() ? " iocb" : " " + branchDepths[i]));
            out.println("  <circle class=\"discontinuity" + (String)name + "\" cx=\"0.0\" cy=\"0.0\" r=\"" + ((double)R - branchDepths[i]) + "\" />");
        }
        out.println("  </g>");
        out.println("<!-- draw paths, coordinates are x,y not degree,radius due to SVG using only cartesian -->");
    }

    protected static double[] xyForDistRadius(double calcDist, double radius) {
        double radian = (calcDist - 90.0) * Math.PI / 180.0;
        double x = radius * Math.cos(radian);
        double y = radius * Math.sin(radian);
        return new double[]{x, y};
    }

    protected static String formatDistRadiusAsXY(double calcDist, double radius) {
        double[] xy = SvgEarth.xyForDistRadius(calcDist, radius);
        return Outputs.formatDistance(xy[0]) + "  " + Outputs.formatDistance(xy[1]);
    }

    public static String formatDistRadius(double calcDist, double radius) {
        return Outputs.formatDistance(calcDist) + "  " + Outputs.formatDepth(radius);
    }

    public static SvgEarthScaling calcZoomScaleTranslate(List<Arrival> arrivals) {
        float R = 6371.0f;
        if (!arrivals.isEmpty()) {
            R = (float)arrivals.get(0).getTauModel().getRadiusOfEarth();
        }
        if (arrivals.isEmpty()) {
            return new SvgEarthScaling(R);
        }
        for (Arrival arr : arrivals) {
            if (!arr.isLongWayAround()) continue;
            return new SvgEarthScaling(R);
        }
        double minDist = 0.0;
        double maxDist = 0.0;
        double minDepth = 0.0;
        double maxDepth = 0.0;
        double[] minmax = SvgEarth.findPierceBoundingBox(arrivals);
        for (Arrival arr : arrivals) {
            TimeDist[] pierce;
            for (TimeDist td : pierce = arr.getPierce()) {
                if (td.getDistRadian() > maxDist) {
                    maxDist = td.getDistRadian();
                }
                if (td.getDistRadian() < minDist) {
                    minDist = td.getDistRadian();
                }
                if (td.getDepth() < minDepth) {
                    minDepth = td.getDepth();
                }
                if (!(td.getDepth() > maxDepth)) continue;
                maxDepth = td.getDepth();
            }
        }
        return new SvgEarthScaling(minmax, R);
    }

    public static void printSvgEnding(PrintWriter out) {
        out.println("  </g> ");
        out.println("  </g> <!-- end zoom -->");
        out.println("  </g> <!-- end translate -->");
        out.println("  </g> ");
        out.println("</svg>");
    }

    public static void printSvgEndZoom(PrintWriter out) {
        out.println("  </g> ");
        out.println("  </g> <!-- end zoom -->");
        out.println("  </g> <!-- end translate -->");
        out.println("  </g> ");
    }

    public static void printSvgEnd(PrintWriter out) {
        out.println("</svg>");
    }

    public static void printGmtScriptBeginning(PrintWriter out, String psFile, TauModel tMod, float mapWidth, String mapWidthUnit, boolean onlyNamedDiscon, String toolName, List<String> cmdLineArgs) {
        out.println("#!/usr/bin/env bash");
        SvgUtil.taupMetadataGMT(out, toolName, cmdLineArgs, null);
        out.println("gmt begin " + psFile);
        out.println("# draw surface and label distances.\ngmt basemap -R0/360/0/" + tMod.getRadiusOfEarth() + " -JPa" + mapWidth + mapWidthUnit + " -Bx30  ");
        out.println("# draw circles for branches, note these are scaled for a \n# map using -JP" + mapWidth + mapWidthUnit + "\ngmt plot  -Sc -A  <<ENDLAYERS");
        out.println("0.0 0.0 " + mapWidth + mapWidthUnit);
        double[] branchDepths = tMod.getBranchDepths();
        for (int i = 0; i < branchDepths.length; ++i) {
            if (tMod.isNoDisconDepth(branchDepths[i]) || onlyNamedDiscon && !tMod.getVelocityModel().isNamedDisconDepth(branchDepths[i])) continue;
            out.println("0.0 0.0 " + (float)((tMod.getRadiusOfEarth() - branchDepths[i]) * (double)mapWidth / tMod.getRadiusOfEarth()) + mapWidthUnit);
        }
        out.println("ENDLAYERS\n");
        out.println("# draw paths");
    }

    public static int calcFontSizeForEarthScale(TauModel tMod, SvgEarthScaling scaleTrans) {
        float zoomScale = scaleTrans.getZoomScale();
        float R = (float)tMod.getRadiusOfEarth();
        float plotSize = R * 1.2f;
        int fontSize = (int)(plotSize / 20.0f);
        fontSize = (int)((float)fontSize / zoomScale);
        return fontSize;
    }

    public static void printScriptBeginningSvg(PrintWriter out, TauModel tMod, float pixelWidth, SvgEarthScaling scaleTrans, String toolName, List<String> cmdLineArgs, List<String> colorList, String extraCSS) {
        int plotOffset = 0;
        int fontSize = SvgEarth.calcFontSizeForEarthScale(tMod, scaleTrans);
        StringBuffer addCSS = SvgUtil.resizeLabels(fontSize);
        addCSS.append(extraCSS);
        SvgUtil.xyplotScriptBeginning(out, toolName, cmdLineArgs, pixelWidth, plotOffset, colorList, addCSS.toString());
    }
}

