/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LinearInterpolation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimeDist
implements Cloneable {
    private final double p;
    private final double depth;
    private final double time;
    private final double distRadian;

    public TimeDist() {
        this.p = 0.0;
        this.depth = 0.0;
        this.time = 0.0;
        this.distRadian = 0.0;
    }

    public TimeDist(double p) {
        this.p = p;
        this.depth = 0.0;
        this.time = 0.0;
        this.distRadian = 0.0;
    }

    public TimeDist(double p, double time, double dist) {
        this.p = p;
        this.depth = 0.0;
        this.time = time;
        this.distRadian = dist;
    }

    public TimeDist(double p, double time, double dist, double depth) {
        this.p = p;
        this.depth = depth;
        this.time = time;
        this.distRadian = dist;
    }

    public TimeDist add(TimeDist td) {
        return new TimeDist(this.getP(), this.getTime() + td.getTime(), this.getDistRadian() + td.getDistRadian(), td.getDepth());
    }

    public TimeDist negateDistance() {
        return new TimeDist(this.getP(), this.getTime(), -1.0 * this.getDistRadian(), this.getDepth());
    }

    public static List<TimeDist> negateDistance(List<TimeDist> pierce) {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        for (TimeDist td : pierce) {
            out.add(td.negateDistance());
        }
        return out;
    }

    public String toString() {
        return "p= " + this.p + " time=" + this.time + " dist=" + this.getDistDeg() + "(" + this.distRadian + " rad) depth=" + this.depth;
    }

    public double getP() {
        return this.p;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getTime() {
        return this.time;
    }

    public double getDistRadian() {
        return this.distRadian;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDistRadian();
    }

    public static TimeDist linearInterpOnDepth(TimeDist tdA, TimeDist tdB, double depth) {
        double distConnect = LinearInterpolation.linearInterp(tdA.getDepth(), tdA.getDistRadian(), tdB.getDepth(), tdB.getDistRadian(), depth);
        double raypConnect = LinearInterpolation.linearInterp(tdA.getDepth(), tdA.getP(), tdB.getDepth(), tdB.getP(), depth);
        double timeConnect = LinearInterpolation.linearInterp(tdA.getDepth(), tdA.getTime(), tdB.getDepth(), tdB.getTime(), depth);
        TimeDist disconInterp = new TimeDist(raypConnect, timeConnect, distConnect, depth);
        return disconInterp;
    }

    public static TimeDist linearInterpOnTime(TimeDist tdA, TimeDist tdB, double time) {
        double distConnect = LinearInterpolation.linearInterp(tdA.getTime(), tdA.getDistRadian(), tdB.getTime(), tdB.getDistRadian(), time);
        double depthConnect = LinearInterpolation.linearInterp(tdA.getTime(), tdA.getDepth(), tdB.getTime(), tdB.getDepth(), time);
        double raypConnect = LinearInterpolation.linearInterp(tdA.getTime(), tdA.getP(), tdB.getTime(), tdB.getP(), time);
        TimeDist disconInterp = new TimeDist(raypConnect, time, distConnect, depthConnect);
        return disconInterp;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDist timeDist = (TimeDist)o;
        return Double.compare(timeDist.p, this.p) == 0 && Double.compare(timeDist.depth, this.depth) == 0 && Double.compare(timeDist.time, this.time) == 0 && Double.compare(timeDist.distRadian, this.distRadian) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.p, this.depth, this.time, this.distRadian);
    }
}

