/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceKmRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.ExactDistanceRay;
import edu.sc.seis.TauP.FixedHemisphereDistanceRay;
import edu.sc.seis.TauP.IncidentAngleRay;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.RayParamKmRay;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.TakeoffAngleRay;
import edu.sc.seis.TauP.gson.DistanceAngleRaySerializier;
import edu.sc.seis.TauP.gson.LocationSerializer;
import java.lang.reflect.Type;

public class RayCalculateableSerializer
implements JsonSerializer<RayCalculateable> {
    LocationSerializer locSerial = new LocationSerializer();
    DistanceAngleRaySerializier darSerializer = new DistanceAngleRaySerializier();

    public JsonElement serialize(RayCalculateable src, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject out = new JsonObject();
        out.addProperty("type", src.getClass().getSimpleName());
        JsonObject ray = new JsonObject();
        if (src instanceof TakeoffAngleRay) {
            TakeoffAngleRay to = (TakeoffAngleRay)src;
            ray.addProperty("takeoff", (Number)to.getTakeoffAngle());
        } else if (src instanceof IncidentAngleRay) {
            IncidentAngleRay to = (IncidentAngleRay)src;
            ray.addProperty("incident", (Number)to.getIncidentAngle());
        } else if (src instanceof RayParamRay) {
            RayParamRay r = (RayParamRay)src;
            if (r.hasSDegree()) {
                ray.addProperty("rayparam", (Number)r.getRayParamSDegree());
                ray.addProperty("unit", "s/deg");
            } else {
                ray.addProperty("rayparam", (Number)r.getRayParam());
                ray.addProperty("unit", "s/rad");
            }
        } else if (src instanceof RayParamKmRay) {
            RayParamKmRay r = (RayParamKmRay)src;
            ray.addProperty("rayparam", (Number)r.getRayParamSKm());
            ray.addProperty("unit", "s/km");
        } else if (src instanceof RayParamIndexRay) {
            RayParamIndexRay r = (RayParamIndexRay)src;
            ray.addProperty("index", (Number)r.getIndex());
        } else if (src instanceof DistanceRay) {
            DistanceRay r;
            if (src instanceof FixedHemisphereDistanceRay) {
                FixedHemisphereDistanceRay fhdr = (FixedHemisphereDistanceRay)src;
                r = fhdr.getWrappedDistanceRay();
                ray.addProperty("hemisphere", fhdr.isNegativeHemisphere() ? "negative" : "positive");
            } else if (src instanceof ExactDistanceRay) {
                ExactDistanceRay edr = (ExactDistanceRay)src;
                ray.addProperty("exact", "true");
                r = edr.getWrappedDistanceRay();
            } else {
                r = (DistanceRay)src;
            }
            if (r instanceof DistanceAngleRay) {
                DistanceAngleRay dar = (DistanceAngleRay)r;
                if (dar.isDegrees()) {
                    ray.addProperty("deg", (Number)dar.getDegrees());
                    ray.addProperty("unit", "deg");
                } else {
                    ray.addProperty("radian", (Number)dar.getRadians());
                    ray.addProperty("unit", "rad");
                }
            } else if (r instanceof DistanceKmRay) {
                DistanceKmRay kmr = (DistanceKmRay)src;
                ray.addProperty("km", (Number)kmr.getKilometers());
                ray.addProperty("unit", "km");
            } else {
                throw new RuntimeException("Unable to serialize ray: " + src);
            }
        }
        out.add("ray", (JsonElement)ray);
        return out;
    }
}

