/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class ChannelTimeWindow {
    String network;
    String station;
    String location;
    String channel;
    Instant beginTime;
    Instant endTime;

    public ChannelTimeWindow(String network, String station, String location, String channel, Instant beginTime, Instant endTime) {
        this.network = network;
        this.station = station;
        this.location = location;
        this.channel = channel;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public ChannelTimeWindow(String network, String station, String location, String channel, Instant beginTime, int durationSeconds) {
        this(network, station, location, channel, beginTime, beginTime.plusSeconds(durationSeconds));
    }

    public String getNetwork() {
        return this.network;
    }

    public String getStation() {
        return this.station;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public Instant getBeginTime() {
        return this.beginTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return this.formString(" ", AbstractQueryParams.createDateFormat(), false);
    }

    public String formString(String seperator, DateTimeFormatter df, boolean dashifyLocId) {
        String locId = this.location;
        if (dashifyLocId && ("".equals(locId) || "  ".equals(locId))) {
            locId = "--";
        }
        return this.network + seperator + this.station + seperator + locId + seperator + this.channel + seperator + df.format(this.beginTime) + seperator + df.format(this.endTime);
    }
}

