/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.datalink;

import edu.sc.seis.seisFile.datalink.DataLinkException;
import edu.sc.seis.seisFile.datalink.DataLinkHeader;
import edu.sc.seis.seisFile.datalink.DataLinkResponse;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class DataLinkPacket
extends DataLinkResponse {
    String streamId = this.headerSplit(1);
    String pktid = this.headerSplit(2);
    String hppackettime = this.headerSplit(3);
    String hppacketstart = this.headerSplit(4);
    String hppacketend = this.headerSplit(5);
    int dataSize = Integer.parseInt(this.headerSplit(6));
    byte[] rawData;
    DataRecord miniseed;

    public DataLinkPacket(DataLinkHeader header, byte[] rawData) throws DataLinkException {
        super(header);
        this.rawData = rawData;
        if (rawData.length < this.dataSize) {
            throw new DataLinkException("not enough bytes in raw data for packet: " + this.dataSize);
        }
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getPktid() {
        return this.pktid;
    }

    public String getHppackettime() {
        return this.hppackettime;
    }

    public String getHppacketstart() {
        return this.hppacketstart;
    }

    public String getHppacketend() {
        return this.hppacketend;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public boolean isMiniseed() {
        return this.miniseed != null || this.streamId.endsWith("MSEED");
    }

    public DataRecord getMiniseed() throws DataLinkException {
        if (this.miniseed == null) {
            if (this.streamId.endsWith("MSEED")) {
                try {
                    DataInputStream bis = new DataInputStream(new ByteArrayInputStream(this.rawData));
                    this.miniseed = (DataRecord)DataRecord.read(bis);
                }
                catch (SeedFormatException e) {
                    throw new DataLinkException(e);
                }
                catch (IOException e) {
                    throw new DataLinkException(e);
                }
            } else {
                throw new DataLinkException("Unknown DataLink Packet type: " + this.streamId);
            }
        }
        return this.miniseed;
    }
}

