/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Axis {
    RealQuantity azimuth;
    RealQuantity plunge;
    RealQuantity length;

    public Axis(XMLEventReader reader, String elementName) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("azimuth")) {
                    this.azimuth = new RealQuantity(reader, "azimuth");
                    continue;
                }
                if (elName.equals("plunge")) {
                    this.plunge = new RealQuantity(reader, "plunge");
                    continue;
                }
                if (elName.equals("length")) {
                    this.length = new RealQuantity(reader, "length");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public RealQuantity getAzimuth() {
        return this.azimuth;
    }

    public RealQuantity getLength() {
        return this.length;
    }

    public RealQuantity getPlunge() {
        return this.plunge;
    }

    public void setAzimuth(RealQuantity azimuth) {
        this.azimuth = azimuth;
    }

    public void setLength(RealQuantity length) {
        this.length = length;
    }

    public void setPlunge(RealQuantity plunge) {
        this.plunge = plunge;
    }
}

