/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;

public class EventAzimuth
extends LatLonable {
    double azimuth;
    LatLonLocatable evtLatLon;

    public EventAzimuth(LatLonLocatable evtLatLon, Double azimuth) {
        this.evtLatLon = evtLatLon;
        this.azimuth = azimuth;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        if (this.isGeodetic()) {
            throw new RuntimeException("geodetic not yet");
        }
        Location evtLoc = this.evtLatLon.asLocation();
        out[0] = SphericalCoords.latFor(evtLoc.getLatitude(), evtLoc.getLongitude(), calcDist, this.azimuth);
        out[1] = SphericalCoords.lonFor(evtLoc.getLatitude(), evtLoc.getLongitude(), calcDist, this.azimuth);
        return out;
    }
}

