/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.RadiationAmplitude;
import edu.sc.seis.TauP.SphericalCoordinate;
import edu.sc.seis.TauP.Vector;
import edu.sc.seis.seisFile.fdsnws.quakeml.NodalPlane;
import java.util.Objects;

public class FaultPlane {
    double strike;
    double dip;
    double rake;

    public FaultPlane(double strike, double dip, double rake) {
        this.strike = strike;
        this.dip = dip;
        this.rake = rake;
    }

    public FaultPlane(NodalPlane qmlNodalPlane) {
        this(qmlNodalPlane.getStrike().getValue().floatValue(), qmlNodalPlane.getDip().getValue().floatValue(), qmlNodalPlane.getRake().getValue().floatValue());
    }

    public Vector faultNormal() {
        double s = this.strike * (Math.PI / 180);
        double d = this.dip * (Math.PI / 180);
        double r = this.rake * (Math.PI / 180);
        return new Vector(Math.sin(d) * Math.cos(s), -1.0 * Math.sin(d) * Math.sin(s), Math.cos(d));
    }

    public Vector faultSlip() {
        return this.faultVector(this.rake);
    }

    public Vector faultVector(double rake) {
        double s = this.strike * (Math.PI / 180);
        double d = this.dip * (Math.PI / 180);
        double r = rake * (Math.PI / 180);
        return new Vector(Math.cos(r) * Math.sin(s) - Math.sin(r) * Math.cos(d) * Math.cos(s), Math.sin(r) * Math.cos(d) * Math.sin(s) + Math.cos(r) * Math.cos(s), Math.sin(r) * Math.sin(d));
    }

    public FaultPlane auxPlane() {
        Vector normal = this.faultSlip();
        Vector slip = this.faultNormal();
        double dip = Math.acos(normal.z);
        double sinDip = Math.sin(dip);
        double strike = Math.atan2(-1.0 * normal.y / sinDip, normal.x / sinDip);
        double rake = Math.asin(slip.z / sinDip);
        FaultPlane auxPlane = new FaultPlane(strike * 57.29577951308232, dip * 57.29577951308232, rake * 57.29577951308232);
        return auxPlane;
    }

    public Vector nullAxis() {
        Vector b = Vector.crossProduct(this.faultNormal(), this.faultSlip());
        if (b.z > 0.0) {
            b = b.negate();
        }
        return b;
    }

    public Vector pAxis() {
        Vector n = this.faultNormal();
        Vector d = this.faultSlip();
        Vector p = n.plus(d).normalize();
        if (p.z > 0.0) {
            p = p.negate();
        }
        return p;
    }

    public Vector tAxis() {
        Vector n = this.faultNormal();
        Vector d = this.faultSlip();
        Vector t = n.minus(d).normalize();
        if (t.z > 0.0) {
            t = t.negate();
        }
        return t;
    }

    public RadiationAmplitude calcRadiationPatDegree(double azimuth, double takeoff) {
        double[] radiationPattern = this.calcRadiationPatRadian(azimuth * (Math.PI / 180), takeoff * (Math.PI / 180));
        SphericalCoordinate coord = SphericalCoordinate.fromAzTakeoffDegree(azimuth, takeoff);
        RadiationAmplitude radAmp = new RadiationAmplitude(coord, radiationPattern);
        return radAmp;
    }

    public double[] calcRadiationPatRadian(double azimuth, double takeoff) {
        double ih = takeoff;
        double phi_f = this.strike * (Math.PI / 180);
        double phi_r = azimuth;
        double phi_r_f = phi_r - phi_f;
        double theta = this.dip * (Math.PI / 180);
        double lam = this.rake * (Math.PI / 180);
        double Fp = (Math.cos(lam) * Math.sin(theta) * Math.sin(2.0 * phi_r_f) - Math.sin(lam) * Math.sin(2.0 * theta) * Math.sin(phi_r_f) * Math.sin(phi_r_f)) * Math.sin(ih) * Math.sin(ih) + (Math.sin(lam) * Math.cos(2.0 * theta) * Math.sin(phi_r_f) - Math.cos(lam) * Math.cos(theta) * Math.cos(phi_r_f)) * Math.sin(2.0 * ih) + Math.sin(lam) * Math.sin(2.0 * theta) * Math.cos(ih) * Math.cos(ih);
        double Fsv = (Math.sin(lam) * Math.cos(2.0 * theta) * Math.sin(phi_r_f) - Math.cos(lam) * Math.cos(theta) * Math.cos(phi_r_f)) * Math.cos(2.0 * ih) + 0.5 * Math.cos(lam) * Math.sin(theta) * Math.sin(2.0 * phi_r_f) * Math.sin(2.0 * ih) - 0.5 * Math.sin(lam) * Math.sin(2.0 * theta) * Math.sin(2.0 * ih) * (1.0 + Math.sin(phi_r_f) * Math.sin(phi_r_f));
        double Fsh = (Math.cos(lam) * Math.cos(theta) * Math.sin(phi_r_f) + Math.sin(lam) * Math.cos(2.0 * theta) * Math.cos(phi_r_f)) * Math.cos(ih) + (Math.cos(lam) * Math.sin(theta) * Math.cos(2.0 * phi_r_f) - 0.5 * Math.sin(lam) * Math.sin(2.0 * theta) * Math.sin(2.0 * phi_r_f)) * Math.sin(ih);
        return new double[]{Fp, Fsv, Fsh};
    }

    public double getStrike() {
        return this.strike;
    }

    public double getDip() {
        return this.dip;
    }

    public double getRake() {
        return this.rake;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FaultPlane)) {
            return false;
        }
        FaultPlane that = (FaultPlane)o;
        return Double.compare(this.strike, that.strike) == 0 && Double.compare(this.dip, that.dip) == 0 && Double.compare(this.rake, that.rake) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.strike, this.dip, this.rake);
    }

    public String toString() {
        return "strike: " + this.strike + " dip: " + this.dip + " rake: " + this.rake;
    }
}

