/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.ShootableRay;
import edu.sc.seis.TauP.TauPException;
import java.util.List;

public class RayParamKmRay
extends ShootableRay {
    private final double rpSecKm;

    public RayParamKmRay(Double rpSecKm) {
        this.rpSecKm = rpSecKm;
        this.setDescription(rpSecKm + " s/km");
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) throws TauPException {
        RayParamRay rpRay = RayParamRay.ofRayParamSRadian(this.getRayParamSKm() * phase.getTauModel().getRadiusOfEarth());
        List<Arrival> arrivals = rpRay.calculate(phase);
        for (Arrival a : arrivals) {
            a.setSearchValue(this);
        }
        return arrivals;
    }

    public Double getRayParamSKm() {
        return this.rpSecKm;
    }
}

