/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.CompositeSeismicPhase;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.FailedSeismicPhase;
import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseLayerFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowOrProto;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SeismicPhaseFactory {
    boolean DEBUG;
    String name;
    double receiverDepth;
    TauModel tMod;
    int upgoingRecBranch;
    int downgoingRecBranch;
    PhaseInteraction prevEndAction = PhaseInteraction.START;
    public static final int CRUST_MANTLE_FACTORY = 0;
    public static final int OUTER_CORE_FACTOR = 1;
    public static final int INNER_CORE_FACTORY = 2;
    protected static double maxRefraction = 20.0;
    protected static double maxDiffraction = 60.0;
    static double maxKmpsLaps = 1.0;

    public static double getMaxRefraction() {
        return maxRefraction;
    }

    public static void setMaxRefraction(double max) {
        maxRefraction = max;
    }

    public static double getMaxDiffraction() {
        return maxDiffraction;
    }

    public static void setMaxDiffraction(double max) {
        maxDiffraction = max;
    }

    public static double getMaxKmpsLaps() {
        return maxKmpsLaps;
    }

    public static void setMaxKmpsLaps(double max) {
        maxKmpsLaps = max;
    }

    SeismicPhaseFactory(String name, TauModel tMod, double sourceDepth, double receiverDepth, boolean debug) throws TauModelException {
        this.DEBUG = debug;
        if (name == null || name.isEmpty()) {
            throw new TauModelException("Phase name cannot be empty or null: '" + name + "'");
        }
        TauModel sourceDepthTMod = sourceDepth == tMod.getSourceDepth() ? tMod : tMod.depthCorrect(sourceDepth);
        this.tMod = sourceDepthTMod.splitBranch(receiverDepth);
        this.name = name;
        this.receiverDepth = receiverDepth;
        this.upgoingRecBranch = this.tMod.findBranch(receiverDepth);
        this.downgoingRecBranch = this.upgoingRecBranch - 1;
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, tMod.getSourceDepth());
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, sourceDepth, 0.0);
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth, double receiverDepth) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, sourceDepth, receiverDepth, TauPConfig.DEBUG);
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth, double receiverDepth, boolean debug) throws TauModelException {
        SeismicPhaseFactory factory = new SeismicPhaseFactory(name, tMod, sourceDepth, receiverDepth, debug);
        return factory.internalCreatePhase();
    }

    public static void configure(Properties toolProps) {
        if (toolProps.containsKey("taup.maxRefraction")) {
            SeismicPhaseFactory.setMaxRefraction(Double.parseDouble(toolProps.getProperty("taup.maxRefraction")));
        }
        if (toolProps.containsKey("taup.maxDiffraction")) {
            SeismicPhaseFactory.setMaxDiffraction(Double.parseDouble(toolProps.getProperty("taup.maxDiffraction")));
        }
        if (toolProps.containsKey("taup.maxKmpsLaps")) {
            SeismicPhaseFactory.setMaxKmpsLaps(Double.parseDouble(toolProps.getProperty("taup.maxKmpsLaps")));
        }
    }

    public static List<SeismicPhase> createSeismicPhases(String name, TauModel tMod, double sourceDepth, double receiverDepth, Scatterer scat, boolean debug) throws TauModelException {
        ArrayList<SeismicPhase> phaseList = new ArrayList<SeismicPhase>();
        Pattern scatPattern = Pattern.compile("(?<inscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)(?<scat>[oO])(?<outscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)");
        Matcher m = scatPattern.matcher(name);
        if (m.matches()) {
            String inbound = m.group("inscat");
            String outbound = m.group("outscat");
            if (inbound.isEmpty() || name.charAt(0) == 'o' || name.charAt(0) == 'O') {
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, "Scatter phase cannot start with symbols, oO, in " + name + ", must have phase from source to scatterer.");
                phaseList.add(fail);
                return phaseList;
            }
            if (outbound.charAt(0) == 'o' || outbound.charAt(0) == 'O') {
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, "Scatter phase cannot have repeat symbols, oO, in " + name + ", must have only one scatterer.");
                phaseList.add(fail);
                return phaseList;
            }
            if (outbound.isEmpty()) {
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, "Scatter phase cannot end with symbols, oO, in " + name + ", must have phase from scatterer to receiver.");
                phaseList.add(fail);
                return phaseList;
            }
            Matcher outM = scatPattern.matcher(outbound);
            if (outM.matches()) {
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, "Scatter phase cannot have multiple scatter symbols, oO, in " + name + ", repeated scattering not supported");
                phaseList.add(fail);
                return phaseList;
            }
            if (scat == null) {
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, "Attempt to use scatter phase but scatter is missing: " + name);
                phaseList.add(fail);
                return phaseList;
            }
            String prescatterPhaseName = inbound;
            String postscatterPhaseName = outbound;
            boolean isBackscatter = name.contains("O");
            TauModel tModDepthCorrected = tMod;
            if (tModDepthCorrected.getSourceDepth() != sourceDepth) {
                tModDepthCorrected = tMod.depthCorrect(sourceDepth);
            }
            tModDepthCorrected = tModDepthCorrected.splitBranch(receiverDepth);
            TauModel scatTMod = tModDepthCorrected.depthRecorrect(scat.depth);
            SimpleSeismicPhase inPhase = SeismicPhaseFactory.createPhase(prescatterPhaseName, tModDepthCorrected, sourceDepth, scat.depth, debug);
            SeismicPhaseSegment lastSegment = inPhase.getFinalPhaseSegment();
            PhaseInteraction endAction = lastSegment.endAction;
            if (endAction == PhaseInteraction.END_DOWN) {
                lastSegment.endAction = isBackscatter ? PhaseInteraction.BACKSCATTER_DOWN : PhaseInteraction.SCATTER_DOWN;
            } else if (endAction == PhaseInteraction.END) {
                lastSegment.endAction = isBackscatter ? PhaseInteraction.BACKSCATTER : PhaseInteraction.SCATTER;
            }
            List<Arrival> inArrivals = scat.dist.calculate(inPhase);
            if (inArrivals.isEmpty()) {
                StringBuffer failReason = new StringBuffer("No inbound arrivals to the scatterer for " + name + " at " + scat.depth + " km depth and " + scat.dist.getDegrees(tMod.getRadiusOfEarth()) + " deg. Distance range for scatterer at this depth is " + inPhase.getMinDistanceDeg() + " " + inPhase.getMaxDistanceDeg() + " deg");
                FailedSeismicPhase fail = FailedSeismicPhase.failForReason(name, tMod, receiverDepth, failReason.toString());
                phaseList.add(fail);
                return phaseList;
            }
            SimpleSeismicPhase scatPhase = SeismicPhaseFactory.createPhase(postscatterPhaseName, scatTMod, scat.depth, receiverDepth, debug);
            Iterator<Arrival> iterator = inArrivals.iterator();
            while (iterator.hasNext()) {
                Arrival inArr;
                Arrival flipInArr = inArr = iterator.next();
                if (inArr.getDistDeg() == -1.0 * scat.dist.getDegrees(scatPhase.getTauModel().getRadiusOfEarth())) {
                    flipInArr = inArr.negateDistance();
                }
                ScatteredSeismicPhase seismicPhase = new ScatteredSeismicPhase(flipInArr, scatPhase, scat, isBackscatter);
                phaseList.add(seismicPhase);
            }
        } else {
            TauModel tModDepthCorrected = tMod;
            if (tModDepthCorrected.getSourceDepth() != sourceDepth) {
                tModDepthCorrected = tMod.depthCorrect(sourceDepth);
            }
            tModDepthCorrected = tModDepthCorrected.splitBranch(receiverDepth);
            SimpleSeismicPhase seismicPhase = SeismicPhaseFactory.createPhase(name, tModDepthCorrected, sourceDepth, receiverDepth, debug);
            phaseList.add(seismicPhase);
        }
        return phaseList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SeismicPhase> calculateSeismicPhases(TauModel tMod, List<PhaseName> phaseNameList, double sourceDepth, List<Double> receiverDepths, Scatterer scatterer) throws TauModelException {
        ArrayList<SeismicPhase> newPhases = new ArrayList<SeismicPhase>();
        TauModel tModDepth = tMod.depthCorrect(sourceDepth);
        if (receiverDepths.isEmpty()) {
            throw new RuntimeException("receiverDepths should not be empty");
        }
        for (Double receiverDepth : receiverDepths) {
            TauModel tModRecDepth = tModDepth.splitBranch(receiverDepth);
            for (PhaseName phaseName : phaseNameList) {
                String tempPhaseName = phaseName.getName();
                try {
                    List<SeismicPhase> calcPhaseList = SeismicPhaseFactory.createSeismicPhases(phaseName.getName(), tModRecDepth, sourceDepth, receiverDepth, scatterer, TauPConfig.DEBUG);
                    newPhases.addAll(calcPhaseList);
                    for (SeismicPhase seismicPhase : newPhases) {
                        if (!TauPConfig.VERBOSE) continue;
                        Alert.info(seismicPhase.toString());
                    }
                }
                catch (ScatterArrivalFailException e) {
                    Alert.warning(e.getMessage() + ", skipping this phase");
                    if (!TauPConfig.VERBOSE && !TauPConfig.DEBUG) continue;
                    e.printStackTrace();
                }
                catch (TauModelException e) {
                    Alert.warning("Error with phase=" + tempPhaseName, e.getMessage() + "\nSkipping this phase");
                    if (!TauPConfig.VERBOSE && !TauPConfig.DEBUG) continue;
                    e.printStackTrace();
                }
                finally {
                    if (!TauPConfig.VERBOSE) continue;
                    Alert.info("-----------------");
                }
            }
        }
        return newPhases;
    }

    SimpleSeismicPhase internalCreatePhase() throws TauModelException {
        ArrayList<String> legs = LegPuller.legPuller(this.name);
        ProtoSeismicPhase proto = this.parseName(this.tMod, legs);
        proto.phaseName = this.name;
        if (!proto.isFail) {
            proto.validateSegList();
        }
        if (proto.isSuccessful()) {
            return SeismicPhaseFactory.sumBranches(proto);
        }
        return new FailedSeismicPhase(proto);
    }

    public String getName() {
        return this.name;
    }

    public static Boolean legIsPWave(String currLeg) {
        if (PhaseSymbols.isCompressionalWaveSymbol(currLeg, 0)) {
            return true;
        }
        if (PhaseSymbols.isTransverseWaveSymbol(currLeg, 0)) {
            return false;
        }
        return null;
    }

    public static boolean[] legsArePWave(ArrayList<String> legs) {
        boolean[] isPWaveForLegs = new boolean[legs.size()];
        int legNum = 0;
        boolean prevWaveType = true;
        for (String currLeg : legs) {
            Boolean currWaveType;
            if (currLeg.equals("END")) {
                currWaveType = prevWaveType;
            } else {
                currWaveType = SeismicPhaseFactory.legIsPWave(currLeg);
                if (currWaveType == null) {
                    if (legNum == legs.size() - 2) {
                        currWaveType = prevWaveType;
                    } else if (legNum < legs.size() - 1) {
                        currWaveType = SeismicPhaseFactory.legIsPWave(legs.get(legNum + 1));
                        if (currWaveType == null) {
                            throw new RuntimeException("next wavetype is null: " + currLeg + " in " + legs + " " + legNum + " of " + legs.size());
                        }
                    } else {
                        throw new RuntimeException("SHould never happen: " + currLeg + " of " + legs + " " + legNum);
                    }
                }
            }
            isPWaveForLegs[legNum] = currWaveType;
            ++legNum;
            prevWaveType = currWaveType;
        }
        return isPWaveForLegs;
    }

    protected ProtoSeismicPhase parseName(TauModel tMod, ArrayList<String> legs) throws TauModelException {
        boolean prevIsPWave;
        String currLeg;
        String nextLeg = currLeg = legs.get(0);
        boolean isPWave = true;
        if (legs.size() == 2 && currLeg.endsWith("kmps")) {
            try {
                Double.parseDouble(currLeg.substring(0, this.name.length() - 4));
            }
            catch (NumberFormatException e) {
                return ProtoSeismicPhase.failNewPhase(tMod, false, true, this.receiverDepth, this.getName(), " Illegal surface wave velocity " + this.name.substring(0, this.name.length() - 4));
            }
            ProtoSeismicPhase proto = ProtoSeismicPhase.startEmpty(this.name, tMod, this.receiverDepth);
            proto.addFlatBranch(false, PhaseInteraction.KMPS, PhaseInteraction.END, currLeg);
            return proto;
        }
        if (!(this.name.indexOf(74) == -1 && this.name.indexOf(106) == -1 || tMod.getSlownessModel().isAllowInnerCoreS())) {
            return ProtoSeismicPhase.failNewPhase(tMod, false, true, this.receiverDepth, this.getName(), " 'J' phases were not created for this model: " + tMod.getModelName());
        }
        for (String leg : legs) {
            if (tMod.getCmbBranch() == tMod.getNumBranches() && (PhaseSymbols.isOuterCoreLeg(leg) || leg.length() == 1 && leg.charAt(0) == 'c')) {
                String reason = "Cannot have K leg in model with no outer core";
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if (tMod.getIocbBranch() != tMod.getNumBranches() || !PhaseSymbols.isInnerCoreLeg(leg) && (leg.length() != 1 || leg.charAt(0) != 'i')) continue;
            String reason = "Cannot have I,J,y,j,i leg in model with no inner core";
            return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
        }
        if (PhaseSymbols.isCompressionalWaveSymbol(currLeg)) {
            prevIsPWave = isPWave = true;
        } else if (PhaseSymbols.isTransverseWaveSymbol(currLeg)) {
            prevIsPWave = isPWave = false;
        } else {
            return ProtoSeismicPhase.failNewPhase(tMod, false, true, this.receiverDepth, this.getName(), this.getName() + " Unknown starting phase: " + currLeg);
        }
        if (PhaseSymbols.isTransverseWaveSymbol(currLeg)) {
            double sdep = tMod.getSourceDepth();
            if (tMod.getSlownessModel().depthInFluid(sdep, new DepthRange())) {
                String reason = "Cannot have S wave with starting depth in fluid layer " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
        }
        if (PhaseSymbols.isDowngoingSymbol(currLeg)) {
            if ((PhaseSymbols.startsWith(currLeg, 'P') || PhaseSymbols.startsWith(currLeg, 'S')) && tMod.getSourceDepth() > tMod.getCmbDepth()) {
                String reason = "Source must be in crust/mantle for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if (PhaseSymbols.startsWith(currLeg, 'K') && (tMod.getSourceDepth() < tMod.getCmbDepth() || tMod.getSourceDepth() > tMod.getIocbDepth())) {
                String reason = "Source must be in outer core for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if ((PhaseSymbols.startsWith(currLeg, 'I') || PhaseSymbols.startsWith(currLeg, 'J')) && tMod.getSourceDepth() < tMod.getIocbDepth()) {
                String reason = "Source must be in inner core for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
        } else if (PhaseSymbols.isUpgoingSymbol(currLeg)) {
            if (PhaseSymbols.isCrustMantleLeg(currLeg) && tMod.getSourceDepth() > tMod.getCmbDepth()) {
                String reason = "Source must be in crust/mantle for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if (PhaseSymbols.isOuterCoreLeg(currLeg) && (tMod.getSourceDepth() < tMod.getCmbDepth() || tMod.getSourceDepth() > tMod.getIocbDepth())) {
                String reason = "Source must be in outer core for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if (PhaseSymbols.isInnerCoreLeg(currLeg) && tMod.getSourceDepth() < tMod.getIocbDepth()) {
                String reason = "Source must be in inner core for " + currLeg;
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
            if (tMod.getSourceBranch() == 0) {
                String reason = " Upgoing initial leg but already at surface, so no ray parameters satisfy path." + tMod.getSourceBranch();
                return ProtoSeismicPhase.failNewPhase(tMod, PhaseSymbols.isCompressionalWaveSymbol(legs.get(0)), PhaseSymbols.isDowngoingSymbol(legs.get(0)), this.receiverDepth, this.name, reason);
            }
        } else {
            return ProtoSeismicPhase.failNewPhase(tMod, false, true, this.receiverDepth, this.getName(), " First phase leg not recognized: " + currLeg + " Must be one of P, Pg, Pn, Pdiff, p, Ped or the S equivalents in crust/mantle, or k, K, I, y, J, j for core sources.");
        }
        boolean[] isLegPWave = SeismicPhaseFactory.legsArePWave(legs);
        currLeg = "START";
        ProtoSeismicPhase proto = ProtoSeismicPhase.startEmpty(this.name, tMod, this.receiverDepth);
        for (int legNum = 0; legNum < legs.size(); ++legNum) {
            String nextNextLeg;
            String prevLeg = currLeg;
            currLeg = nextLeg;
            nextLeg = legNum < legs.size() - 1 ? legs.get(legNum + 1) : "END";
            if (this.DEBUG) {
                Alert.debug("Iterate legs: " + legNum + "  " + prevLeg + "  cur=" + currLeg + "  " + nextLeg);
            }
            if (currLeg.contentEquals("END") && !proto.segmentList.isEmpty()) {
                if (proto.endSegment().isDownGoing && !proto.endSegment().isFlat) {
                    proto.endSegment().endAction = PhaseInteraction.END_DOWN;
                    continue;
                }
                proto.endSegment().endAction = PhaseInteraction.END;
                continue;
            }
            prevIsPWave = isPWave;
            boolean nextIsPWave = isPWave = isLegPWave[legNum];
            if (legNum < isLegPWave.length - 1) {
                nextIsPWave = isLegPWave[legNum + 1];
            }
            List<SeismicPhaseLayerFactory> layerFactories = SeismicPhaseLayerFactory.createFactory(this);
            String string = nextNextLeg = legNum < legs.size() - 2 ? legs.get(legNum + 2) : "END";
            if (PhaseSymbols.isCrustMantleLeg(currLeg)) {
                proto = layerFactories.get(0).parse(proto, prevLeg, currLeg, nextLeg, nextNextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (PhaseSymbols.isOuterCoreLeg(currLeg)) {
                proto = layerFactories.get(1).parse(proto, prevLeg, currLeg, nextLeg, nextNextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (PhaseSymbols.isInnerCoreLeg(currLeg)) {
                proto = layerFactories.get(2).parse(proto, prevLeg, currLeg, nextLeg, nextNextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (!(PhaseSymbols.isBoundary(currLeg) || PhaseSymbols.isReflectSymbol(currLeg) || currLeg.equals("m"))) {
                return this.failWithMessage(proto, "Unknown leg: " + currLeg);
            }
            if (proto.isFail) break;
            this.prevEndAction = proto.endSegment().endAction;
        }
        if (proto.isSuccessful()) {
            if (proto.endSegment().isDownGoing && proto.endSegment().endBranch != this.downgoingRecBranch || !proto.endSegment().isDownGoing && proto.endSegment().endBranch != this.upgoingRecBranch) {
                return this.failWithMessage(proto, " Phase does not end at the receiver branch, last: " + proto.endSegment());
            }
            if (this.DEBUG) {
                Alert.debug("Last action is: " + proto.endSegment());
            }
        }
        double fractionOfPath = 1.0 / (double)proto.countFlatLegs();
        for (SeismicPhaseSegment seg : proto.segmentList) {
            if (!seg.isFlat) continue;
            seg.flatFractionOfPath = fractionOfPath;
        }
        if (proto.segmentList.isEmpty()) {
            throw new TauModelException("seg list is zero??? " + this.name);
        }
        return proto;
    }

    ProtoSeismicPhase failWithMessage(ProtoSeismicPhase proto, String reason) {
        if (this.DEBUG) {
            Alert.debug("FAIL: " + this.name + " " + reason);
        }
        proto.failNext(reason);
        return proto;
    }

    protected static SimpleSeismicPhase sumBranches(ProtoSeismicPhase proto) throws TauModelException {
        SeismicPhaseSegment endSeg = proto.endSegment();
        TauModel tMod = proto.gettMod();
        double minRayParam = endSeg.minRayParam;
        double maxRayParam = endSeg.maxRayParam;
        if (endSeg.endAction == PhaseInteraction.FAIL) {
            throw new RuntimeException("Cannot sum failed phase");
        }
        int minRayParamIndex = 0;
        String name = proto.getName();
        if (endSeg.maxRayParam < 0.0 || endSeg.minRayParam > endSeg.maxRayParam) {
            proto.failNext("Phase has no arrivals, possibly due to source depth");
            return new FailedSeismicPhase(proto);
        }
        if (endSeg.maxRayParam == endSeg.minRayParam && proto.countFlatLegs() == 0) {
            proto.failNext("Phase has singleton ray parameter, but no flat legs (head or diff).");
            return new FailedSeismicPhase(proto);
        }
        if (name.endsWith("kmps")) {
            double velocity;
            try {
                velocity = Double.parseDouble(name.substring(0, name.length() - 4));
            }
            catch (NumberFormatException e) {
                proto.failNext(" Illegal surface wave velocity " + name.substring(0, name.length() - 4));
                return new FailedSeismicPhase(proto);
            }
            double[] dist = new double[2];
            double[] time = new double[2];
            double[] rayParams = new double[2];
            dist[0] = 0.0;
            time[0] = 0.0;
            rayParams[0] = tMod.radiusOfEarth / velocity;
            dist[1] = SeismicPhaseFactory.getMaxKmpsLaps() * 2.0 * Math.PI;
            time[1] = SeismicPhaseFactory.getMaxKmpsLaps() * 2.0 * Math.PI * tMod.radiusOfEarth / velocity;
            rayParams[1] = rayParams[0];
            double minDistance = dist[0];
            double maxDistance = dist[1];
            minRayParam = rayParams[0];
            maxRayParam = rayParams[0];
            int maxRayParamIndex = 1;
            SimpleContigSeismicPhase sp = new SimpleContigSeismicPhase(proto, rayParams, time, dist, minRayParam, maxRayParam, minRayParamIndex, maxRayParamIndex, minDistance, maxDistance, TauPConfig.DEBUG);
            return sp;
        }
        List<ShadowOrProto> hszSplitProtoList = proto.splitForAllHighSlowness();
        ArrayList<SimpleContigSeismicPhase> contigPhaseList = new ArrayList<SimpleContigSeismicPhase>();
        ArrayList<ShadowZone> shadowZones = new ArrayList<ShadowZone>();
        SimpleContigSeismicPhase prevPhaseSeg = null;
        ShadowZone prevShadow = null;
        for (ShadowOrProto hszProto : hszSplitProtoList) {
            if (hszProto.isProto()) {
                SimpleContigSeismicPhase phaseSeg = SeismicPhaseFactory.internalSumContigPhase(hszProto.getProto());
                contigPhaseList.add(phaseSeg);
                if (prevShadow != null) {
                    prevShadow.setPrePostArrival(prevPhaseSeg.createArrivalAtIndex(prevPhaseSeg.getNumRays() - 1), phaseSeg.createArrivalAtIndex(0));
                }
                prevShadow = null;
                prevPhaseSeg = phaseSeg;
                continue;
            }
            prevShadow = hszProto.getShadow();
            shadowZones.add(prevShadow);
        }
        if (contigPhaseList.size() == 1) {
            return (SimpleSeismicPhase)contigPhaseList.get(0);
        }
        return new CompositeSeismicPhase(contigPhaseList, shadowZones);
    }

    protected static SimpleContigSeismicPhase internalSumContigPhase(ProtoSeismicPhase proto) throws TauModelException {
        double[] rayParams;
        int i;
        TauModel tMod = proto.tMod;
        SeismicPhaseSegment endSeg = proto.endSegment();
        double minRayParam = endSeg.minRayParam;
        double maxRayParam = endSeg.maxRayParam;
        if (endSeg.endAction == PhaseInteraction.FAIL) {
            throw new RuntimeException("Cannot sum failed phase");
        }
        int minRayParamIndex = 0;
        int maxRayParamIndex = tMod.rayParams.length;
        String name = proto.getName();
        for (i = 0; i < tMod.rayParams.length; ++i) {
            if (tMod.rayParams[i] >= minRayParam) {
                minRayParamIndex = i;
            }
            if (!(tMod.rayParams[i] >= maxRayParam)) continue;
            maxRayParamIndex = i;
        }
        if (maxRayParamIndex < 0) {
            throw new RuntimeException(proto.getName() + " Should not happen, did not find max ray param" + maxRayParam);
        }
        if (minRayParamIndex < 0) {
            throw new RuntimeException(proto.getName() + " Should not happen, did not find min ray param" + minRayParam);
        }
        if (maxRayParamIndex == 0 && minRayParamIndex == tMod.rayParams.length - 1) {
            rayParams = new double[tMod.rayParams.length];
            System.arraycopy(tMod.rayParams, 0, rayParams, 0, tMod.rayParams.length);
        } else if (maxRayParamIndex == minRayParamIndex) {
            rayParams = new double[]{minRayParam, minRayParam};
            if (proto.countFlatLegs() == 0) {
                throw new TauModelException("min and max rp index are same, only one ray but not flat? " + proto.getName() + " " + minRayParamIndex + " " + maxRayParamIndex + "  rp " + minRayParam + " " + maxRayParam + " " + proto.branchNumSeqStr());
            }
        } else {
            if (TauPConfig.DEBUG) {
                Alert.debug("SumBranches() maxRayParamIndex=" + maxRayParamIndex + " minRayParamIndex=" + minRayParamIndex + " tMod.rayParams.length=" + tMod.rayParams.length + " tMod.rayParams[0]=" + tMod.rayParams[0] + "\n tMod.rayParams[" + minRayParamIndex + "]=" + tMod.rayParams[minRayParamIndex] + "\n tMod.rayParams[" + maxRayParamIndex + "]=" + tMod.rayParams[maxRayParamIndex] + " maxRayParam=" + maxRayParam);
            }
            rayParams = new double[minRayParamIndex - maxRayParamIndex + 1];
            System.arraycopy(tMod.rayParams, maxRayParamIndex, rayParams, 0, minRayParamIndex - maxRayParamIndex + 1);
        }
        double[] dist = new double[rayParams.length];
        double[] time = new double[rayParams.length];
        for (i = 0; i < rayParams.length; ++i) {
            TimeDist td = SeismicPhaseFactory.calcForIndex(proto, i, maxRayParamIndex, rayParams);
            dist[i] = td.getDistRadian();
            time[i] = td.getTime();
        }
        int numHead = proto.countHeadLegs();
        int numDiff = proto.countDiffLegs();
        if (numDiff > 0 || numHead > 0) {
            double horizontalDistDeg = 1.0 * (double)numHead / (double)(numHead + numDiff) * SeismicPhaseFactory.getMaxRefraction() + 1.0 * (double)numDiff / (double)(numHead + numDiff) * SeismicPhaseFactory.getMaxDiffraction();
            dist[1] = dist[0] + horizontalDistDeg * Math.PI / 180.0;
            time[1] = time[0] + horizontalDistDeg * Math.PI / 180.0 * minRayParam;
        } else if (rayParams.length == 2 && maxRayParamIndex == minRayParamIndex) {
            if (!proto.sourceSegment().isDownGoing && tMod.getSourceDepth() == tMod.getRadiusOfEarth()) {
                dist[0] = 0.0;
                dist[1] = Math.PI * 2;
                time[1] = time[0];
            } else {
                dist[1] = dist[0];
                time[1] = time[0];
            }
        }
        double minDistance = Double.MAX_VALUE;
        double maxDistance = 0.0;
        for (int j = 0; j < dist.length; ++j) {
            if (dist[j] < minDistance) {
                minDistance = dist[j];
            }
            if (!(dist[j] > maxDistance)) continue;
            maxDistance = dist[j];
        }
        return new SimpleContigSeismicPhase(proto, rayParams, time, dist, minRayParam, maxRayParam, minRayParamIndex, maxRayParamIndex, minDistance, maxDistance, TauPConfig.DEBUG);
    }

    public static List<TauBranch> calcBranchSeqForRayparam(ProtoSeismicPhase proto, double rp) throws TauModelException {
        ArrayList<TauBranch> branchList = new ArrayList<TauBranch>();
        SeismicPhaseSegment prevSeg = null;
        for (SeismicPhaseSegment seg : proto.segmentList) {
            if (seg.isFlat) continue;
            branchList.addAll(SeismicPhaseFactory.calcBranchSeqForRayparam(proto, rp, seg, prevSeg));
            prevSeg = seg;
        }
        return branchList;
    }

    public static List<TauBranch> calcBranchSeqForRayparam(ProtoSeismicPhase proto, double rp, SeismicPhaseSegment seg, SeismicPhaseSegment prevSeg) throws TauModelException {
        ArrayList<TauBranch> branchList = new ArrayList<TauBranch>();
        int add = seg.isDownGoing ? 1 : -1;
        int sb = seg.startBranch;
        if (!seg.isDownGoing && seg.prevEndAction == PhaseInteraction.TURN) {
            sb = prevSeg.turnBranch(rp);
        }
        for (int b = sb; seg.isDownGoing && b <= seg.endBranch || !seg.isDownGoing && b >= seg.endBranch; b += add) {
            TauBranch tauBranch = proto.tMod.getTauBranch(b, seg.isPWave);
            if (rp <= tauBranch.getMaxRayParam()) {
                branchList.add(tauBranch);
                if (!seg.isDownGoing || seg.endAction != PhaseInteraction.TURN || !(rp >= tauBranch.getMinRayParam())) continue;
                break;
            }
            throw new TauModelException("Ray can't go into branch, should never happen: " + rp + " " + tauBranch);
        }
        return branchList;
    }

    public static TimeDist calcForIndex(ProtoSeismicPhase proto, int idx, int maxRayParamIndex, double[] rayParams) {
        List<TimeDist> pierce = SeismicPhaseFactory.calcPierceForIndex(proto, idx, maxRayParamIndex, rayParams);
        return pierce.get(pierce.size() - 1);
    }

    public static List<TimeDist> calcPierceForIndex(ProtoSeismicPhase proto, int idx, int maxRayParamIndex, double[] rayParams) {
        double rp = rayParams[idx];
        double dist = 0.0;
        double time = 0.0;
        int turnBranch = -1;
        ArrayList<TimeDist> pierce = new ArrayList<TimeDist>();
        block0: for (SeismicPhaseSegment seg : proto.segmentList) {
            if (seg.isFlat) continue;
            int add = seg.isDownGoing ? 1 : -1;
            int sb = seg.startBranch;
            if (!seg.isDownGoing && seg.prevEndAction == PhaseInteraction.TURN) {
                sb = turnBranch;
            }
            for (int b = sb; seg.isDownGoing && b <= seg.endBranch || !seg.isDownGoing && b >= seg.endBranch; b += add) {
                TauBranch tauBranch = proto.tMod.getTauBranch(b, seg.isPWave);
                if (rp <= tauBranch.getMaxRayParam()) {
                    double depth = seg.isDownGoing ? tauBranch.getBotDepth() : tauBranch.getTopDepth();
                    pierce.add(new TimeDist(rp, time += tauBranch.getTime(idx + maxRayParamIndex), dist += tauBranch.getDist(idx + maxRayParamIndex), depth));
                }
                if (seg.isDownGoing && seg.endAction == PhaseInteraction.TURN && rp >= tauBranch.getMinRayParam()) {
                    turnBranch = b;
                    continue block0;
                }
                turnBranch = -1;
            }
        }
        return pierce;
    }

    public int calcStartBranch(ProtoSeismicPhase proto, String currLeg) {
        int currBranch = !proto.isEmpty() ? proto.endSegment().endBranch + PhaseInteraction.endOffset(proto.endSegment().endAction) : (PhaseSymbols.isDowngoingSymbol(currLeg) ? this.tMod.getSourceBranch() : this.tMod.getSourceBranch() - 1);
        return currBranch;
    }

    public static String endActionString(PhaseInteraction endAction) {
        if (endAction == PhaseInteraction.START) {
            return "START";
        }
        if (endAction == PhaseInteraction.TURN) {
            return "TURN";
        }
        if (endAction == PhaseInteraction.DIFFRACTTURN) {
            return "DIFFRACT_TURN";
        }
        if (endAction == PhaseInteraction.REFLECT_UNDERSIDE) {
            return "REFLECT_UNDERSIDE";
        }
        if (endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
            return "REFLECT_UNDERSIDE_CRITICAL";
        }
        if (endAction == PhaseInteraction.SCATTER) {
            return "SCATTER";
        }
        if (endAction == PhaseInteraction.SCATTER_DOWN) {
            return "SCATTER_DOWN";
        }
        if (endAction == PhaseInteraction.BACKSCATTER) {
            return "BACKSCATTER";
        }
        if (endAction == PhaseInteraction.BACKSCATTER_DOWN) {
            return "BACKSCATTER_DOWN";
        }
        if (endAction == PhaseInteraction.END) {
            return "END";
        }
        if (endAction == PhaseInteraction.END_DOWN) {
            return "END_DOWN";
        }
        if (endAction == PhaseInteraction.REFLECT_TOPSIDE) {
            return "REFLECT_TOPSIDE";
        }
        if (endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
            return "REFLECT_TOPSIDE_CRITICAL";
        }
        if (endAction == PhaseInteraction.TRANSUP) {
            return "TRANSUP";
        }
        if (endAction == PhaseInteraction.TRANSDOWN) {
            return "TRANSDOWN";
        }
        if (endAction == PhaseInteraction.DIFFRACT) {
            return "DIFFRACT";
        }
        if (endAction == PhaseInteraction.TRANSUPDIFFRACT) {
            return "TRANS UP DIFFRACT";
        }
        if (endAction == PhaseInteraction.HEAD) {
            return "HEAD WAVE";
        }
        if (endAction == PhaseInteraction.FAIL) {
            return "FAIL";
        }
        throw new RuntimeException("UNKNOWN Action: " + endAction);
    }
}

