/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.BranchDescription;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.util.ArrayList;
import java.util.List;

public class SeismicPhaseSegment {
    TauModel tMod;
    int startBranch;
    int endBranch;
    boolean isPWave;
    PhaseInteraction endAction;
    PhaseInteraction prevEndAction = null;
    boolean isDownGoing;
    boolean isFlat = false;
    double flatFractionOfPath = 1.0;
    String legName;
    double minRayParam;
    double maxRayParam;

    public SeismicPhaseSegment(TauModel tMod, int startBranch, int endBranch, boolean isPWave, PhaseInteraction endAction, boolean isDownGoing, String legName, double minRayParam, double maxRayParam) {
        this.tMod = tMod;
        this.startBranch = startBranch;
        this.endBranch = endBranch;
        this.isPWave = isPWave;
        this.endAction = endAction;
        this.isDownGoing = isDownGoing;
        this.legName = legName;
        this.minRayParam = minRayParam;
        this.maxRayParam = maxRayParam;
    }

    public static SeismicPhaseSegment failSegment(TauModel tMod) {
        return new SeismicPhaseSegment(tMod, -1, -1, true, PhaseInteraction.FAIL, true, "", -1.0, -1.0);
    }

    public static SeismicPhaseSegment failSegment(TauModel tMod, int startBranch, int endBranch, boolean isPWave, boolean isDownGoing, String legName) {
        return new SeismicPhaseSegment(tMod, startBranch, endBranch, isPWave, PhaseInteraction.FAIL, isDownGoing, legName, -1.0, -1.0);
    }

    public int turnBranch(double rp) {
        if (this.endAction != PhaseInteraction.TURN || !this.isDownGoing) {
            return -1;
        }
        for (int b = this.startBranch; b <= this.endBranch; ++b) {
            TauBranch tauBranch = this.tMod.getTauBranch(b, this.isPWave);
            if (!(rp >= tauBranch.getMinRayParam())) continue;
            return b;
        }
        return this.endBranch;
    }

    public boolean endsAtTop() throws TauModelException {
        switch (this.endAction) {
            case END: 
            case HEAD: 
            case TRANSUP: 
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: {
                return true;
            }
            case TURN: 
            case DIFFRACTTURN: 
            case DIFFRACT: 
            case TRANSUPDIFFRACT: 
            case END_DOWN: 
            case TRANSDOWN: 
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: {
                return false;
            }
            case START: {
                return !this.isDownGoing;
            }
        }
        throw new TauModelException("endAction should never be FAIL or default in SeismicPhaseSegment");
    }

    public static String endActionToString(PhaseInteraction endAction) {
        String action;
        switch (endAction) {
            case START: {
                action = "start";
                break;
            }
            case TURN: {
                action = "turn";
                break;
            }
            case REFLECT_UNDERSIDE: {
                action = "reflect underside";
                break;
            }
            case END_DOWN: {
                action = "end downward";
                break;
            }
            case REFLECT_UNDERSIDE_CRITICAL: {
                action = "critical reflect underside";
                break;
            }
            case REFLECT_TOPSIDE: {
                action = "reflect topside";
                break;
            }
            case REFLECT_TOPSIDE_CRITICAL: {
                action = "critical reflect topside";
                break;
            }
            case TRANSUP: {
                action = "transmit up";
                break;
            }
            case TRANSDOWN: {
                action = "transmit down";
                break;
            }
            case DIFFRACT: {
                action = "diffract";
                break;
            }
            case DIFFRACTTURN: {
                action = "turn after diffract";
                break;
            }
            case TRANSUPDIFFRACT: {
                action = "transmit up diffract";
                break;
            }
            case HEAD: {
                action = "head wave";
                break;
            }
            case SCATTER: {
                action = "scatter";
                break;
            }
            case SCATTER_DOWN: {
                action = "down scatter";
                break;
            }
            case BACKSCATTER: {
                action = "backscatter";
                break;
            }
            case BACKSCATTER_DOWN: {
                action = "down backscatter";
                break;
            }
            case END: {
                action = "end";
                break;
            }
            case FAIL: {
                action = "fail";
                break;
            }
            case KMPS: {
                action = "surfacewave";
                break;
            }
            default: {
                action = "unknown";
            }
        }
        return action;
    }

    public String describeBranchRange() {
        return SeismicPhaseSegment.describeBranchRange(this.tMod, this.startBranch, this.endBranch);
    }

    public static String describeBranchRange(TauModel tMod, int startBranch, int endBranch) {
        String out = startBranch == -1 || endBranch == -1 ? "?" : (startBranch < tMod.getMohoBranch() && endBranch < tMod.getMohoBranch() ? "crust" : (startBranch < tMod.getCmbBranch() && endBranch < tMod.getCmbBranch() ? (startBranch < tMod.getMohoBranch() && endBranch >= tMod.getMohoBranch() ? "crust/mantle" : (startBranch >= tMod.getMohoBranch() && endBranch < tMod.getMohoBranch() ? "crust/mantle" : "mantle")) : (startBranch < tMod.getIocbBranch() && endBranch < tMod.getIocbBranch() ? "outer core" : "inner core")));
        return out;
    }

    public String toString() {
        String isPString;
        Object desc = "";
        String upDown = this.isFlat ? "flat" : (this.isDownGoing ? "down" : "up  ");
        String action = SeismicPhaseSegment.endActionToString(this.endAction);
        String string = isPString = this.isPWave ? "P" : "S";
        if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
            isPString = "P";
        } else if (this.prevEndAction == PhaseInteraction.KMPS) {
            isPString = "surface wave";
        }
        String branchRange = this.startBranch == this.endBranch ? " layer " + this.startBranch : " layer " + this.startBranch + " to " + this.endBranch;
        String depthRange = this.getDepthRangeString();
        desc = !this.legName.contentEquals("END") ? (String)desc + this.legName + " going " + upDown + " as a " + isPString + " in the " + this.describeBranchRange() + "," + branchRange + ", depths " + depthRange + ", then " + action : (String)desc + "END";
        return desc;
    }

    public boolean getIsPWave() {
        return this.isPWave;
    }

    public boolean getIsFlat() {
        return this.isFlat;
    }

    public String getLegName() {
        return this.legName;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDepthRangeString() {
        if (this.startBranch == -1 && this.endBranch == -1) {
            return "";
        }
        if (this.isFlat) {
            if (this.prevEndAction == null) {
                return " PrevAction is NULL ";
            }
            if (this.prevEndAction == PhaseInteraction.DIFFRACT) return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + " (DIFF)";
            if (this.prevEndAction == PhaseInteraction.DIFFRACTTURN) return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + " (DIFF)";
            if (this.prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + " (DIFF)";
            }
            if (this.prevEndAction == PhaseInteraction.HEAD) {
                return " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + " (HEAD)";
            }
            if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction) + "prev: " + this.prevEndAction + " end:" + this.endAction);
            return " at surface (KMPS)";
        }
        if (!this.isDownGoing) return this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth();
        return this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDepthRangeJSON() {
        if (this.startBranch == -1) return "[]";
        if (this.endBranch == -1) {
            return "[]";
        }
        if (this.isFlat) {
            if (this.prevEndAction == null) {
                return "\" PrevAction is NULL \"";
            }
            if (this.prevEndAction == PhaseInteraction.DIFFRACT) return "[" + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + "]";
            if (this.prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                return "[" + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + "]";
            }
            if (this.prevEndAction == PhaseInteraction.HEAD) {
                return "[" + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + "]";
            }
            if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction));
            return "[0]";
        }
        if (!this.isDownGoing) return "[" + this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + ", " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + "]";
        return "[" + this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + ", " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + "]";
    }

    public double getTopDepth() {
        if (this.isFlat) {
            return this.getDepthRange()[0];
        }
        if (this.isDownGoing) {
            return this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth();
        }
        return this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth();
    }

    public double getBotDepth() {
        if (this.isFlat) {
            return this.getDepthRange()[0];
        }
        if (this.isDownGoing) {
            return this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth();
        }
        return this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] getDepthRange() {
        if (this.startBranch == -1) return new double[0];
        if (this.endBranch == -1) {
            return new double[0];
        }
        if (this.isFlat) {
            if (this.prevEndAction == PhaseInteraction.DIFFRACT || this.prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                return new double[]{this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth()};
            }
            if (this.prevEndAction == PhaseInteraction.HEAD) {
                return new double[]{this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth()};
            }
            if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction));
            return new double[]{0.0};
        }
        if (!this.isDownGoing) return new double[]{this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth(), this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth()};
        return new double[]{this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth(), this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth()};
    }

    public String getUpDownJSON() {
        String upDown = this.isFlat ? (this.prevEndAction != null ? SeismicPhaseSegment.endActionToString(this.prevEndAction) : "flat") : (this.isDownGoing ? "down" : "up");
        return upDown;
    }

    public BranchDescription describe() {
        BranchDescription b = new BranchDescription();
        b.name = this.getLegName();
        b.branch_desc = this.describeBranchRange();
        b.type = this.getIsPWave() ? "pwave" : "swave";
        b.updown = this.getUpDownJSON();
        b.then = SeismicPhaseSegment.endActionToString(this.endAction);
        b.branches = this.startBranch != this.endBranch ? new int[]{this.startBranch, this.endBranch} : new int[]{this.startBranch};
        b.depths = new float[this.getDepthRange().length];
        for (int i = 0; i < this.getDepthRange().length; ++i) {
            b.depths[i] = (float)this.getDepthRange()[i];
        }
        return b;
    }

    public String toJSONString() {
        Object desc = "";
        if (!this.legName.contentEquals("END")) {
            String isPString;
            String upDown = this.getUpDownJSON();
            String action = SeismicPhaseSegment.endActionToString(this.endAction);
            String string = isPString = this.isPWave ? "P" : "S";
            if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
                isPString = "P";
            } else if (this.prevEndAction == PhaseInteraction.KMPS) {
                isPString = "surface wave";
            }
            String branchRangeJSON = "[" + (this.startBranch == this.endBranch ? " " + this.startBranch : " " + this.startBranch + ", " + this.endBranch) + "]";
            String depthRange = this.getDepthRangeJSON();
            desc = (String)desc + "{  \"name\": \"" + this.legName + "\", \"updown\": \"" + upDown + "\", \"type\": \"" + isPString + "\", \"branch_desc\": \"" + this.describeBranchRange() + "\", \"branches\": " + branchRangeJSON + ", \"depths\": " + depthRange + ", \"then\": \"" + action + "\"}";
        } else {
            desc = (String)desc + "END";
        }
        return desc;
    }

    public List<TimeDist> calcTimeDist(Arrival currArrival, TimeDist prevEnd, boolean doPath, SeismicPhaseSegment prevSeg) throws SlownessModelException {
        ArrayList<TimeDist> pierceList = new ArrayList<TimeDist>();
        double rp = currArrival.getRayParam();
        if (!this.isFlat) {
            int bStep = this.isDownGoing ? 1 : -1;
            int sb = this.startBranch;
            if (this.prevEndAction == PhaseInteraction.TURN) {
                sb = prevSeg.turnBranch(rp);
            }
            for (int branchNum = sb; this.isDownGoing && branchNum <= this.endBranch || !this.isDownGoing && branchNum >= this.endBranch; branchNum += bStep) {
                List<TimeDist> tdList;
                TauBranch tauBranch = this.tMod.getTauBranch(branchNum, this.isPWave);
                if (this.isDownGoing) {
                    if (rp <= tauBranch.getMaxRayParam()) {
                        if (rp >= tauBranch.getTopRayParam()) {
                            TimeDist bounce = prevEnd.add(new TimeDist(rp, 0.0, 0.0, tauBranch.getTopDepth()));
                            pierceList.add(bounce);
                        } else {
                            if (doPath) {
                                tdList = tauBranch.path(currArrival.getRayParam(), this.isDownGoing, this.tMod.getSlownessModel(), prevEnd);
                                pierceList.addAll(tdList);
                                prevEnd = (TimeDist)pierceList.get(pierceList.size() - 1);
                            } else {
                                TimeDist branchTD = tauBranch.calcTimeDist(rp, true, this.isDownGoing);
                                prevEnd = prevEnd.add(branchTD);
                                pierceList.add(prevEnd);
                            }
                            if (!(rp >= tauBranch.getBotRayParam())) continue;
                        }
                    }
                } else {
                    if (!(rp <= tauBranch.getMaxRayParam()) || !(rp <= tauBranch.getTopRayParam())) continue;
                    if (doPath) {
                        tdList = tauBranch.path(currArrival.getRayParam(), this.isDownGoing, this.tMod.getSlownessModel(), prevEnd);
                        pierceList.addAll(tdList);
                        prevEnd = (TimeDist)pierceList.get(pierceList.size() - 1);
                    } else {
                        TimeDist up = tauBranch.calcTimeDist(rp, true, this.isDownGoing);
                        prevEnd = prevEnd.add(tauBranch.calcTimeDist(rp, true, this.isDownGoing));
                        pierceList.add(prevEnd);
                    }
                    if (!(currArrival.getRayParam() > tauBranch.getTopRayParam())) {
                        continue;
                    }
                }
                break;
            }
        } else {
            double depth;
            double refractDist = (currArrival.getDist() - currArrival.getPhase().getMinDistance()) * this.flatFractionOfPath;
            double refractTime = refractDist * currArrival.getRayParam();
            TauBranch branch = this.tMod.getTauBranch(this.startBranch, this.isPWave);
            if (this.prevEndAction.equals((Object)PhaseInteraction.DIFFRACT) || this.prevEndAction.equals((Object)PhaseInteraction.TRANSUPDIFFRACT)) {
                depth = branch.getBotDepth();
            } else if (this.prevEndAction.equals((Object)PhaseInteraction.HEAD) || this.prevEndAction.equals((Object)PhaseInteraction.KMPS)) {
                depth = branch.getTopDepth();
            } else {
                throw new RuntimeException("Segment prevEndAction Should be one of KMPS, DIFFRACT or HEAD: " + this.prevEndAction);
            }
            TimeDist td = prevEnd.add(new TimeDist(currArrival.getRayParam(), 0.0, 0.0, depth));
            pierceList.add(td);
            td = td.add(new TimeDist(currArrival.getRayParam(), refractTime, refractDist, depth));
            pierceList.add(td);
        }
        return pierceList;
    }

    public ArrivalPathSegment calcPathTimeDist(Arrival currArrival, TimeDist prevEnd, int segmentIndex, int totalNumSegments, SeismicPhaseSegment prevSeg) throws SlownessModelException {
        List<TimeDist> outPath = this.calcTimeDist(currArrival, prevEnd, true, prevSeg);
        outPath = ArrivalPathSegment.trimDuplicates(outPath);
        ArrivalPathSegment pathSeg = new ArrivalPathSegment(outPath, this.isPWave, this.legName, prevEnd, currArrival, this, segmentIndex, totalNumSegments);
        return pathSeg;
    }

    public double calcEnergyFluxFactorReflTran(Arrival arrival, boolean nextLegIsPWave, boolean allSH) throws VelocityModelException {
        double reflTranValue = 1.0;
        if (this.isPWave && allSH) {
            return 0.0;
        }
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        if (!this.isFlat) {
            int bStep = this.isDownGoing ? 1 : -1;
            for (int branchNum = this.startBranch; this.isDownGoing && branchNum < this.endBranch || !this.isDownGoing && branchNum > this.endBranch; branchNum += bStep) {
                double depth;
                if (TauPConfig.DEBUG) {
                    Alert.debug(" branchNum=" + branchNum + " isPWave=" + this.isPWave + " downgoing=" + this.isDownGoing);
                }
                TauBranch tauBranch = this.tMod.getTauBranch(branchNum, this.isPWave);
                if (this.isDownGoing) {
                    depth = tauBranch.getBotDepth();
                    if (arrival.getRayParam() > tauBranch.getMinTurnRayParam()) {
                        break;
                    }
                } else {
                    depth = tauBranch.getTopDepth();
                    if (arrival.getRayParam() >= tauBranch.getMaxRayParam()) continue;
                }
                if (arrival.getSourceDepth() == depth && !this.getTauModel().getVelocityModel().isDisconDepth(depth) || arrival.getReceiverDepth() == depth && !this.getTauModel().getVelocityModel().isDisconDepth(depth) || !this.getTauModel().getVelocityModel().isDisconDepth(depth)) continue;
                ReflTrans reflTranCoef = vMod.calcReflTransCoef(depth, this.isDownGoing);
                double flatRayParam = arrival.getRayParam() / (this.getTauModel().getRadiusOfEarth() - depth);
                if (this.isPWave) {
                    if (this.endAction == PhaseInteraction.TURN && arrival.getRayParam() >= tauBranch.getMinRayParam() && arrival.getRayParam() <= tauBranch.getMinTurnRayParam()) {
                        reflTranValue *= reflTranCoef.getEnergyFluxFactorRpp(flatRayParam);
                        continue;
                    }
                    reflTranValue *= reflTranCoef.getEnergyFluxFactorTpp(flatRayParam);
                    continue;
                }
                if (this.endAction == PhaseInteraction.TURN && arrival.getRayParam() >= tauBranch.getMinRayParam() && arrival.getRayParam() <= tauBranch.getMinTurnRayParam()) {
                    if (allSH) {
                        reflTranValue *= reflTranCoef.getEnergyFluxFactorRshsh(flatRayParam);
                        continue;
                    }
                    reflTranValue *= reflTranCoef.getEnergyFluxFactorRss(flatRayParam);
                    continue;
                }
                if (allSH) {
                    reflTranValue *= reflTranCoef.getEnergyFluxFactorTshsh(flatRayParam);
                    continue;
                }
                reflTranValue *= reflTranCoef.getEnergyFluxFactorTss(flatRayParam);
            }
            TauBranch tauBranch = this.tMod.getTauBranch(this.endBranch, this.isPWave);
            double depth = this.isDownGoing ? tauBranch.getBotDepth() : tauBranch.getTopDepth();
            double flatRayParam = arrival.getRayParam() / (this.getTauModel().getRadiusOfEarth() - depth);
            if ((arrival.getSourceDepth() != depth || this.getTauModel().getVelocityModel().isDisconDepth(depth)) && this.getTauModel().getVelocityModel().isDisconDepth(depth) && (arrival.getReceiverDepth() != depth || this.getTauModel().getVelocityModel().isDisconDepth(depth))) {
                ReflTrans reflTranCoef = vMod.calcReflTransCoef(depth, this.isDownGoing);
                if (this.endAction == PhaseInteraction.TURN) {
                    if (arrival.getRayParam() < tauBranch.getMinTurnRayParam()) {
                        reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorRps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorRss(flatRayParam))));
                    }
                } else if (this.endAction == PhaseInteraction.TRANSDOWN || this.endAction == PhaseInteraction.TRANSUP) {
                    reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorTpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorTps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorTsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorTshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorTss(flatRayParam))));
                } else if (this.endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL || this.endAction == PhaseInteraction.REFLECT_TOPSIDE || this.endAction == PhaseInteraction.REFLECT_UNDERSIDE) {
                    reflTranValue = this.isPWave ? (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRpp(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorRps(flatRayParam))) : (nextLegIsPWave ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRsp(flatRayParam)) : (allSH ? (reflTranValue *= reflTranCoef.getEnergyFluxFactorRshsh(flatRayParam)) : (reflTranValue *= reflTranCoef.getEnergyFluxFactorRss(flatRayParam))));
                }
            }
        }
        return reflTranValue;
    }

    public SeismicPhaseSegment clone() {
        SeismicPhaseSegment seg = new SeismicPhaseSegment(this.tMod, this.startBranch, this.endBranch, this.isPWave, this.endAction, this.isDownGoing, this.legName, this.minRayParam, this.maxRayParam);
        seg.prevEndAction = this.prevEndAction;
        seg.isFlat = this.isFlat;
        seg.flatFractionOfPath = this.flatFractionOfPath;
        return seg;
    }

    public static String segmentListDescribe(List<List<SeismicPhaseSegment>> segmentListList) {
        StringBuilder out = new StringBuilder();
        for (List<SeismicPhaseSegment> segList : segmentListList) {
            out.append(SeismicPhaseSegment.segmentDescribe(segList));
        }
        return out.toString();
    }

    public static String segmentDescribe(List<SeismicPhaseSegment> segmentList) {
        Object desc = "";
        String indent = "  ";
        for (SeismicPhaseSegment segment : segmentList) {
            if (segment.endAction != PhaseInteraction.FAIL || segment.endBranch != -1) {
                desc = (String)desc + indent + segment + "\n";
                continue;
            }
            desc = (String)desc + indent + "then " + segment.endAction + "\n";
        }
        return desc;
    }
}

