/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.ModelDiscontinuites;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelListArgs;
import edu.sc.seis.TauP.gson.AboveBelowVelocityDiscon;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="discon", description={"List velocity discontinuities for a model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_VelocityDison
extends TauP_Tool {
    @CommandLine.ArgGroup(heading="Velocity Model %n")
    VelocityModelListArgs velModelArgs = new VelocityModelListArgs();
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;
    @CommandLine.Option(names={"--slowness"}, description={"output the slowness for each discontinuity also"})
    protected boolean alsoSlowness = false;

    public TauP_VelocityDison() {
        super(new TextOutputTypeArgs("text", "-"));
    }

    public TextOutputTypeArgs getOutputTypeArgs() {
        return this.outputTypeArgs;
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void start() throws IOException, TauPException {
        List<VelocityModel> vModList = this.getVelModelArgs().getVelocityModels();
        if (this.outputTypeArgs.isJSON()) {
            ArrayList<ModelDiscontinuites> outList = new ArrayList<ModelDiscontinuites>();
            for (VelocityModel vMod : vModList) {
                outList.add(new ModelDiscontinuites(vMod));
            }
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            Gson gson = GsonUtil.createGsonBuilder().create();
            JsonObject out = new JsonObject();
            out.add("models", gson.toJsonTree(outList));
            writer.println(gson.toJson((JsonElement)out));
            writer.close();
        } else if (this.outputTypeArgs.isHTML()) {
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            List<String> headers = List.of("Depth", "Radius", "Name", "Vp", "Vs", "Density");
            if (this.alsoSlowness) {
                headers = new ArrayList<String>(headers);
                headers.add("P Slowness (s/deg)");
                headers.add("S Slowness (s/deg)");
            }
            HTMLUtil.createHtmlStart(writer, "TauP Discon", HTMLUtil.createBaseTableCSS() + "\n" + HTMLUtil.createThridRowCSS(), false);
            for (VelocityModel vMod : vModList) {
                ArrayList<List<String>> values = new ArrayList<List<String>>();
                for (double d : vMod.getDisconDepths()) {
                    String disconName;
                    AboveBelowVelocityDiscon discon = new AboveBelowVelocityDiscon(d, vMod);
                    String string = disconName = discon.hasPreferredName() ? "  " + discon.getPreferredName() : "";
                    if (d != 0.0) {
                        ArrayList<Object> aboveValues = new ArrayList<Object>();
                        aboveValues.addAll(List.of("", "", "", "" + discon.getAbove().getBotPVelocity(), "" + discon.getAbove().getBotSVelocity(), "" + discon.getAbove().getBotDensity()));
                        if (this.alsoSlowness) {
                            aboveValues.add(Outputs.formatRayParam(discon.getAboveSlownessP()));
                            aboveValues.add(Outputs.formatRayParam(discon.getAboveSlownessS()));
                        }
                        values.add(aboveValues);
                    }
                    ArrayList<String> depthValues = new ArrayList<String>();
                    depthValues.addAll(List.of(Outputs.formatDepth(d), Outputs.formatDepth(vMod.getRadiusOfEarth() - d), disconName, "", "", ""));
                    if (this.alsoSlowness) {
                        depthValues.addAll(List.of("", ""));
                    }
                    values.add(depthValues);
                    if (d == vMod.getRadiusOfEarth()) continue;
                    ArrayList<Object> belowValues = new ArrayList<Object>();
                    belowValues.addAll(List.of("", "", "", "" + discon.getBelow().getBotPVelocity(), "" + discon.getBelow().getBotSVelocity(), "" + discon.getBelow().getBotDensity()));
                    if (this.alsoSlowness) {
                        belowValues.add(Outputs.formatRayParam(discon.getBelowSlownessP()));
                        belowValues.add(Outputs.formatRayParam(discon.getBelowSlownessS()));
                    }
                    values.add(belowValues);
                }
                writer.println("<details open=\"true\">");
                writer.println("  <summary>" + vMod.getModelName() + "</summary>");
                writer.println(HTMLUtil.createBasicTable(headers, values));
                writer.println("</details>");
            }
            writer.println(HTMLUtil.createHtmlEnding());
            writer.close();
        } else {
            this.outputTypeArgs.setOutputFormat("text");
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            for (VelocityModel vMod : vModList) {
                writer.println("# " + vMod.getModelName());
                writer.println("#        Depth    (Radius)");
                writer.print("#        Vp      Vs      Density");
                if (this.alsoSlowness) {
                    writer.print("  P Slow (s/deg)  S Slow (s/deg)");
                }
                writer.println();
                for (double d : vMod.getDisconDepths()) {
                    SlownessLayer s_SlowLayer;
                    SlownessLayer p_SlowLayer;
                    String disconName;
                    AboveBelowVelocityDiscon discon = new AboveBelowVelocityDiscon(d, vMod);
                    String string = disconName = discon.hasPreferredName() ? "  " + discon.getPreferredName() : "";
                    if (d != 0.0) {
                        writer.print("      " + Outputs.formatRayParam(discon.getAbove().getBotPVelocity()) + " " + Outputs.formatRayParam(discon.getAbove().getBotSVelocity()) + " " + Outputs.formatRayParam(discon.getAbove().getBotDensity()));
                        if (this.alsoSlowness) {
                            p_SlowLayer = new SlownessLayer(discon.getAbove(), vMod.getSpherical(), vMod.getRadiusOfEarth(), true);
                            s_SlowLayer = new SlownessLayer(discon.getAbove(), vMod.getSpherical(), vMod.getRadiusOfEarth(), false);
                            writer.print("      " + Outputs.formatRayParam(p_SlowLayer.getBotP() / 57.29577951308232));
                            writer.print("      " + Outputs.formatRayParam(s_SlowLayer.getBotP() / 57.29577951308232));
                        }
                        writer.println();
                    }
                    writer.println("---" + Outputs.formatDepth(d) + " " + Outputs.formatDepth(vMod.getRadiusOfEarth() - d) + " " + disconName);
                    if (d != vMod.getRadiusOfEarth()) {
                        writer.print("      " + Outputs.formatRayParam(discon.getBelow().getTopPVelocity()) + " " + Outputs.formatRayParam(discon.getBelow().getTopSVelocity()) + " " + Outputs.formatRayParam(discon.getBelow().getTopDensity()));
                        if (this.alsoSlowness) {
                            p_SlowLayer = new SlownessLayer(discon.getBelow(), vMod.getSpherical(), vMod.getRadiusOfEarth(), true);
                            s_SlowLayer = new SlownessLayer(discon.getBelow(), vMod.getSpherical(), vMod.getRadiusOfEarth(), false);
                            writer.print("      " + Outputs.formatRayParam(p_SlowLayer.getTopP() / 57.29577951308232));
                            writer.print("      " + Outputs.formatRayParam(s_SlowLayer.getTopP() / 57.29577951308232));
                        }
                        writer.println();
                    }
                    writer.println();
                }
            }
            writer.close();
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.velModelArgs.size() == 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "must give at least one model");
        }
    }

    public VelocityModelListArgs getVelModelArgs() {
        return this.velModelArgs;
    }
}

