/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseIsochron;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgEarth;
import edu.sc.seis.TauP.SvgEarthScaling;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.WavefrontPathSegment;
import edu.sc.seis.TauP.WavefrontResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.ColorType;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.DistDepthRange;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="wavefront", description={"Plot wavefronts of seismic phases at steps in time."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Wavefront
extends TauP_AbstractPhaseTool {
    float timeStep = 100.0f;
    boolean separateFilesByTime = false;
    boolean negDistance = false;
    @CommandLine.Mixin
    ColoringArgs coloring = new ColoringArgs();
    @CommandLine.Option(names={"--legend"}, description={"create a legend"})
    boolean isLegend = false;
    @CommandLine.Option(names={"--onlynameddiscon"}, description={"only draw circles on the plot for named discontinuities like moho, cmb, iocb but not 410"})
    boolean onlyNamedDiscon = false;
    @CommandLine.Mixin
    DistDepthRange distDepthRangeArgs = new DistDepthRange();
    @CommandLine.Mixin
    GraphicOutputTypeArgs outputTypeArgs = (GraphicOutputTypeArgs)this.abstractOutputTypeArgs;

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    public TauP_Wavefront() {
        super(new GraphicOutputTypeArgs("svg", "taup_wavefront"));
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    public void printIsochron(PrintWriter out, Map<Double, List<PhaseIsochron>> timeSegmentMap) throws TauPException {
        if (this.getOutputFormat().equals("json")) {
            WavefrontResult result = new WavefrontResult(this.getTauModelName(), this.getSourceDepths(), this.getReceiverDepths(), this.phaseNames, this.getScatterer(), timeSegmentMap);
            out.println(GsonUtil.toJson(result));
        } else if (this.getOutputFormat().equals("svg")) {
            this.printIsochronSvg(out, timeSegmentMap);
        } else if (this.getOutputFormat().equals("html")) {
            this.printIsochronHtml(out, timeSegmentMap);
        } else {
            if (this.getGraphicOutputTypeArgs().isGMT()) {
                SvgEarth.printGmtScriptBeginning(out, this.outputTypeArgs.getOutFileBase(), this.modelArgs.getTauModel(), this.outputTypeArgs.mapwidth.floatValue(), this.outputTypeArgs.mapWidthUnit, this.onlyNamedDiscon, TauP_Wavefront.toolNameFromClass(this.getClass()), this.getCmdLineArgs());
                if (this.coloring.getColoring() == ColorType.none) {
                    out.write("gmt plot -Wblack -A <<END\n");
                }
            }
            ArrayList<Double> sortedKeys = new ArrayList<Double>(timeSegmentMap.keySet());
            Collections.sort(sortedKeys);
            boolean withTime = false;
            int idx = -1;
            for (Double timeVal : sortedKeys) {
                String lineColor;
                ++idx;
                if (this.coloring.getColoring() == ColorType.auto) {
                    lineColor = "-W," + ColoringArgs.gmtColor(this.coloring.colorForIndex(idx));
                    out.write("gmt plot " + lineColor + " -A  <<END\n");
                }
                for (PhaseIsochron phaseIsochron : timeSegmentMap.get(timeVal)) {
                    for (WavefrontPathSegment segment : phaseIsochron.getWavefront()) {
                        if (this.coloring.getColoring() == ColorType.wavetype) {
                            lineColor = "-W" + (segment.isPWave() ? "blue" : "red") + " ";
                            out.write("gmt plot " + lineColor + " -A  <<END\n");
                        } else if (this.coloring.getColoring() == ColorType.phase) {
                            int phaseIdx = this.getSeismicPhases().indexOf(segment.getPhase());
                            lineColor = "-W," + ColoringArgs.gmtColor(this.coloring.colorForIndex(phaseIdx));
                            out.write("gmt plot " + lineColor + " -A  <<END\n");
                        }
                        segment.writeGMTText(out, this.distDepthRangeArgs, Outputs.distanceFormat, Outputs.depthFormat, withTime, false);
                        if (this.coloring.getColoring() != ColorType.wavetype && this.coloring.getColoring() != ColorType.phase) continue;
                        out.println("END");
                    }
                }
                if (this.coloring.getColoring() != ColorType.auto) continue;
                out.write("END\n");
            }
            if (this.getGraphicOutputTypeArgs().isGMT()) {
                if (this.coloring.getColoring() == ColorType.none) {
                    out.write("END\n");
                }
                out.println("# end postscript");
                out.println("gmt end ");
            }
        }
        out.flush();
    }

    public void printIsochronHtml(PrintWriter writer, Map<Double, List<PhaseIsochron>> timeSegmentMap) throws TauPException {
        HTMLUtil.createHtmlStart(writer, "TauP Wavefront", "", false);
        writer.println("  <div>");
        writer.println("    <button id=\"animate\" type=\"button\" >Animate</button>\n");
        writer.println("    <label for=\"wavefronttime\">");
        writer.println("       <span>Time (s): </span>");
        writer.println("    </label>");
        writer.println("    <input type=\"number\" id=\"wavefronttime\" name=\"wavefronttime\" value=\"0\" min=\"0\" />");
        writer.println("    <span>Timestep: " + this.timeStep + " s</span>");
        writer.println("  </div>");
        this.printIsochronSvg(writer, timeSegmentMap);
        writer.println("  <script type=\"module\">");
        String jsFilename = "wavefront_animation.js";
        try {
            HTMLUtil.loadResource(jsFilename).transferTo(writer);
        }
        catch (IOException e) {
            throw new TauPException("Unable to load " + jsFilename, e);
        }
        writer.println("setupAnimation(" + this.timeStep + ");");
        writer.println("  </script>");
        writer.println(HTMLUtil.createHtmlEnding());
    }

    public void printIsochronSvg(PrintWriter out, Map<Double, List<PhaseIsochron>> timeSegmentMap) throws TauPException {
        ArrayList<Double> sortedKeys = new ArrayList<Double>(timeSegmentMap.keySet());
        Collections.sort(sortedKeys);
        List<PhaseName> phaseNameList = this.parsePhaseNameList();
        Object cssExtra = "";
        cssExtra = (String)cssExtra + SvgUtil.createSurfaceWaveCSS(phaseNameList) + "\n";
        double maxTime = 0.0;
        switch (this.coloring.getColoring()) {
            case phase: {
                cssExtra = (String)cssExtra + SvgUtil.createPhaseColorCSS(phaseNameList, this.coloring);
                break;
            }
            case wavetype: {
                cssExtra = (String)cssExtra + SvgUtil.createWaveTypeColorCSS(this.coloring);
                break;
            }
            case none: {
                cssExtra = (String)cssExtra + SvgUtil.createNoneColorCSS(this.coloring);
            }
            default: {
                for (SeismicPhase phase : this.getSeismicPhases()) {
                    if (!phase.hasArrivals() || !(phase.getMaxTime() > maxTime)) continue;
                    maxTime = phase.getMaxTime();
                }
                StringBuffer cssTimeColors = SvgUtil.createTimeStepColorCSS(this.timeStep, (float)maxTime, this.coloring);
                cssExtra = (String)cssExtra + cssTimeColors;
            }
        }
        float pixelWidth = this.getGraphicOutputTypeArgs().getPixelWidth();
        SvgEarthScaling scaleTrans = SvgEarth.calcEarthScaleTransForPhaseList(this.getSeismicPhases(), this.distDepthRangeArgs, this.isNegDistance());
        double minPolylineSize = 2.0;
        if (scaleTrans != null) {
            minPolylineSize = (double)SvgEarth.calcFontSizeForEarthScale(this.modelArgs.getTauModel(), scaleTrans) / 20.0;
        }
        SvgEarth.printScriptBeginningSvg(out, this.modelArgs.getTauModel(), pixelWidth, scaleTrans, TauP_Wavefront.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.coloring.getColorList(), (String)cssExtra);
        SvgEarth.printModelAsSVG(out, this.modelArgs.getTauModel(), pixelWidth, scaleTrans, this.onlyNamedDiscon);
        if (this.coloring.getColoring() == ColorType.auto) {
            SvgUtil.startAutocolorG(out);
        }
        for (Double timeVal : sortedKeys) {
            out.println("    <g>");
            out.println("      <desc>Time" + Outputs.formatTimeNoPad(timeVal) + "</desc>");
            for (PhaseIsochron phaseIsochron : timeSegmentMap.get(timeVal)) {
                out.println("      <g>");
                out.println("        <desc>Phase:" + phaseIsochron.getPhase().getName() + " at " + Outputs.formatTimeNoPad(phaseIsochron.getTime()) + "</desc>");
                for (WavefrontPathSegment segment : phaseIsochron.getWavefront()) {
                    segment.writeSVGCartesian(out, minPolylineSize);
                    if (!this.isNegDistance()) continue;
                    segment.asNegativeDistance().writeSVGCartesian(out, minPolylineSize);
                }
                out.println("      </g>");
            }
            out.println("</g>");
        }
        if (this.coloring.getColoring() == ColorType.auto) {
            SvgUtil.endAutocolorG(out);
        }
        SvgEarth.printSvgEndZoom(out);
        if (this.isLegend) {
            float xtrans = (int)((double)pixelWidth * 0.01);
            float ytrans = (int)((double)pixelWidth * 0.05);
            if (this.coloring.getColoring() == ColorType.phase) {
                SvgUtil.createPhaseLegend(out, this.getSeismicPhases(), "", xtrans, ytrans);
            } else if (this.coloring.getColoring() == ColorType.wavetype) {
                SvgUtil.createWavetypeLegend(out, false, xtrans, ytrans);
            } else {
                SvgUtil.createTimeStepLegend(out, this.timeStep, maxTime, "autocolor", xtrans, ytrans);
            }
        }
        SvgEarth.printSvgEnd(out);
    }

    public Map<Double, List<PhaseIsochron>> calcIsochron() throws TauPException {
        HashMap<Double, List<PhaseIsochron>> phaseIsochronMap = new HashMap<Double, List<PhaseIsochron>>();
        double maxTime = 0.0;
        for (SeismicPhase phase : this.getSeismicPhases()) {
            if (!phase.hasArrivals()) continue;
            maxTime = Math.max(maxTime, phase.getMaxTime());
            Map<Double, List<WavefrontPathSegment>> wavefrontPathSegments = this.calcIsochronSegmentsForPhase(phase, this.timeStep);
            for (Double timeVal : wavefrontPathSegments.keySet()) {
                if (!phaseIsochronMap.containsKey(timeVal)) {
                    phaseIsochronMap.put(timeVal, new ArrayList());
                }
                ((List)phaseIsochronMap.get(timeVal)).add(new PhaseIsochron(timeVal, phase, wavefrontPathSegments.get(timeVal)));
            }
        }
        return phaseIsochronMap;
    }

    public Map<Double, List<WavefrontPathSegment>> calcIsochronSegmentsForPhase(SeismicPhase phase, double timeStep) {
        HashMap<Double, List<WavefrontPathSegment>> out = new HashMap<Double, List<WavefrontPathSegment>>();
        if (!phase.hasArrivals()) {
            return out;
        }
        int totalNumSegments = (int)Math.floor(phase.getMaxTime() / timeStep) + 1;
        int waveSegIdx = 0;
        ArrayList<Arrival> allArrival = new ArrayList<Arrival>();
        int minArrivalsForPlot = 10;
        if (phase.getNumRays() > minArrivalsForPlot) {
            for (int i = 0; i < phase.getNumRays(); ++i) {
                RayParamIndexRay rc = new RayParamIndexRay(i);
                try {
                    allArrival.add(rc.calculate(phase).get(0));
                    continue;
                }
                catch (NoSuchLayerException | SlownessModelException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (phase.getMinRayParam() < phase.getMaxRayParam()) {
            double rpStep = (phase.getMaxRayParam() - phase.getMinRayParam()) / (double)minArrivalsForPlot;
            for (double rp = phase.getMinRayParam(); rp < phase.getMaxRayParam(); rp += rpStep) {
                RayParamRay rpRay = new RayParamRay(rp);
                try {
                    allArrival.addAll(rpRay.calculate(phase));
                    continue;
                }
                catch (TauPException e) {
                    throw new RuntimeException(e);
                }
            }
            RayParamRay rpRay = new RayParamRay(phase.getMaxRayParam());
            try {
                allArrival.addAll(rpRay.calculate(phase));
            }
            catch (TauPException e) {
                throw new RuntimeException(e);
            }
        } else {
            double distStep = (phase.getMaxDistance() - phase.getMinDistance()) / (double)minArrivalsForPlot;
            for (double distRadian = phase.getMinDistance(); distRadian < phase.getMaxDistance(); distRadian += distStep) {
                DistanceAngleRay dRay = DistanceRay.ofRadians(distRadian);
                allArrival.addAll(dRay.calculate(phase));
            }
            DistanceAngleRay dRay = DistanceRay.ofRadians(phase.getMaxDistance());
            allArrival.addAll(dRay.calculate(phase));
        }
        HashMap<Arrival, Integer> pathIdx = new HashMap<Arrival, Integer>();
        HashMap<Arrival, Integer> segIdx = new HashMap<Arrival, Integer>();
        HashMap<Arrival, TimeDist> prevTimeDistMap = new HashMap<Arrival, TimeDist>();
        for (Arrival arrival : allArrival) {
            pathIdx.put(arrival, 0);
            segIdx.put(arrival, 0);
            prevTimeDistMap.put(arrival, arrival.getSourceTimeDist());
        }
        double timeVal = 0.0;
        TimeDist sourcePoint = new TimeDist(phase.getMinRayParam(), 0.0, 0.0, phase.getSourceDepth());
        SeismicPhaseSegment initialSeg = phase.getInitialPhaseSegment();
        WavefrontPathSegment initialWaveSeg = WavefrontPathSegment.degenerateSegment(sourcePoint, initialSeg.getIsPWave(), initialSeg.getLegName(), sourcePoint, waveSegIdx++, totalNumSegments, phase, timeVal);
        out.put(timeVal, List.of(initialWaveSeg));
        boolean done = false;
        while (!done) {
            done = true;
            timeVal += timeStep;
            if (this.isVerbose()) {
                Alert.debug("wavefront calc for " + timeVal);
            }
            ArrayList<WavefrontPathSegment> wavefrontSegments = new ArrayList<WavefrontPathSegment>();
            out.put(timeVal, wavefrontSegments);
            WavefrontPathSegment curWaveSeg = null;
            if (phase.getName().endsWith("kmps")) {
                ArrayList<TimeDist> surfaceWaveTD = new ArrayList<TimeDist>();
                double dist = timeVal / phase.getRayParams(0);
                surfaceWaveTD.add(new TimeDist(phase.getRayParams(0), timeVal, dist, 0.0));
                surfaceWaveTD.add(new TimeDist(phase.getRayParams(0), timeVal, dist, 100.0));
                WavefrontPathSegment seg = new WavefrontPathSegment(surfaceWaveTD, false, phase.getName(), null, waveSegIdx, totalNumSegments, phase, timeVal);
                wavefrontSegments.add(seg);
                done = dist + timeStep / phase.getRayParams(0) > phase.getMaxDistance();
                continue;
            }
            if (phase instanceof ScatteredSeismicPhase && ((ScatteredSeismicPhase)phase).getInboundArrival().getTime() > timeVal) {
                Arrival inboundArrival = ((ScatteredSeismicPhase)phase).getInboundArrival();
                TimeDist prevTD = null;
                for (ArrivalPathSegment curPathSeg : inboundArrival.getPathSegments()) {
                    for (TimeDist currTD : curPathSeg.getPath()) {
                        if (prevTD != null && prevTD.getTime() <= timeVal && timeVal <= currTD.getTime()) {
                            TimeDist interp = this.interp(prevTD, currTD, timeVal);
                            TimeDist prevEnd = null;
                            curWaveSeg = WavefrontPathSegment.degenerateSegment(interp, curPathSeg.isPWave(), curPathSeg.getSegmentName(), prevEnd, waveSegIdx++, totalNumSegments, phase, timeVal);
                            wavefrontSegments.add(curWaveSeg);
                            done = false;
                            prevTD = currTD;
                            break;
                        }
                        prevTD = currTD;
                    }
                    if (!(prevTD.getTime() > timeVal)) continue;
                    break;
                }
                for (Arrival arrival : allArrival) {
                    segIdx.put(arrival, inboundArrival.getPathSegments().size());
                    pathIdx.put(arrival, 0);
                    prevTimeDistMap.put(arrival, inboundArrival.getPiercePoint(inboundArrival.getNumPiercePoints() - 1));
                }
                continue;
            }
            Arrival prevArrival = null;
            ArrivalPathSegment prevPathSeg = null;
            for (Arrival arrival : allArrival) {
                if (arrival.getTime() >= timeVal) {
                    done = false;
                    List<ArrivalPathSegment> segPath = arrival.getPathSegments();
                    ArrivalPathSegment curPathSeg = segPath.get((Integer)segIdx.get(arrival));
                    TimeDist prevTD = (TimeDist)prevTimeDistMap.get(arrival);
                    if (prevArrival != null && prevArrival.getTime() < timeVal) {
                        double distConnect = LinearInterpolation.linearInterp(prevArrival.getTime(), prevArrival.getDist(), arrival.getTime(), arrival.getDist(), timeVal);
                        double raypConnect = LinearInterpolation.linearInterp(prevArrival.getTime(), prevArrival.getRayParam(), arrival.getTime(), arrival.getRayParam(), timeVal);
                        TimeDist interp = new TimeDist(raypConnect, timeVal, distConnect, arrival.getReceiverDepth());
                        ArrivalPathSegment lastSeg = prevArrival.getPathSegments().get(prevArrival.getPathSegments().size() - 1);
                        if (curWaveSeg == null || curWaveSeg.isPWave() != lastSeg.isPWave()) {
                            TimeDist prevEnd = curWaveSeg == null ? null : curWaveSeg.getPathEnd();
                            ArrayList<TimeDist> tdList = new ArrayList<TimeDist>();
                            if (prevEnd != null) {
                                tdList.add(prevEnd);
                            }
                            curWaveSeg = new WavefrontPathSegment(tdList, lastSeg.isPWave(), lastSeg.getSegmentName(), prevEnd, waveSegIdx++, totalNumSegments, arrival.getPhase(), timeVal);
                            wavefrontSegments.add(curWaveSeg);
                        }
                        curWaveSeg.getPath().add(interp);
                    }
                    int i = (Integer)pathIdx.get(arrival);
                    while (curPathSeg != null) {
                        if (i == curPathSeg.getPath().size()) {
                            prevPathSeg = curPathSeg;
                            if ((Integer)segIdx.get(arrival) >= segPath.size() - 1) break;
                            i = 0;
                            pathIdx.put(arrival, 0);
                            segIdx.put(arrival, (Integer)segIdx.get(arrival) + 1);
                            curPathSeg = segPath.get((Integer)segIdx.get(arrival));
                        }
                        TimeDist currTD = curPathSeg.getPath().get(i);
                        pathIdx.put(arrival, i);
                        if (prevTD != null && prevTD.getTime() <= timeVal && timeVal <= currTD.getTime()) {
                            TimeDist interp = this.interp(prevTD, currTD, timeVal);
                            if (curWaveSeg == null || curWaveSeg.isPWave() != curPathSeg.isPWave()) {
                                TimeDist prevEnd = curWaveSeg == null ? null : curWaveSeg.getPathEnd();
                                ArrayList<TimeDist> tdList = new ArrayList<TimeDist>();
                                if (prevEnd != null) {
                                    boolean found = false;
                                    for (double disconDepth : phase.getTauModel().getVelocityModel().getDisconDepths()) {
                                        if (!((prevEnd.getDepth() - disconDepth) * (disconDepth - interp.getDepth()) > 0.0)) continue;
                                        TimeDist disconInterp = TimeDist.linearInterpOnDepth(prevEnd, interp, disconDepth);
                                        curWaveSeg.getPath().add(disconInterp);
                                        tdList.add(disconInterp);
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        tdList.add(prevEnd);
                                    }
                                }
                                curWaveSeg = new WavefrontPathSegment(tdList, curPathSeg.isPWave(), curPathSeg.getSegmentName(), prevEnd, waveSegIdx++, totalNumSegments, arrival.getPhase(), timeVal);
                                wavefrontSegments.add(curWaveSeg);
                            }
                            curWaveSeg.getPath().add(interp);
                            break;
                        }
                        prevTD = currTD;
                        prevTimeDistMap.put(arrival, currTD);
                        ++i;
                    }
                } else if (prevPathSeg != null) {
                    curWaveSeg = null;
                }
                prevArrival = arrival;
            }
            if (!((List)out.get(timeVal)).isEmpty()) continue;
            out.remove(timeVal);
        }
        return out;
    }

    TimeDist interp(TimeDist x, TimeDist y, double t) {
        double distInterp = LinearInterpolation.linearInterp(x.getTime(), x.getDistRadian(), y.getTime(), y.getDistRadian(), t);
        double depthInterp = LinearInterpolation.linearInterp(x.getTime(), x.getDepth(), y.getTime(), y.getDepth(), t);
        return new TimeDist(x.getP(), t, distInterp, depthInterp);
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public GraphicOutputTypeArgs getGraphicOutputTypeArgs() {
        return this.outputTypeArgs;
    }

    @CommandLine.Option(names={"--timestep"}, defaultValue="100", description={"steps in time (seconds) for output, default is ${DEFAULT-VALUE}"})
    public void setTimeStep(float timeStep) {
        if (timeStep <= 0.0f) {
            throw new IllegalArgumentException("TimeStep must be positive: " + timeStep);
        }
        this.timeStep = timeStep;
    }

    public boolean isSeparateFilesByTime() {
        return this.separateFilesByTime;
    }

    @CommandLine.Option(names={"--timefiles"}, description={"outputs each time into a separate file within the gmt script."})
    public void setSeparateFilesByTime(boolean separateFilesByTime) {
        this.separateFilesByTime = separateFilesByTime;
    }

    public boolean isNegDistance() {
        return this.negDistance;
    }

    @CommandLine.Option(names={"--negdist"}, description={"outputs negative distance as well so wavefronts are in both halves."})
    public void setNegDistance(boolean negDistance) {
        this.negDistance = negDistance;
    }

    @Override
    public void init() throws TauPException {
        super.init();
        this.setOutputFormat(this.outputTypeArgs.getOutputFormat());
    }

    @Override
    public void start() throws IOException, TauPException {
        Map<Double, List<PhaseIsochron>> isochronMap = this.calcIsochron();
        ArrayList<Double> sortedKeys = new ArrayList<Double>(isochronMap.keySet());
        Collections.sort(sortedKeys);
        if (this.isSeparateFilesByTime()) {
            Double lastTime = (Double)sortedKeys.get(sortedKeys.size() - 1);
            int numDigits = 1;
            while (Math.pow(10.0, numDigits) < lastTime) {
                ++numDigits;
            }
            for (Double timeVal : sortedKeys) {
                String timeStr = String.format("_%05.2f", timeVal);
                HashMap<Double, List<PhaseIsochron>> singleTimeIsochronMap = new HashMap<Double, List<PhaseIsochron>>();
                singleTimeIsochronMap.put(timeVal, isochronMap.get(timeVal));
                File timeOutFile = new File(this.outputTypeArgs.getOutFileBase() + timeStr + "." + this.outputTypeArgs.getOutFileExtension());
                PrintWriter timeWriter = new PrintWriter(new BufferedWriter(new FileWriter(timeOutFile)));
                this.printIsochron(timeWriter, singleTimeIsochronMap);
                timeWriter.close();
            }
        } else {
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            this.printIsochron(writer, isochronMap);
            writer.close();
        }
    }

    @Override
    public void destroy() throws TauPException {
    }
}

