/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import picocli.CommandLine;

public abstract class AbstractOutputTypeArgs {
    String outFileBase = "taup";
    protected String extension = null;
    public static final String STDOUT_FILENAME = "-";
    public static final String OUTPUTTYPE_HEADING = "Output Type:%n";

    public AbstractOutputTypeArgs(String filebase) {
        this.setOutFileBase(filebase);
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"output to file, default is stdout."})
    public void setOutFile(String outfile) {
        this.setOutFileBase(outfile);
    }

    public abstract void setOutputFormat(String var1);

    public abstract String getOutputFormat();

    public String getOutFileBase() {
        return this.outFileBase;
    }

    public void setOutFileBase(String outFileBase) {
        this.outFileBase = outFileBase;
    }

    public abstract String getOutFileExtension();

    public void setOutFileExtension(String ext) {
        this.extension = ext;
    }

    public boolean isStdout() {
        return this.getOutFileBase() == null || this.getOutFileBase().isEmpty() || this.getOutFileBase().equals(STDOUT_FILENAME) || this.getOutFileBase().equals("stdout");
    }

    public String getOutFile() {
        if (this.isStdout()) {
            return "stdout";
        }
        if (this.getOutFileExtension() == null || this.getOutFileExtension().isEmpty() || this.getOutFileBase().endsWith("." + this.getOutFileExtension())) {
            return this.getOutFileBase();
        }
        return this.getOutFileBase() + "." + this.getOutFileExtension();
    }

    public PrintWriter createWriter(PrintWriter stdout) throws IOException {
        if (this.isStdout()) {
            return stdout;
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile())));
    }
}

