/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.StdModelGenerator;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import picocli.CommandLine;

public class TableModelArgs {
    @CommandLine.Option(names={"--mod", "--model"}, defaultValue="iasp91", description={"use velocity model \"modelName\" for calculations. ", "Default is ${DEFAULT-VALUE}. Other builtin models include prem, ak135, ak135fcont, and ak135favg."}, completionCandidates=StdModelGenerator.StdModelCandidates.class)
    String modelName = toolProps.getProperty("taup.model.name", "iasp91");
    @CommandLine.Option(names={"--stadepth", "--receiverdepth"}, defaultValue="0.0", paramLabel="depth", split=",", description={"the receiver depth in km for stations not at the surface"})
    List<Double> receiverDepths = new ArrayList<Double>();
    public Double scattererDepth;
    public Double scattererDist;
    static Properties toolProps = TauP_Tool.configDefaults();

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public TauModel getTauModel() throws TauModelException {
        return TauModelLoader.load(this.getModelName());
    }

    public List<Double> getReceiverDepths() {
        if (this.receiverDepths.isEmpty()) {
            this.receiverDepths.add(0.0);
        }
        return this.receiverDepths;
    }

    @CommandLine.Option(names={"--scat", "--scatter"}, arity="2", paramLabel="depth deg", hideParamSyntax=true, description={"scattering depth and distance in degrees, which may be negative. Only effects phases with 'o' or 'O' in the phase name."})
    public void setScatterer(List<Double> depth_dist) {
        if (depth_dist.size() == 2) {
            this.setScatterer(depth_dist.get(0), depth_dist.get(1));
        } else {
            this.unsetScatterer();
        }
    }

    public void setScatterer(double depth, double dist) {
        this.scattererDepth = depth;
        this.scattererDist = dist;
    }

    public void unsetScatterer() {
        this.scattererDepth = null;
        this.scattererDist = null;
    }

    public Scatterer getScatterer() {
        if (this.scattererDepth != null && this.scattererDist != null) {
            return new Scatterer((double)this.scattererDepth, this.scattererDist);
        }
        return null;
    }
}

