/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

public class Utility {
    public static short bytesToShort(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (short)((a & 0xFF) + (b & 0xFF) << 8);
        }
        return (short)(((a & 0xFF) << 8) + (b & 0xFF));
    }

    public static int bytesToInt(byte a) {
        return a;
    }

    public static int bytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, byte c, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + (c << 16);
        }
        return (a << 16) + ((b & 0xFF) << 8) + (c & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, byte c, byte d, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    public static long bytesToLong(byte a, byte b, byte c, byte d, byte e, byte f, byte g, byte h, boolean swapBytes) {
        if (swapBytes) {
            return ((long)a & 0xFFL) + (((long)b & 0xFFL) << 8) + (((long)c & 0xFFL) << 16) + (((long)d & 0xFFL) << 24) + (((long)e & 0xFFL) << 32) + (((long)f & 0xFFL) << 40) + (((long)g & 0xFFL) << 48) + (((long)h & 0xFFL) << 56);
        }
        return (((long)a & 0xFFL) << 56) + (((long)b & 0xFFL) << 48) + (((long)c & 0xFFL) << 40) + (((long)d & 0xFFL) << 32) + (((long)e & 0xFFL) << 24) + (((long)f & 0xFFL) << 16) + (((long)g & 0xFFL) << 8) + ((long)h & 0xFFL);
    }

    public static int uBytesToInt(byte a) {
        return a & 0xFF;
    }

    public static int uBytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8);
        }
        return ((a & 0xFF) << 8) + (b & 0xFF);
    }

    public static long uBytesToLong(byte a, byte b, byte c, byte d, boolean swapBytes) {
        if (swapBytes) {
            return ((long)a & 0xFFL) + (((long)b & 0xFFL) << 8) + (((long)c & 0xFFL) << 16) + (((long)d & 0xFFL) << 24);
        }
        return (((long)a & 0xFFL) << 24) + (((long)b & 0xFFL) << 16) + (((long)c & 0xFFL) << 8) + ((long)d & 0xFFL);
    }

    public static byte[] longToIntBytes(long a) {
        byte[] returnByteArray = new byte[]{(byte)((a & 0xFFFFFFFFFF000000L) >> 24), (byte)((a & 0xFF0000L) >> 16), (byte)((a & 0xFF00L) >> 8), (byte)(a & 0xFFL)};
        return returnByteArray;
    }

    public static byte[] intToShortBytes(int a) {
        byte[] returnByteArray = new byte[]{(byte)((a & 0xFF00) >> 8), (byte)(a & 0xFF)};
        return returnByteArray;
    }

    public static byte[] pad(byte[] source, int requiredBytes, byte paddingByte) {
        if (source.length >= requiredBytes) {
            return source;
        }
        byte[] returnByteArray = new byte[requiredBytes];
        System.arraycopy(source, 0, returnByteArray, 0, source.length);
        for (int i = source.length; i < requiredBytes; ++i) {
            returnByteArray[i] = paddingByte;
        }
        return returnByteArray;
    }

    public static byte[] format(byte[] source, int start, int end) {
        byte[] returnByteArray = new byte[start - end + 1];
        int j = 0;
        int i = start;
        while (i < end) {
            returnByteArray[j] = source[i];
            ++i;
            ++j;
        }
        return returnByteArray;
    }
}

